/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.item.ItemMagicBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class BlockCropMagicBean
extends BlockCrops
implements IHasConfig {
    public static final int MAX_AGE = 7;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    private static final AxisAlignedBB[] AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0)};
    private List<ItemStack> myDrops = new ArrayList<ItemStack>();
    private ItemMagicBean seed;
    private boolean allowBonemeal;
    private boolean dropSeedOnHarvest;
    private ArrayList<String> myDropStrings;

    public BlockCropMagicBean() {
        Item[] drops = new Item[]{Items.field_151137_ax, Items.field_151016_H, Items.field_151114_aO, Items.field_151045_i, Items.field_151166_bC, Items.field_151044_h, Items.field_151074_bl, Items.field_151042_j, Items.field_151043_k, Items.field_151156_bN, Items.field_151128_bU, Items.field_151058_ca, Items.field_151057_cb, Items.field_151079_bi, Items.field_151061_bv, Items.field_151123_aH, Items.field_151065_br, Items.field_151072_bj, Items.field_151116_aA, Items.field_151078_bh, Items.field_151103_aS, Items.field_151007_F, Items.field_151070_bp, Items.field_151145_ak, Items.field_151073_bk, Items.field_151034_e, Items.field_151055_y, Items.field_151102_aT, Items.field_179566_aV, Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV, Items.field_151015_O, Items.field_151127_ba, Items.field_185163_cU, Items.field_151081_bc, Items.field_151080_bb, Items.field_151014_N, Items.field_151110_aK, Items.field_151111_aL, Items.field_151113_aN, Items.field_151066_bu, Items.field_151132_bS, Items.field_151107_aW, Items.field_151059_bz, Items.field_151170_bI, Items.field_179556_br, Items.field_179555_bs, Items.field_151158_bO, Items.field_151071_bq, Items.field_151062_by, Items.field_151162_bE, Items.field_151160_bD, Items.field_151159_an, Items.field_151105_aU, Items.field_151106_aX, Items.field_151060_bw, Items.field_151126_ay, Items.field_151069_bo, Items.field_151122_aG, Items.field_151121_aF, Items.field_151119_aD, Items.field_151118_aC, Items.field_151075_bm, Item.func_150898_a((Block)Blocks.field_150327_N), Item.func_150898_a((Block)Blocks.field_150337_Q), Item.func_150898_a((Block)Blocks.field_150338_P), Item.func_150898_a((Block)Blocks.field_150329_H), Item.func_150898_a((Block)Blocks.field_150436_aH), Item.func_150898_a((Block)Blocks.field_150330_I), Item.func_150898_a((Block)Blocks.field_150434_aF), Item.func_150898_a((Block)Blocks.field_150395_bd), Item.func_150898_a((Block)Blocks.field_150392_bi), Item.func_150898_a((Block)Blocks.field_185764_cQ), Item.func_150898_a((Block)Blocks.field_185765_cR)};
        this.myDrops.add(new ItemStack(Items.field_151044_h, 1, 1));
        this.myDrops.add(new ItemStack(Blocks.field_150423_aK));
        this.myDrops.add(new ItemStack(Blocks.field_150428_aP));
        this.myDrops.add(new ItemStack(Blocks.field_150379_bu));
        for (Item item : drops) {
            this.myDrops.add(new ItemStack(item));
        }
        for (Item item : EnumDyeColor.values()) {
            this.myDrops.add(new ItemStack(Items.field_151100_aR, 1, item.func_176765_a()));
            this.myDrops.add(new ItemStack(Blocks.field_150406_ce, 1, item.func_176765_a()));
            this.myDrops.add(new ItemStack(Blocks.field_150325_L, 1, item.func_176765_a()));
            this.myDrops.add(new ItemStack((Block)Blocks.field_150399_cn, 1, item.func_176765_a()));
            this.myDrops.add(new ItemStack((Block)Blocks.field_150397_co, 1, item.func_176765_a()));
        }
        for (Item item : ItemFishFood.FishType.values()) {
            this.myDrops.add(new ItemStack(Items.field_151115_aP, 1, item.func_150976_a()));
        }
        for (Item item : BlockPlanks.EnumType.values()) {
            this.myDrops.add(new ItemStack(Blocks.field_150345_g, 1, item.func_176839_a()));
        }
        for (Item item : BlockFlower.EnumFlowerType.values()) {
            this.myDrops.add(new ItemStack((Block)Blocks.field_150328_O, 1, item.func_176968_b()));
        }
        for (Item item : BlockDoublePlant.EnumPlantType.values()) {
            this.myDrops.add(new ItemStack((Block)Blocks.field_150398_cm, 1, item.func_176936_a()));
        }
    }

    protected PropertyInteger func_185524_e() {
        return AGE;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.func_185525_y(state) ? this.func_149866_i() : this.func_149866_i();
    }

    protected Item func_149866_i() {
        return this.seed;
    }

    public void setSeed(ItemMagicBean item) {
        this.seed = item;
    }

    protected Item func_149865_P() {
        return null;
    }

    private ItemStack getCropStack(Random rand) {
        String res = this.myDropStrings.get(rand.nextInt(this.myDropStrings.size()));
        try {
            String[] ares = res.split(Pattern.quote("*"));
            Item item = Item.func_111206_d((String)ares[0]);
            if (item == null) {
                ModCyclic.logger.error("Magic Bean config: loot item not found " + res);
                this.myDropStrings.remove(res);
                return this.getCropStack(rand);
            }
            String meta = ares.length > 1 ? ares[1] : "0";
            int imeta = Integer.parseInt(meta);
            ItemStack stack = new ItemStack(item, 1, imeta);
            return stack;
        }
        catch (Exception e) {
            ModCyclic.logger.error("Magic Bean config: loot item not found " + res);
            ModCyclic.logger.error(e.getMessage());
            return new ItemStack(Blocks.field_150346_d);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
    }

    public int func_149745_a(Random random) {
        return super.func_149745_a(random) + 1;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        boolean isGrown = this.func_185525_y(state);
        if (isGrown) {
            Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
            int count = this.quantityDropped(state, fortune, rand);
            for (int i = 0; i < count; ++i) {
                ret.add(this.getCropStack(rand).func_77946_l());
            }
        }
        if (!isGrown || this.dropSeedOnHarvest) {
            ret.add(new ItemStack(this.func_149866_i()));
        }
        return ret;
    }

    public int func_185526_g() {
        return 7;
    }

    protected int func_185529_b(World worldIn) {
        return this.allowBonemeal ? 1 : 0;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return this.func_185529_b(worldIn) > 0;
    }

    @Override
    public void syncConfig(Configuration config) {
        String category = "cyclicmagic.blocks.magicbean";
        this.allowBonemeal = config.getBoolean("MagicBeanBonemeal", category, true, "Allow bonemeal on magic bean");
        this.dropSeedOnHarvest = config.getBoolean("MagicBeanGrownDropSeed", category, true, "Allow dropping the seed item if fully grown.  (if its not grown it will still drop when broken)");
        ArrayList<String> deft = new ArrayList<String>();
        for (ItemStack drop : this.myDrops) {
            if (drop == null || drop.func_77973_b() == null) continue;
            String resource = drop.func_77973_b().getRegistryName().func_110624_b() + ":" + drop.func_77973_b().getRegistryName().func_110623_a();
            if (drop.func_77960_j() > 0) {
                resource = resource + "*" + drop.func_77960_j();
            }
            deft.add(resource);
        }
        this.myDropStrings = new ArrayList<String>(Arrays.asList(config.getStringList("MagicBeanDropList", category, deft.toArray(new String[0]), "Drop list")));
        if (this.myDropStrings.size() == 0) {
            this.myDropStrings.add("minecraft:dirt");
        }
    }
}

