/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.integration.TeslaIntegration;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.CableUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.content.turbine.TurbineFluidTank;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityTurbineValve
extends TileEntityTurbineCasing
implements IFluidHandlerWrapper,
IEnergyWrapper {
    public boolean ic2Registered = false;
    public TurbineFluidTank fluidTank;
    private CapabilityWrapperManager teslaManager = new CapabilityWrapperManager(IEnergyWrapper.class, TeslaIntegration.class);

    public TileEntityTurbineValve() {
        super("TurbineValve");
        this.fluidTank = new TurbineFluidTank(this);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.ic2Registered && MekanismUtils.useIC2()) {
            this.register();
        }
        if (!this.field_145850_b.field_72995_K && this.structure != null) {
            double prev = this.getEnergy();
            CableUtils.emit((IEnergyWrapper)this);
        }
    }

    public EnumSet<EnumFacing> getOutputtingSides() {
        if (this.structure != null) {
            EnumSet<EnumFacing> set = EnumSet.allOf(EnumFacing.class);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if (!((SynchronizedTurbineData)this.structure).locations.contains(Coord4D.get((TileEntity)this).offset(side))) continue;
                set.remove(side);
            }
            return set;
        }
        return EnumSet.noneOf(EnumFacing.class);
    }

    public EnumSet<EnumFacing> getConsumingSides() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Optional.Method(modid="IC2")
    public void register() {
        IEnergyTile registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTile(this.field_145850_b, this.func_174877_v())) != this) {
            if (registered instanceof IEnergyTile) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(registered));
            } else if (registered == null) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
                this.ic2Registered = true;
            }
        }
    }

    @Optional.Method(modid="IC2")
    public void deregister() {
        IEnergyTile registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTile(this.field_145850_b, this.func_174877_v())) instanceof IEnergyTile) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(registered));
        }
    }

    public double getMaxOutput() {
        return this.structure != null ? ((SynchronizedTurbineData)this.structure).getEnergyCapacity() : 0.0;
    }

    public void onAdded() {
        super.onAdded();
        if (MekanismUtils.useIC2()) {
            this.register();
        }
    }

    public void onChunkUnload() {
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (this.getOutputtingSides().contains(from)) {
            double toSend = Math.min(this.getEnergy(), Math.min(this.getMaxOutput(), (double)maxExtract * MekanismConfig.general.FROM_RF));
            if (!simulate) {
                this.setEnergy(this.getEnergy() - toSend);
            }
            return (int)Math.round(toSend * MekanismConfig.general.TO_RF);
        }
        return 0;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return this.structure != null;
    }

    public int getEnergyStored(EnumFacing from) {
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_RF);
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return (int)Math.round(this.getMaxEnergy() * MekanismConfig.general.TO_RF);
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public void setStored(int energy) {
        this.setEnergy((double)energy * MekanismConfig.general.FROM_IC2);
    }

    @Optional.Method(modid="IC2")
    public int addEnergy(int amount) {
        return 0;
    }

    @Optional.Method(modid="IC2")
    public boolean isTeleporterCompatible(EnumFacing side) {
        return this.canOutputTo(side);
    }

    public boolean canOutputTo(EnumFacing side) {
        return this.getOutputtingSides().contains(side);
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return false;
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return this.getOutputtingSides().contains(direction) && receiver instanceof IEnergyConductor;
    }

    @Optional.Method(modid="IC2")
    public int getStored() {
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public int getCapacity() {
        return (int)Math.round(this.getMaxEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public int getOutput() {
        return (int)Math.round(this.getMaxOutput() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        return Math.min(this.getEnergy(), this.getMaxOutput()) * MekanismConfig.general.TO_IC2;
    }

    public boolean canReceiveEnergy(EnumFacing side) {
        return false;
    }

    @Optional.Method(modid="IC2")
    public double getOutputEnergyUnitsPerTick() {
        return this.getMaxOutput() * MekanismConfig.general.TO_IC2;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(EnumFacing direction, double amount, double voltage) {
        return amount;
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount) {
        if (this.structure != null) {
            double toDraw = Math.min(amount * MekanismConfig.general.FROM_IC2, this.getMaxOutput());
            this.setEnergy(Math.max(this.getEnergy() - toDraw, 0.0));
        }
    }

    public double transferEnergyToAcceptor(EnumFacing side, double amount) {
        return 0.0;
    }

    public double removeEnergyFromProvider(EnumFacing side, double amount) {
        if (!this.getOutputtingSides().contains(side)) {
            return 0.0;
        }
        double toGive = Math.min(this.getEnergy(), amount);
        this.setEnergy(this.getEnergy() - toGive);
        return toGive;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.fluidTank.getInfo();
        } else {
            fluidTankInfoArray = PipeUtils.EMPTY;
        }
        return fluidTankInfoArray;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.structure == null) {
            return 0;
        }
        int filled = this.fluidTank.fill(resource, doFill);
        if (doFill) {
            ((SynchronizedTurbineData)this.structure).newSteamInput += filled;
        }
        if (filled < ((SynchronizedTurbineData)this.structure).getFluidCapacity() && ((SynchronizedTurbineData)this.structure).dumpMode != TileEntityGasTank.GasMode.IDLE) {
            filled = ((SynchronizedTurbineData)this.structure).getFluidCapacity();
        }
        return filled;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (fluid == FluidRegistry.getFluid((String)"steam")) {
            return !this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure;
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    @Override
    public String func_70005_c_() {
        return LangUtils.localize((String)"gui.industrialTurbine");
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.CABLE_OUTPUTTER_CAPABILITY || capability == Capabilities.TESLA_HOLDER_CAPABILITY || capability == Capabilities.TESLA_PRODUCER_CAPABILITY && this.getOutputtingSides().contains(this.facing))) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, side);
            }
            if (capability == Capabilities.TESLA_HOLDER_CAPABILITY || capability == Capabilities.TESLA_PRODUCER_CAPABILITY && this.getOutputtingSides().contains(this.facing)) {
                return (T)this.teslaManager.getWrapper((Object)this, this.facing);
            }
        }
        return (T)super.getCapability(capability, side);
    }
}

