/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.items.rftoolsmodule;

import elec332.core.world.WorldHelper;
import mcjty.deepresonance.blocks.tank.TankSetup;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.deepresonance.items.rftoolsmodule.ModuleDataRCL;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.FluidStack;

public class RCLScreenModule
implements IScreenModule<ModuleDataRCL> {
    private int dim = 0;
    private BlockPos coordinate = BlockPosTools.INVALID;

    public ModuleDataRCL getData(IScreenDataHelper h, World worldObj, long millis) {
        LiquidCrystalFluidTagData data;
        FluidStack fluidStack;
        TileTank tank;
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return null;
        }
        if (!WorldHelper.chunkLoaded((World)world, (BlockPos)this.coordinate)) {
            return null;
        }
        Block block = world.func_180495_p(this.coordinate).func_177230_c();
        if (block != TankSetup.tank) {
            return null;
        }
        int purity = 0;
        int strength = 0;
        int efficiency = 0;
        TileEntity te = world.func_175625_s(this.coordinate);
        if (te instanceof TileTank && (tank = (TileTank)te).getTank() != null && (fluidStack = tank.getTank().drain(1, false)) != null && (data = LiquidCrystalFluidTagData.fromStack(fluidStack)) != null) {
            purity = (int)(((double)data.getPurity() + 0.005) * 100.0);
            strength = (int)(((double)data.getStrength() + 0.005) * 100.0);
            efficiency = (int)(((double)data.getEfficiency() + 0.005) * 100.0);
        }
        return new ModuleDataRCL(purity, strength, efficiency);
    }

    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.func_74764_b("monitorx")) {
                this.dim = tagCompound.func_74764_b("monitordim") ? tagCompound.func_74762_e("monitordim") : tagCompound.func_74762_e("dim");
                if (dim == this.dim) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    public int getRfPerTick() {
        return RadiationConfiguration.RCLMODULE_RFPERTICK;
    }

    public void mouseClick(World world, int x, int y, boolean clicked, EntityPlayer player) {
    }
}

