/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.commands;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.deepresonance.commands.DRCommand;
import mcjty.lib.compat.CompatCommand;
import mcjty.lib.compat.CompatCommandBase;
import mcjty.lib.tools.ChatTools;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class DefaultCommand
implements CompatCommand {
    protected final Map<String, DRCommand> commands = Maps.newHashMap();

    public DefaultCommand() {
        this.registerCommand(new CmdHelp());
    }

    protected void registerCommand(DRCommand command) {
        this.commands.put(command.getCommand(), command);
    }

    public void showHelp(ICommandSender sender) {
        ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.BLUE + this.func_71517_b() + " <subcommand> <args>"));
        for (Map.Entry<String, DRCommand> me : this.commands.entrySet()) {
            ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString("    " + me.getKey() + " " + me.getValue().getHelp()));
        }
    }

    public String func_71518_a(ICommandSender sender) {
        return this.func_71517_b() + " <subcommand> <args> (try '" + this.func_71517_b() + " help' for more info)";
    }

    public List<String> func_71514_a() {
        return ImmutableList.of();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World world = sender.func_130014_f_();
        if (args.length <= 0) {
            if (!world.field_72995_K) {
                this.showHelp(sender);
            }
        } else {
            DRCommand command = this.commands.get(args[0]);
            if (command == null) {
                if (!world.field_72995_K) {
                    ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "Unknown Deep Resonance command: " + args[0]));
                }
            } else if (world.field_72995_K) {
                if (command.isClientSide()) {
                    command.execute(sender, args);
                }
            } else if (!CompatCommandBase.canUseCommand((ICommandSender)sender, (int)command.getPermissionLevel(), (String)this.func_71517_b())) {
                ChatTools.addChatMessage((ICommandSender)sender, (ITextComponent)new TextComponentString(TextFormatting.RED + "Command is not allowed!"));
            } else {
                command.execute(sender, args);
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        return ImmutableList.of();
    }

    public boolean func_82358_a(String[] sender, int p_82358_2_) {
        return false;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int compareTo(ICommand command) {
        return this.func_71517_b().compareTo(command.func_71517_b());
    }

    class CmdHelp
    implements DRCommand {
        CmdHelp() {
        }

        @Override
        public String getHelp() {
            return "";
        }

        @Override
        public int getPermissionLevel() {
            return 0;
        }

        @Override
        public boolean isClientSide() {
            return false;
        }

        @Override
        public String getCommand() {
            return "help";
        }

        @Override
        public void execute(ICommandSender sender, String[] args) {
            DefaultCommand.this.showHelp(sender);
        }
    }
}

