/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.grids;

import com.rwtema.extrautils2.grids.Grid;
import com.rwtema.extrautils2.grids.GridType;
import com.rwtema.extrautils2.grids.TileGridRef;
import com.rwtema.extrautils2.tile.XUTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public abstract class XUTileGrid
extends XUTile {
    TileGridRef<XUTileGrid> myRef = new TileGridRef<XUTileGrid>(this);
    final HashMap<GridType, Grid> gridTypes = new HashMap();

    protected XUTileGrid(GridType ... gridTypes) {
        for (GridType gridType : gridTypes) {
            this.gridTypes.put(gridType, null);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (Grid grid : this.myRef.grids) {
            grid.destroy();
        }
        this.myRef.grids.clear();
    }

    public void loadIntoGrids() {
        List<XUTileGrid> xuTileGrids = this.adjacentTiles();
        for (Map.Entry<GridType, Grid> entry2 : this.gridTypes.entrySet()) {
            if (entry2.getValue() != null && entry2.getValue().isValid) continue;
            GridType gridType = entry2.getKey();
            Grid myGrid = null;
            for (XUTileGrid xuTileGrid : xuTileGrids) {
                Grid otherGrid = xuTileGrid.gridTypes.get(gridType);
                if (otherGrid == null) continue;
                if (myGrid == null) {
                    myGrid = otherGrid;
                    continue;
                }
                myGrid = gridType.mergeGrids(myGrid, otherGrid);
            }
            if (myGrid == null) {
                myGrid = gridType.createGrid();
            }
            myGrid.add(this);
        }
    }

    public List<XUTileGrid> adjacentTiles() {
        ArrayList<XUTileGrid> list = new ArrayList<XUTileGrid>(2);
        for (EnumFacing enumFacing : EnumFacing.values()) {
            XUTileGrid tileGrid;
            TileEntity tileEntity;
            BlockPos offset = this.field_174879_c.func_177972_a(enumFacing);
            if (enumFacing != EnumFacing.UP && enumFacing != EnumFacing.DOWN && !this.field_145850_b.func_175667_e(offset) || !((tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c)) instanceof XUTileGrid) || !this.isUnblockedNeighbour(enumFacing, tileGrid = (XUTileGrid)tileEntity) || !tileGrid.isUnblockedNeighbour(enumFacing.func_176734_d(), this)) continue;
            list.add(tileGrid);
        }
        return list;
    }

    protected boolean isUnblockedNeighbour(EnumFacing enumFacing, XUTileGrid otherTile) {
        return true;
    }
}

