/*
 * Decompiled with CFR 0.152.
 */
package zairus.weaponcaseloot.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.weaponcaseloot.WCLConfig;
import zairus.weaponcaseloot.WCLConstants;
import zairus.weaponcaseloot.WeaponCaseLoot;
import zairus.weaponcaseloot.item.WCLItem;
import zairus.weaponcaseloot.item.WCLItems;
import zairus.weaponcaseloot.item.WeaponSword;
import zairus.weaponcaseloot.sound.WCLSoundEvents;

public class WeaponBow
extends ItemBow {
    public static final String[] bowPullIconNameArray = new String[]{"", "_pulling_0", "_pulling_1", "_pulling_2"};

    public WeaponBow() {
        this.func_77637_a(WeaponCaseLoot.weaponCaseLootTab);
        this.func_77664_n();
        this.func_77625_d(1);
    }

    public WeaponBow setDurability(int durability) {
        this.func_77656_e(durability);
        return this;
    }

    public WeaponBow setUnlocalizedName(String name) {
        super.func_77655_b(name);
        return this;
    }

    public int func_77612_l() {
        return super.func_77612_l();
    }

    public int getMaxDamage(ItemStack stack) {
        int maxDamage = this.func_77612_l();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("weapon_durability")) {
            maxDamage = stack.func_77978_p().func_74762_e("weapon_durability");
        }
        return maxDamage;
    }

    public static float getDrawSpeed(ItemStack stack) {
        NBTTagCompound tag;
        float drawSpeed = 1.0f;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("weapon_speed")) {
            drawSpeed = tag.func_74760_g("weapon_speed");
        }
        return drawSpeed;
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        if (player.field_71075_bZ.field_75098_d) {
            return new ItemStack(Items.field_151032_g);
        }
        return null;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int useCount) {
        int j = this.func_77626_a(stack) - useCount;
        EntityPlayer player = (EntityPlayer)entity;
        boolean flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        ItemStack itemStack = this.findAmmo(player);
        int charge = this.func_77626_a(stack) - useCount;
        if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)player, (int)charge, (itemStack != null || flag ? 1 : 0) != 0)) < 0) {
            return;
        }
        j = charge;
        if (flag || itemStack != null) {
            float f = (float)j / 25.0f;
            f = (f * f + f * 2.0f) / 3.0f;
            float drawSpeed = WeaponBow.getDrawSpeed(stack);
            if ((double)(f *= drawSpeed) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            int k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
            int l = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
            int m = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack);
            int s = 0;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74764_b("weapon_multi")) {
                s = tag.func_74762_e("weapon_multi");
            }
            if (s == 0) {
                s = 1;
            }
            for (int i = 0; i < s; ++i) {
                ItemArrow itemarrow = (ItemArrow)(itemStack.func_77973_b() instanceof ItemArrow ? itemStack.func_77973_b() : Items.field_151032_g);
                EntityArrow entityarrow = itemarrow.func_185052_a(world, itemStack, (EntityLivingBase)player);
                entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                if (f == 1.0f) {
                    entityarrow.func_70243_d(true);
                }
                if (k > 0) {
                    entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)k * 0.5 + 0.5);
                }
                if (l > 0) {
                    entityarrow.func_70240_a(l + 1);
                }
                if (m > 0) {
                    entityarrow.func_70015_d(100);
                }
                if (flag || i > 0) {
                    entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                }
                if (world.field_72995_K) continue;
                world.func_72838_d((Entity)entityarrow);
            }
            if (!world.field_72995_K) {
                world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            }
            if (!flag) {
                --itemStack.field_77994_a;
                if (itemStack.field_77994_a == 0) {
                    player.field_71071_by.func_184437_d(itemStack);
                }
            }
            player.func_71029_a(StatList.func_188057_b((Item)this));
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        boolean flag = this.findAmmo(player) != null;
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!player.field_71075_bZ.field_75098_d && !flag) {
            return !flag ? new ActionResult(EnumActionResult.FAIL, (Object)stack) : new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        player.func_184598_c(hand);
        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, WCLSoundEvents.draw, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b1) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && !tag.func_74764_b("temp_looping")) {
            list.add("Third edition Bow.");
            if (tag.func_74764_b("weapon_state")) {
                list.add("Quality: " + tag.func_74779_i("weapon_state"));
            }
            if (tag.func_74764_b("weapon_rarity")) {
                list.add("Rarity: " + tag.func_74779_i("weapon_rarity"));
            }
            if (tag.func_74764_b("weapon_speed")) {
                list.add("Draw speed: " + tag.func_74760_g("weapon_speed"));
            }
            if (tag.func_74764_b("weapon_multi")) {
                list.add("Multi: " + tag.func_74762_e("weapon_multi"));
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77619_b() {
        return Item.ToolMaterial.GOLD.func_77995_e();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i1, boolean b1) {
        NBTTagCompound tag;
        if ((stack = WCLItem.correctNameColor(stack)).func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("weapon_looptimer")) {
            stack = WCLItem.loop(stack, "Weapon Bow", WCLSoundEvents.bow_open, WCLConfig.bow_rarity, world, entity, 0, 12);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (int i = 0; i < 12; ++i) {
            for (int q = 0; q < 5; ++q) {
                list.add(this.getFromId(i, q));
            }
        }
    }

    public ItemStack getFromId(int id, int quality) {
        ItemStack stack = new ItemStack(WCLItems.bow, 1);
        int rarity = WCLConfig.bow_rarity[id];
        NBTTagCompound weaponData = new NBTTagCompound();
        weaponData.func_74778_a("weapon_state", WCLConstants.weapon_quality[quality]);
        weaponData.func_74778_a("weapon_rarity", WCLConstants.weapon_rarity[rarity]);
        weaponData.func_74776_a("weapon_looptimer", 100.0f);
        weaponData.func_74768_a("weapon_index", id);
        weaponData.func_74768_a("weapon_durability", WeaponSword.getWeaponDurability(quality, rarity));
        weaponData.func_74776_a("weapon_speed", WCLConfig.bow_drawspeed[id]);
        if (rarity > 1 && field_77697_d.nextInt(3 + rarity) > 1) {
            weaponData.func_74768_a("weapon_multi", field_77697_d.nextInt(3) + 2);
        }
        stack.func_77982_d(weaponData);
        stack.func_151001_c(this.getNameFromId(id));
        return stack;
    }

    public String getNameFromId(int id) {
        int rarity = WCLConfig.bow_rarity[id];
        String[] levels_colors = new String[]{"\u00a7b", "\u00a7a", "\u00a7e", "\u00a76"};
        String name = levels_colors[rarity] + WCLConfig.bow_names[id];
        return name;
    }

    public boolean updatesFOV() {
        return true;
    }

    public int getFOVDuration(ItemStack stack) {
        float drawSpeed = WeaponBow.getDrawSpeed(stack);
        return (int)(10000.0f / drawSpeed);
    }

    public float getFOVValue(ItemStack stack) {
        NBTTagCompound tag;
        float drawSpeed = 1.0f;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("weapon_speed")) {
            drawSpeed = tag.func_74760_g("weapon_speed");
        }
        return 0.4f * (drawSpeed * 1.3f);
    }

    public float getFOVSpeedFactor(ItemStack stack) {
        return 350.0f;
    }
}

