/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.PowerUnits;
import appeng.coremod.annotations.Integration;
import appeng.integration.IntegrationType;
import appeng.tile.powersink.AERootPoweredTile;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.util.EnumFacing;

@Integration.Interface(iname=IntegrationType.RF, iface="cofh.api.energy.IEnergyReceiver")
public abstract class RedstoneFlux
extends AERootPoweredTile
implements IEnergyReceiver {
    public final int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int networkRFDemand = (int)Math.floor(this.getExternalPowerDemand(PowerUnits.RF, maxReceive));
        int usedRF = Math.min(maxReceive, networkRFDemand);
        if (!simulate) {
            this.injectExternalPower(PowerUnits.RF, usedRF);
        }
        return usedRF;
    }

    public final int getEnergyStored(EnumFacing from) {
        return (int)Math.floor(PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower()));
    }

    public final int getMaxEnergyStored(EnumFacing from) {
        return (int)Math.floor(PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower()));
    }

    public final boolean canConnectEnergy(EnumFacing from) {
        return this.getPowerSides().contains(from);
    }
}

