/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.export;

import appeng.core.AELog;
import appeng.services.export.CheckType;
import appeng.services.export.Checker;
import appeng.services.export.ExportConfig;
import appeng.services.export.ExportMode;
import appeng.services.export.MinecraftItemCSVExporter;
import appeng.services.export.ModListChecker;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameData;

public class ExportProcess
implements Runnable {
    private static final String FORCE_REFRESH_MESSAGE = "Force Refresh enabled. Will ignore cache and export CSV content.";
    private static final String CACHE_ENABLED_MESSAGE = "Cache is enabled. Checking for new mod configurations.";
    private static final String EQUAL_CONTENT_MESSAGE = "Same mod configuration was found. Not updating CSV content.";
    private static final String UNEQUAL_CONTENT_MESSAGE = "New mod configuration was found. Commencing exporting.";
    private static final String CACHE_DISABLED_MESSAGE = "Cache is disabled. Commencing exporting.";
    private static final String EXPORT_START_MESSAGE = "Item Exporting ( started )";
    private static final String EXPORT_END_MESSAGE = "Item Exporting ( ended after %s ms)";
    @Nonnull
    private final File exportDirectory;
    @Nonnull
    private final Checker<List<ModContainer>> modChecker;
    @Nonnull
    private final ExportConfig config;

    public ExportProcess(@Nonnull File exportDirectory, @Nonnull ExportConfig config) {
        this.exportDirectory = (File)Preconditions.checkNotNull((Object)exportDirectory);
        this.config = (ExportConfig)Preconditions.checkNotNull((Object)config);
        this.modChecker = new ModListChecker(config);
    }

    @Override
    public void run() {
        Thread.yield();
        if (this.config.isForceRefreshEnabled()) {
            AELog.info(FORCE_REFRESH_MESSAGE, new Object[0]);
        } else if (this.config.isCacheEnabled()) {
            AELog.info(CACHE_ENABLED_MESSAGE, new Object[0]);
            Loader loader = Loader.instance();
            List mods = loader.getActiveModList();
            if (this.modChecker.isEqual(mods) == CheckType.EQUAL) {
                AELog.info(EQUAL_CONTENT_MESSAGE, new Object[0]);
                return;
            }
            AELog.info(UNEQUAL_CONTENT_MESSAGE, new Object[0]);
        } else {
            AELog.info(CACHE_DISABLED_MESSAGE, new Object[0]);
        }
        AELog.info(EXPORT_START_MESSAGE, new Object[0]);
        Stopwatch watch = Stopwatch.createStarted();
        FMLControlledNamespacedRegistry itemRegistry = GameData.getItemRegistry();
        ExportMode mode = this.config.isAdditionalInformationEnabled() ? ExportMode.VERBOSE : ExportMode.MINIMAL;
        MinecraftItemCSVExporter exporter = new MinecraftItemCSVExporter(this.exportDirectory, (FMLControlledNamespacedRegistry<Item>)itemRegistry, mode);
        exporter.export();
        AELog.info(EXPORT_END_MESSAGE, watch.elapsed(TimeUnit.MILLISECONDS));
    }
}

