/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.dimlets.types;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import mcjty.lib.varia.BlockTools;
import mcjty.rftoolsdim.blocks.ModBlocks;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.DimletObjectMapping;
import mcjty.rftoolsdim.dimensions.dimlets.DimletRandomizer;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletCraftingTools;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.IDimletType;
import mcjty.rftoolsdim.dimensions.types.ControllerType;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeDimletType
implements IDimletType {
    @Override
    public String getName() {
        return "Biome";
    }

    @Override
    public String getOpcode() {
        return "B";
    }

    @Override
    public String getTextureName() {
        return "biomeDimlet";
    }

    @Override
    public void setupFromConfig(Configuration cfg) {
    }

    @Override
    public boolean isModifier() {
        return false;
    }

    @Override
    public boolean isModifiedBy(DimletType type) {
        return false;
    }

    @Override
    public float getModifierCreateCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public float getModifierMaintainCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public float getModifierTickCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public boolean isInjectable() {
        return false;
    }

    @Override
    public void inject(DimletKey key, DimensionInformation dimensionInformation) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void constructDimension(List<Pair<DimletKey, List<DimletKey>>> dimlets, Random random, DimensionInformation dimensionInformation) {
        ControllerType controllerType;
        Object key;
        HashSet<Object> biomeKeys = new HashSet<Object>();
        List<Pair<DimletKey, List<DimletKey>>> biomeDimlets = DimensionInformation.extractType(DimletType.DIMLET_BIOME, dimlets);
        List<Pair<DimletKey, List<DimletKey>>> controllerDimlets = DimensionInformation.extractType(DimletType.DIMLET_CONTROLLER, dimlets);
        if (controllerDimlets.isEmpty()) {
            controllerType = random.nextFloat() < WorldgenConfiguration.randomControllerChance ? ((key = DimletRandomizer.getRandomController(random)) != null ? DimletObjectMapping.getController((DimletKey)key) : ControllerType.CONTROLLER_DEFAULT) : (biomeDimlets.isEmpty() ? ControllerType.CONTROLLER_DEFAULT : (biomeDimlets.size() > 1 ? ControllerType.CONTROLLER_FILTERED : ControllerType.CONTROLLER_SINGLE));
        } else {
            key = (DimletKey)controllerDimlets.get(random.nextInt(controllerDimlets.size())).getLeft();
            controllerType = DimletObjectMapping.getController((DimletKey)key);
        }
        dimensionInformation.setControllerType(controllerType);
        for (Pair pair : biomeDimlets) {
            DimletKey key2 = (DimletKey)pair.getKey();
            biomeKeys.add(key2);
        }
        int neededBiomes = controllerType.getNeededBiomes();
        if (neededBiomes == -1) {
            neededBiomes = biomeKeys.size() >= 2 ? biomeKeys.size() : random.nextInt(10) + 3;
        }
        while (biomeKeys.size() < neededBiomes) {
            void var9_13;
            DimletKey dimletKey = DimletRandomizer.getRandomBiome(random);
            while (var9_13 == null || biomeKeys.contains(var9_13)) {
                DimletKey dimletKey2 = DimletRandomizer.getRandomBiome(random);
            }
            biomeKeys.add(var9_13);
        }
        List<Biome> list = dimensionInformation.getBiomes();
        list.clear();
        for (DimletKey key4 : biomeKeys) {
            list.add(DimletObjectMapping.getBiome(key4));
        }
    }

    @Override
    public String[] getInformation() {
        return new String[]{"This dimlet controls the biomes that can generate in a dimension", "The controller specifies how they can be used."};
    }

    @Override
    public DimletKey isValidEssence(ItemStack stackEssence) {
        Block essenceBlock = BlockTools.getBlock((ItemStack)stackEssence);
        if (essenceBlock != ModBlocks.biomeAbsorberBlock) {
            return null;
        }
        NBTTagCompound essenceCompound = stackEssence.func_77978_p();
        if (essenceCompound == null) {
            return null;
        }
        int absorbing = essenceCompound.func_74762_e("absorbing");
        String biome = essenceCompound.func_74779_i("biome");
        if (absorbing > 0 || biome == null) {
            return null;
        }
        return BiomeDimletType.findBiomeDimlet(essenceCompound);
    }

    @Override
    public ItemStack getDefaultEssence(DimletKey key) {
        return new ItemStack((Block)ModBlocks.biomeAbsorberBlock);
    }

    private static DimletKey findBiomeDimlet(NBTTagCompound essenceCompound) {
        String biome = essenceCompound.func_74779_i("biome");
        DimletKey key = new DimletKey(DimletType.DIMLET_BIOME, biome);
        Settings settings = KnownDimletConfiguration.getSettings(key);
        if (settings == null || !settings.isDimlet()) {
            return null;
        }
        return key;
    }

    @Override
    public DimletKey attemptDimletCrafting(ItemStack stackController, ItemStack stackMemory, ItemStack stackEnergy, ItemStack stackEssence) {
        DimletKey biomeDimlet = this.isValidEssence(stackEssence);
        if (biomeDimlet == null) {
            return null;
        }
        if (!DimletCraftingTools.matchDimletRecipe(biomeDimlet, stackController, stackMemory, stackEnergy)) {
            return null;
        }
        return biomeDimlet;
    }
}

