/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import java.util.Collection;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.FluidNetwork;
import mekanism.common.Tier;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.util.PipeUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PartMechanicalPipe
extends PartTransmitter<IFluidHandler, FluidNetwork>
implements IFluidHandlerWrapper {
    public Tier.PipeTier tier;
    public float currentScale;
    public FluidTank buffer = new FluidTank(1000);
    public FluidStack lastWrite;
    public CapabilityWrapperManager manager = new CapabilityWrapperManager<IFluidHandlerWrapper, FluidHandlerWrapper>(IFluidHandlerWrapper.class, FluidHandlerWrapper.class);

    public PartMechanicalPipe(Tier.PipeTier pipeTier) {
        this.tier = pipeTier;
        this.buffer.setCapacity(this.getCapacity());
    }

    @Override
    public void func_73660_a() {
        if (!this.getWorld().field_72995_K) {
            this.updateShare();
            IFluidHandler[] connectedAcceptors = PipeUtils.getConnectedAcceptors(this.getPos(), this.getWorld());
            for (EnumFacing side : this.getConnections(PartSidedPipe.ConnectionType.PULL)) {
                FluidStack received;
                IFluidHandler container;
                if (connectedAcceptors[side.ordinal()] == null || (container = connectedAcceptors[side.ordinal()]) == null || (received = container.drain(this.getPullAmount(), false)) == null || received.amount == 0) continue;
                container.drain(this.takeFluid(received, true), true);
            }
        }
        super.func_73660_a();
    }

    @Override
    public void updateShare() {
        FluidStack last;
        if (this.getTransmitter().hasTransmitterNetwork() && this.getTransmitter().getTransmitterNetworkSize() > 0 && ((last = this.getSaveShare()) != null && (this.lastWrite == null || this.lastWrite.amount != last.amount || this.lastWrite.getFluid() != last.getFluid()) || last == null && this.lastWrite != null)) {
            this.lastWrite = last;
            this.markDirty();
        }
    }

    private FluidStack getSaveShare() {
        if (this.getTransmitter().hasTransmitterNetwork() && ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null) {
            int remain = ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount % ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).transmitters.size();
            int toSave = ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount / ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).transmitters.size();
            if (((IGridTransmitter)((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).transmitters.iterator().next()).equals(this.getTransmitter())) {
                toSave += remain;
            }
            return PipeUtils.copy(((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer, toSave);
        }
        return null;
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().field_72995_K && this.getTransmitter().hasTransmitterNetwork() && this.lastWrite != null && ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null) {
            ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            if (((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount <= 0) {
                ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer = null;
            }
        }
        super.onUnloaded();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTags) {
        super.readFromNBT(nbtTags);
        if (nbtTags.func_74764_b("tier")) {
            this.tier = Tier.PipeTier.values()[nbtTags.func_74762_e("tier")];
        }
        this.buffer.setCapacity(this.getCapacity());
        if (nbtTags.func_74764_b("cacheFluid")) {
            this.buffer.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cacheFluid")));
        } else {
            this.buffer.setFluid(null);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbtTags) {
        super.writeToNBT(nbtTags);
        if (this.lastWrite != null && this.lastWrite.amount > 0) {
            nbtTags.func_74782_a("cacheFluid", (NBTBase)this.lastWrite.writeToNBT(new NBTTagCompound()));
        } else {
            nbtTags.func_82580_o("cacheFluid");
        }
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        return nbtTags;
    }

    public ResourceLocation getType() {
        return new ResourceLocation("mekanism:mechanical_pipe_" + this.tier.name().toLowerCase());
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.FLUID;
    }

    @Override
    public TransmitterType getTransmitterType() {
        return this.tier.type;
    }

    @Override
    public boolean isValidAcceptor(TileEntity acceptor, EnumFacing side) {
        return PipeUtils.isValidAcceptorOnSide(acceptor, side);
    }

    @Override
    public FluidNetwork createNewNetwork() {
        return new FluidNetwork();
    }

    @Override
    public FluidNetwork createNetworkByMerging(Collection<FluidNetwork> networks) {
        return new FluidNetwork(networks);
    }

    @Override
    public int getCapacity() {
        return this.tier.pipeCapacity;
    }

    public FluidStack getBuffer() {
        return this.buffer == null ? null : this.buffer.getFluid();
    }

    @Override
    public void takeShare() {
        if (this.getTransmitter().hasTransmitterNetwork() && ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null && this.lastWrite != null) {
            ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            this.buffer.setFluid(this.lastWrite);
        }
    }

    @Override
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.getConnectionType(from) == PartSidedPipe.ConnectionType.NORMAL) {
            return this.takeFluid(resource, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.getConnectionType(from) == PartSidedPipe.ConnectionType.NORMAL;
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (this.getConnectionType(from) != PartSidedPipe.ConnectionType.NONE) {
            return new FluidTankInfo[]{this.buffer.getInfo()};
        }
        return new FluidTankInfo[0];
    }

    public int getPullAmount() {
        return this.tier.pipePullAmount;
    }

    @Override
    public IFluidHandler getCachedAcceptor(EnumFacing side) {
        TileEntity tile = this.getCachedTile(side);
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) {
            return (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        }
        return null;
    }

    public int takeFluid(FluidStack fluid, boolean doEmit) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((FluidNetwork)this.getTransmitter().getTransmitterNetwork()).emit(fluid, doEmit);
        }
        return this.buffer.fill(fluid, doEmit);
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.PipeTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public void readUpdatePacket(PacketBuffer packet) {
        this.tier = Tier.PipeTier.values()[packet.readInt()];
        super.readUpdatePacket(packet);
    }

    @Override
    public void writeUpdatePacket(PacketBuffer packet) {
        packet.writeInt(this.tier.ordinal());
        super.writeUpdatePacket(packet);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.manager.getWrapper(this, side);
        }
        return super.getCapability(capability, side);
    }
}

