/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import mekanism.common.entity.EntityRobit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RobitAIFollow
extends EntityAIBase {
    private EntityRobit theRobit;
    private EntityPlayer theOwner;
    private World theWorld;
    private float moveSpeed;
    private PathNavigateGround thePathfinder;
    private int ticker;
    private float maxDist;
    private float minDist;
    private float oldWaterCost;

    public RobitAIFollow(EntityRobit entityRobit, float speed, float min, float max) {
        this.theRobit = entityRobit;
        this.theWorld = entityRobit.field_70170_p;
        this.moveSpeed = speed;
        this.thePathfinder = entityRobit.getNavigator();
        this.minDist = min;
        this.maxDist = max;
    }

    public boolean func_75250_a() {
        EntityPlayer player = this.theRobit.getOwner();
        if (player == null) {
            return false;
        }
        if (this.theRobit.field_70170_p.field_73011_w.getDimension() != player.field_70170_p.field_73011_w.getDimension()) {
            return false;
        }
        if (!this.theRobit.getFollowing()) {
            this.theRobit.func_70671_ap().func_75651_a((Entity)player, 6.0f, (float)(this.theRobit.func_70646_bf() / 10));
            return false;
        }
        if (this.theRobit.func_70068_e((Entity)player) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        if (this.theRobit.getEnergy() == 0.0) {
            return false;
        }
        this.theOwner = player;
        return true;
    }

    public boolean func_75253_b() {
        return !this.thePathfinder.func_75500_f() && this.theRobit.func_70068_e((Entity)this.theOwner) > (double)(this.maxDist * this.maxDist) && this.theRobit.getFollowing() && this.theRobit.getEnergy() > 0.0 && this.theOwner.field_70170_p.field_73011_w.getDimension() == this.theRobit.field_70170_p.field_73011_w.getDimension();
    }

    public void func_75249_e() {
        this.ticker = 0;
        this.oldWaterCost = this.theRobit.func_184643_a(PathNodeType.WATER);
        this.theRobit.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.theOwner = null;
        this.thePathfinder.func_75499_g();
        this.theRobit.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.theRobit.func_70671_ap().func_75651_a((Entity)this.theOwner, 6.0f, (float)(this.theRobit.func_70646_bf() / 10));
        if (this.theRobit.getFollowing() && --this.ticker <= 0) {
            this.ticker = 10;
            if (!this.thePathfinder.func_75497_a((Entity)this.theOwner, (double)this.moveSpeed) && this.theRobit.func_70068_e((Entity)this.theOwner) >= 144.0) {
                int x = MathHelper.func_76128_c((double)this.theOwner.field_70165_t) - 2;
                int y = MathHelper.func_76128_c((double)this.theOwner.func_174813_aQ().field_72338_b);
                int z = MathHelper.func_76128_c((double)this.theOwner.field_70161_v) - 2;
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        BlockPos pos = new BlockPos(x + l, y, z + i1);
                        BlockPos under = new BlockPos(x + l, y - 1, z + i1);
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.theWorld.func_180495_p(under).isSideSolid((IBlockAccess)this.theWorld, under, EnumFacing.UP) || !this.isEmptyBlock(pos) || !this.isEmptyBlock(new BlockPos(x + l, y + 1, z + i1))) continue;
                        this.theRobit.func_70012_b((float)(x + l) + 0.5f, y, (float)(z + i1) + 0.5f, this.theRobit.field_70177_z, this.theRobit.field_70125_A);
                        this.thePathfinder.func_75499_g();
                        return;
                    }
                }
            }
        }
    }

    private boolean isEmptyBlock(BlockPos pos) {
        IBlockState iblockstate = this.theWorld.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        return block == Blocks.field_150350_a ? true : !iblockstate.func_185917_h();
    }
}

