/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.gui.client.elements;

import com.valkyrieofnight.valkyrielib.client.SizableBox;
import com.valkyrieofnight.valkyrielib.client.TexUtils;
import com.valkyrieofnight.valkyrielib.gui.client.VLGuiContainer;
import com.valkyrieofnight.valkyrielib.gui.client.elements.VLElement;
import com.valkyrieofnight.valkyrielib.util.helpers.ColorUtil;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;

public class VLElementButtonColored
extends VLElement {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected SizableBox style;
    protected SizableBox styleMouseOver;
    protected String text;
    protected int colorText;
    protected int colorTextMouseOver;
    protected int colorTextDisabled;
    protected int color;
    protected int colorMouseOver;
    protected int colorDisabled;
    protected boolean enabled;

    public VLElementButtonColored(VLGuiContainer gui, int x, int y, int width, int height, SizableBox style, SizableBox styleMouseOver, String text) {
        super(gui);
        this.init(x, y, width, height, style, text);
        this.styleMouseOver = styleMouseOver;
    }

    public VLElementButtonColored(String elementAddress, VLGuiContainer gui, int x, int y, int width, int height, SizableBox style, SizableBox styleMouseOver, String text) {
        super(elementAddress, gui);
        this.init(x, y, width, height, style, text);
        this.styleMouseOver = styleMouseOver;
    }

    public VLElementButtonColored(VLGuiContainer gui, int x, int y, int width, int height, SizableBox style, String text) {
        super(gui);
        this.init(x, y, width, height, style, text);
        this.styleMouseOver = style;
    }

    public VLElementButtonColored(String elementAddress, VLGuiContainer gui, int x, int y, int width, int height, SizableBox style, String text) {
        super(elementAddress, gui);
        this.init(x, y, width, height, style, text);
        this.styleMouseOver = style;
    }

    private void init(int x, int y, int width, int height, SizableBox style, String text) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.style = style;
        this.text = text;
        this.colorDisabled = this.color = ColorUtil.calcMCColor(64, 64, 64, 255);
        this.colorMouseOver = this.color;
        this.colorText = 0xE0E0E0;
        this.colorTextDisabled = 0xA0A0A0;
        this.colorTextMouseOver = 0xFFFFA0;
        this.enabled = true;
    }

    public VLElementButtonColored setColors(int color, int colorMouseOver, int colorDisabled) {
        this.color = color;
        this.colorMouseOver = colorMouseOver;
        this.colorDisabled = colorDisabled;
        return this;
    }

    public VLElementButtonColored setTextColors(int colorText, int colorTextMouseOver, int colorTextDisabled) {
        this.colorText = colorText;
        this.colorTextMouseOver = colorTextMouseOver;
        this.colorTextDisabled = colorTextDisabled;
        return this;
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY, int guiLeft, int guiTop) {
        if (this.enabled) {
            if (this.isMouseInBox(mouseX, mouseY, guiLeft + this.x, guiTop + this.y, guiLeft + this.x + this.width, guiTop + this.y + this.height)) {
                GlStateManager.func_179131_c((float)ColorUtil.getRF(this.colorMouseOver), (float)ColorUtil.getGF(this.colorMouseOver), (float)ColorUtil.getBF(this.colorMouseOver), (float)ColorUtil.getAF(this.colorMouseOver));
                TexUtils.renderSizableBox(this.styleMouseOver, this.gui, guiLeft + this.x, guiTop + this.y, this.width, this.height);
            } else {
                GlStateManager.func_179131_c((float)ColorUtil.getRF(this.color), (float)ColorUtil.getGF(this.color), (float)ColorUtil.getBF(this.color), (float)ColorUtil.getAF(this.color));
                TexUtils.renderSizableBox(this.style, this.gui, guiLeft + this.x, guiTop + this.y, this.width, this.height);
            }
        } else {
            GlStateManager.func_179131_c((float)ColorUtil.getRF(this.colorDisabled), (float)ColorUtil.getGF(this.colorDisabled), (float)ColorUtil.getBF(this.colorDisabled), (float)ColorUtil.getAF(this.colorDisabled));
            TexUtils.renderSizableBox(this.style, this.gui, guiLeft + this.x, guiTop + this.y, this.width, this.height);
        }
        if (this.enabled) {
            if (this.isMouseInBox(mouseX, mouseY, guiLeft + this.x, guiTop + this.y, guiLeft + this.x + this.width, guiTop + this.y + this.height)) {
                this.gui.func_73732_a(this.gui.getFontRenderer(), this.text, guiLeft + this.x + this.width / 2, guiTop + this.y + (this.height - 8) / 2, this.colorTextMouseOver);
            } else {
                this.gui.func_73732_a(this.gui.getFontRenderer(), this.text, guiLeft + this.x + this.width / 2, guiTop + this.y + (this.height - 8) / 2, this.colorText);
            }
        } else {
            this.gui.func_73732_a(this.gui.getFontRenderer(), this.text, guiLeft + this.x + this.width / 2, guiTop + this.y + (this.height - 8) / 2, this.colorTextDisabled);
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
    }

    @Override
    public boolean onMouseClick(int guiLeft, int guiTop, int mouseX, int mouseY, int mouseButton) {
        return this.enabled && this.isMouseInBox(mouseX, mouseY, guiLeft + this.x, guiTop + this.y, guiLeft + this.x + this.width, guiTop + this.y + this.height);
    }

    @Override
    public void playPressSound(SoundHandler soundHandlerIn) {
        soundHandlerIn.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public void setEnabled(boolean opt) {
        this.enabled = opt;
    }

    @Override
    public void updateScreen() {
    }

    @Override
    public boolean drawToolTipAt(int mouseX, int mouseY, int guiLeft, int guiTop) {
        return false;
    }
}

