/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftools.network.PacketReturnRfInRange;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGetRfInRange
implements IMessage {
    private BlockPos pos;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public PacketGetRfInRange() {
    }

    public PacketGetRfInRange(BlockPos pos) {
        this.pos = pos;
    }

    public static class Handler
    implements IMessageHandler<PacketGetRfInRange, IMessage> {
        public IMessage onMessage(PacketGetRfInRange message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGetRfInRange message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.func_130014_f_();
            HashMap<BlockPos, MachineInfo> result = new HashMap<BlockPos, MachineInfo>();
            int range = 12;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos p = message.pos.func_177982_a(x, y, z);
                        TileEntity te = world.func_175625_s(p);
                        if (!EnergyTools.isEnergyTE((TileEntity)te)) continue;
                        EnergyTools.EnergyLevel level = EnergyTools.getEnergyLevel((TileEntity)te);
                        Integer usage = null;
                        if (te instanceof IMachineInformation) {
                            usage = ((IMachineInformation)te).getEnergyDiffPerTick();
                        }
                        result.put(p, new MachineInfo(level.getEnergy(), level.getMaxEnergy(), usage));
                    }
                }
            }
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketReturnRfInRange(result), ctx.getServerHandler().field_147369_b);
        }
    }

    public static class MachineInfo {
        private final int energy;
        private final int maxEnergy;
        private final Integer energyPerTick;

        public MachineInfo(int energy, int maxEnergy, Integer energyPerTick) {
            this.energy = energy;
            this.maxEnergy = maxEnergy;
            this.energyPerTick = energyPerTick;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getMaxEnergy() {
            return this.maxEnergy;
        }

        public Integer getEnergyPerTick() {
            return this.energyPerTick;
        }
    }
}

