/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.compat.CompatInventory;
import mcjty.lib.tools.ItemStackList;
import mcjty.lib.tools.ItemStackTools;
import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.blocks.storage.RemoteStorageTileEntity;
import mcjty.rftools.craftinggrid.CraftingGrid;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.InventoriesItemSource;
import mcjty.rftools.craftinggrid.StorageCraftingTools;
import mcjty.rftools.jei.JEIRecipeAcceptor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;

public class RemoteStorageItemInventory
implements CompatInventory,
CraftingGridProvider,
JEIRecipeAcceptor {
    private ItemStackList stacks = ItemStackList.create((int)300);
    private final EntityPlayer entityPlayer;
    private CraftingGrid craftingGrid = new CraftingGrid();

    public RemoteStorageItemInventory(EntityPlayer player) {
        this.entityPlayer = player;
        NBTTagCompound tagCompound = this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77982_d(tagCompound);
        }
        this.craftingGrid.readFromNBT(tagCompound.func_74775_l("grid"));
    }

    private RemoteStorageTileEntity getRemoteStorage() {
        int id = this.getStorageID();
        if (id == -1) {
            return null;
        }
        return RemoteStorageIdRegistry.getRemoteStorage(this.entityPlayer.func_130014_f_(), id);
    }

    private int getStorageID() {
        ItemStack heldItem = this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND);
        if (ItemStackTools.isEmpty((ItemStack)heldItem) || heldItem.func_77978_p() == null) {
            return -1;
        }
        return heldItem.func_77978_p().func_74762_e("id");
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.func_70296_d();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.func_70296_d();
    }

    @Override
    @Nonnull
    public int[] craft(EntityPlayerMP player, int n, boolean test) {
        InventoriesItemSource itemSource = new InventoriesItemSource().add((IInventory)player.field_71071_by, 0).add((IInventory)this, 0);
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        }
        StorageCraftingTools.craftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        return new int[0];
    }

    @Override
    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().func_70299_a(i, stacks.get(i));
        }
        this.func_70296_d();
    }

    private boolean isServer() {
        return !this.entityPlayer.func_130014_f_().field_72995_K;
    }

    private ItemStackList getStacks() {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return ItemStackList.create((int)0);
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return ItemStackList.create((int)0);
            }
            return storage.getRemoteStacks(si);
        }
        int maxSize = this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77978_p().func_74762_e("maxSize");
        if (maxSize != this.stacks.size()) {
            this.stacks = ItemStackList.create((int)maxSize);
        }
        return this.stacks;
    }

    public int func_70302_i_() {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return 0;
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return 0;
            }
            int maxStacks = storage.getMaxStacks(si);
            this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77978_p().func_74768_a("maxSize", maxStacks);
            return maxStacks;
        }
        return this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77978_p().func_74762_e("maxSize");
    }

    public ItemStack func_70301_a(int index) {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return ItemStackTools.getEmptyStack();
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return ItemStackTools.getEmptyStack();
            }
            return storage.getRemoteSlot(si, index);
        }
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return ItemStackTools.getEmptyStack();
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return ItemStackTools.getEmptyStack();
            }
            return storage.decrStackSizeRemote(si, index, amount);
        }
        if (index >= this.stacks.size()) {
            return ItemStackTools.getEmptyStack();
        }
        if (ItemStackTools.isValid((ItemStack)((ItemStack)this.stacks.get(index)))) {
            this.func_70296_d();
            if (ItemStackTools.getStackSize((ItemStack)((ItemStack)this.stacks.get(index))) <= amount) {
                ItemStack old = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, (Object)ItemStackTools.getEmptyStack());
                return old;
            }
            ItemStack its = ((ItemStack)this.stacks.get(index)).func_77979_a(amount);
            if (ItemStackTools.isEmpty((ItemStack)((ItemStack)this.stacks.get(index)))) {
                this.stacks.set(index, (Object)ItemStackTools.getEmptyStack());
            }
            return its;
        }
        return ItemStackTools.getEmptyStack();
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return;
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return;
            }
            storage.updateRemoteSlot(si, this.func_70297_j_(), index, stack);
        } else {
            if (index >= this.stacks.size()) {
                return;
            }
            this.stacks.set(index, (Object)stack);
            if (ItemStackTools.isValid((ItemStack)stack) && ItemStackTools.getStackSize((ItemStack)stack) > this.func_70297_j_()) {
                ItemStackTools.setStackSize((ItemStack)stack, (int)this.func_70297_j_());
            }
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        RemoteStorageTileEntity storage = this.getRemoteStorage();
        if (storage != null) {
            storage.func_70296_d();
        }
        NBTTagCompound tagCompound = this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77978_p();
        tagCompound.func_74782_a("grid", (NBTBase)this.craftingGrid.writeToNBT());
    }

    public boolean isUsable(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        ItemStackList s = this.getStacks();
        if (index >= s.size()) {
            return false;
        }
        if (this.isServer()) {
            RemoteStorageTileEntity storage = this.getRemoteStorage();
            if (storage == null) {
                return false;
            }
            int si = storage.findRemoteIndex(this.getStorageID());
            if (si == -1) {
                return false;
            }
            if (index >= storage.getMaxStacks(si)) {
                return false;
            }
        }
        return true;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.func_70299_a(index, ItemStackTools.getEmptyStack());
        return stack;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return "remote inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }
}

