/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.network;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.clientinfo.InfoPacketClient;
import mcjty.lib.network.clientinfo.InfoPacketServer;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.ITooltipInfo;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcjty.rftools.blocks.screens.network.ScreenInfoPacketClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ScreenInfoPacketServer
implements InfoPacketServer {
    private int dimension;
    private BlockPos pos;

    public ScreenInfoPacketServer() {
    }

    public ScreenInfoPacketServer(int dimension, BlockPos pos) {
        this.dimension = dimension;
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public Optional<InfoPacketClient> onMessageServer(EntityPlayerMP player) {
        ScreenTileEntity screenTileEntity;
        IScreenModule module;
        TileEntity te;
        WorldServer world = DimensionManager.getWorld((int)this.dimension);
        String[] info = new String[]{};
        int cnt = -1;
        if (world != null && (te = world.func_175625_s(this.pos)) instanceof ScreenTileEntity && (module = (screenTileEntity = (ScreenTileEntity)te).getHoveringModule()) instanceof ITooltipInfo) {
            info = ((ITooltipInfo)((Object)module)).getInfo((World)world, screenTileEntity.getHoveringX(), screenTileEntity.getHoveringY(), (EntityPlayer)player);
        }
        return Optional.of(new ScreenInfoPacketClient(info));
    }
}

