/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import mcjty.rftools.api.screens.IModuleRenderHelper;
import mcjty.rftools.api.screens.ITextRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.TextAlign;
import mcjty.rftools.api.screens.data.IModuleData;
import mcjty.rftools.blocks.screens.modulesclient.helper.ScreenTextHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TextClientScreenModule
implements IClientScreenModule {
    private String line = "";
    private int color = 0xFFFFFF;
    private ITextRenderHelper cache = new ScreenTextHelper();

    @Override
    public IClientScreenModule.TransformMode getTransformMode() {
        return this.cache.isLarge() ? IClientScreenModule.TransformMode.TEXTLARGE : IClientScreenModule.TransformMode.TEXT;
    }

    @Override
    public int getHeight() {
        return this.cache.isLarge() ? 20 : 10;
    }

    public void render(IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleData screenData, ModuleRenderInfo renderInfo) {
        GlStateManager.func_179140_f();
        this.cache.setup(this.line, 512, renderInfo);
        int y = this.cache.isLarge() ? currenty / 2 + 1 : currenty;
        this.cache.renderText(0, y, this.color, renderInfo);
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    @Override
    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Text:").text("text", "Text to show").color("color", "Color for the text").nl().toggle("large", "Large", "Large or small font").choices("align", "Text alignment", "Left", "Center", "Right").nl();
    }

    public void setLine(String line) {
        this.line = line;
        this.cache.setDirty();
    }

    public void setColor(int color) {
        this.color = color;
        this.cache.setDirty();
    }

    public void setLarge(boolean large) {
        this.cache.large(large);
        this.cache.setDirty();
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.color = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            this.cache.large(tagCompound.func_74767_n("large"));
            if (tagCompound.func_74764_b("align")) {
                String alignment = tagCompound.func_74779_i("align");
                this.cache.align(TextAlign.get(alignment));
            } else {
                this.cache.align(TextAlign.ALIGN_LEFT);
            }
        }
    }

    @Override
    public boolean needsServerData() {
        return false;
    }
}

