/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.monitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.tools.WorldTools;
import mcjty.rftools.blocks.monitor.GuiLiquidMonitor;
import mcjty.rftools.blocks.monitor.RFMonitorMode;
import mcjty.rftools.varia.RFToolsTools;
import mcjty.typed.Type;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class LiquidMonitorBlockTileEntity
extends GenericTileEntity
implements ITickable {
    private BlockPos monitor;
    private RFMonitorMode alarmMode = RFMonitorMode.MODE_OFF;
    private int alarmLevel = 0;
    public static final String CMD_GETADJACENTBLOCKS = "getAdj";
    public static final String CLIENTCMD_ADJACENTBLOCKSREADY = "adjReady";
    private int counter = 20;
    private int fluidlevel = 0;
    private boolean inAlarm = false;

    public RFMonitorMode getAlarmMode() {
        return this.alarmMode;
    }

    public int getAlarmLevel() {
        return this.alarmLevel;
    }

    public boolean isPowered() {
        return this.inAlarm;
    }

    public void setAlarm(RFMonitorMode mode, int level) {
        this.alarmMode = mode;
        this.alarmLevel = level;
        this.markDirtyClient();
    }

    public BlockPos getMonitor() {
        return this.monitor;
    }

    public boolean isValid() {
        return this.monitor != null;
    }

    public void setInvalid() {
        if (this.monitor == null) {
            return;
        }
        this.monitor = null;
        if (this.fluidlevel != 0) {
            this.fluidlevel = 0;
            this.markDirtyClient();
        } else {
            this.func_70296_d();
        }
        this.setRedstoneOut(false);
    }

    public void setMonitor(BlockPos c) {
        this.monitor = c;
        this.markDirtyClient();
    }

    public int getFluidLevel() {
        return this.fluidlevel;
    }

    public List<BlockPos> findAdjacentBlocks() {
        int x = this.func_174877_v().func_177958_n();
        int y = this.func_174877_v().func_177956_o();
        int z = this.func_174877_v().func_177952_p();
        ArrayList<BlockPos> adjacentBlocks = new ArrayList<BlockPos>();
        for (int dy = -1; dy <= 1; ++dy) {
            int yy = y + dy;
            if (yy < 0 || yy >= this.func_145831_w().func_72800_K()) continue;
            for (int dz = -1; dz <= 1; ++dz) {
                int zz = z + dz;
                for (int dx = -1; dx <= 1; ++dx) {
                    TileEntity tileEntity;
                    int xx = x + dx;
                    if (dx == 0 && dy == 0 && dz == 0 || (tileEntity = this.func_145831_w().func_175625_s(new BlockPos(xx, yy, zz))) == null || !tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) continue;
                    adjacentBlocks.add(new BlockPos(xx, yy, zz));
                }
            }
        }
        return adjacentBlocks;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (!this.isValid()) {
            this.counter = 1;
            return;
        }
        --this.counter;
        if (this.counter > 0) {
            return;
        }
        this.counter = 20;
        long stored = 0L;
        long maxContents = 0L;
        TileEntity tileEntity = this.func_145831_w().func_175625_s(this.monitor);
        IFluidHandler fluidHandler = RFToolsTools.hasFluidCapabilitySafe(tileEntity);
        if (fluidHandler != null) {
            IFluidTankProperties[] properties = fluidHandler.getTankProperties();
            if (properties != null && properties.length > 0) {
                if (properties[0].getContents() != null) {
                    stored = properties[0].getContents().amount;
                }
                maxContents = properties[0].getCapacity();
            }
        } else {
            this.setInvalid();
            return;
        }
        int ratio = 0;
        boolean alarm = false;
        if (maxContents > 0L) {
            ratio = (int)(1L + stored * 5L / maxContents);
            if (ratio < 1) {
                ratio = 1;
            } else if (ratio > 5) {
                ratio = 5;
            }
            switch (this.alarmMode) {
                case MODE_OFF: {
                    alarm = false;
                    break;
                }
                case MODE_LESS: {
                    alarm = stored * 100L / maxContents < (long)this.alarmLevel;
                    break;
                }
                case MODE_MORE: {
                    boolean bl = alarm = stored * 100L / maxContents > (long)this.alarmLevel;
                }
            }
        }
        if (this.fluidlevel != ratio) {
            this.fluidlevel = ratio;
            this.markDirtyClient();
        }
        if (alarm != this.inAlarm) {
            this.inAlarm = alarm;
            this.setRedstoneOut(this.inAlarm);
            this.func_70296_d();
        }
    }

    private void setRedstoneOut(boolean a) {
        WorldTools.notifyNeighborsOfStateChange((World)this.func_145831_w(), (BlockPos)this.field_174879_c, (Block)this.func_145838_q());
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.monitor = tagCompound.func_74764_b("monitorX") ? new BlockPos(tagCompound.func_74762_e("monitorX"), tagCompound.func_74762_e("monitorY"), tagCompound.func_74762_e("monitorZ")) : null;
        this.inAlarm = tagCompound.func_74767_n("inAlarm");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.fluidlevel = tagCompound.func_74762_e("fluidlevel");
        this.alarmMode = RFMonitorMode.getModeFromIndex(tagCompound.func_74771_c("alarmMode"));
        this.alarmLevel = tagCompound.func_74771_c("alarmLevel");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.monitor != null) {
            tagCompound.func_74768_a("monitorX", this.monitor.func_177958_n());
            tagCompound.func_74768_a("monitorY", this.monitor.func_177956_o());
            tagCompound.func_74768_a("monitorZ", this.monitor.func_177952_p());
        }
        tagCompound.func_74757_a("inAlarm", this.inAlarm);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("fluidlevel", this.getFluidLevel());
        tagCompound.func_74774_a("alarmMode", (byte)this.alarmMode.getIndex());
        tagCompound.func_74774_a("alarmLevel", (byte)this.alarmLevel);
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, Map<String, Argument> args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if (CMD_GETADJACENTBLOCKS.equals(command)) {
            return type.convert(this.findAdjacentBlocks());
        }
        return Collections.emptyList();
    }

    public <T> boolean execute(String command, List<T> list, Type<T> type) {
        boolean rc = super.execute(command, list, type);
        if (rc) {
            return true;
        }
        if (CLIENTCMD_ADJACENTBLOCKSREADY.equals(command)) {
            GuiLiquidMonitor.fromServer_clientAdjacentBlocks = new ArrayList<BlockPos>(Type.create(BlockPos.class).convert(list));
            return true;
        }
        return false;
    }
}

