/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.externalstorage;

import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.fluid.IFluidStorage;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.externalstorage.TileExternalStorage;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidStorageExternal
implements IFluidStorage {
    private FluidStack cache;
    private TileExternalStorage externalStorage;
    private Supplier<IFluidHandler> handlerSupplier;

    public FluidStorageExternal(TileExternalStorage externalStorage, Supplier<IFluidHandler> handlerSupplier) {
        this.externalStorage = externalStorage;
        this.handlerSupplier = handlerSupplier;
    }

    private IFluidTankProperties getProperties() {
        IFluidHandler handler = this.handlerSupplier.get();
        return handler != null && handler.getTankProperties() != null && handler.getTankProperties().length != 0 ? handler.getTankProperties()[0] : null;
    }

    private FluidStack getContents() {
        return this.getProperties() == null ? null : this.getProperties().getContents();
    }

    @Override
    public List<FluidStack> getStacks() {
        return this.getContents() == null ? Collections.emptyList() : Collections.singletonList(this.getContents().copy());
    }

    @Override
    @Nullable
    public FluidStack insertFluid(@Nonnull FluidStack stack, int size, boolean simulate) {
        if (this.getProperties() != null && IFilterable.canTakeFluids(this.externalStorage.getFluidFilters(), this.externalStorage.getMode(), this.externalStorage.getCompare(), stack) && this.getProperties().canFillFluidType(stack)) {
            int filled = this.handlerSupplier.get().fill(RSUtils.copyStackWithSize(stack, size), !simulate);
            if (filled == size) {
                return null;
            }
            return RSUtils.copyStackWithSize(stack, size - filled);
        }
        return RSUtils.copyStackWithSize(stack, size);
    }

    @Override
    @Nullable
    public FluidStack extractFluid(@Nonnull FluidStack stack, int size, int flags, boolean simulate) {
        IFluidHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return null;
        }
        FluidStack toDrain = RSUtils.copyStackWithSize(stack, size);
        if (API.instance().getComparer().isEqual(this.getContents(), toDrain, flags)) {
            return handler.drain(toDrain, !simulate);
        }
        return null;
    }

    @Override
    public int getStored() {
        return this.getContents() != null ? this.getContents().amount : 0;
    }

    public int getCapacity() {
        return this.getProperties() != null ? this.getProperties().getCapacity() : 0;
    }

    @Override
    public int getPriority() {
        return this.externalStorage.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.externalStorage.getAccessType();
    }

    public boolean updateCache() {
        FluidStack stack = this.getContents();
        if (this.cache == null) {
            this.cache = RSUtils.copyStack(stack);
        } else if (!API.instance().getComparer().isEqual(stack, this.cache, 6)) {
            this.cache = RSUtils.copyStack(stack);
            return true;
        }
        return false;
    }

    public void updateCacheForcefully() {
        this.cache = RSUtils.copyStack(this.getContents());
    }
}

