/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReader;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.gui.GuiReaderWriter;
import com.raoulvdberge.refinedstorage.tile.IReaderWriter;
import com.raoulvdberge.refinedstorage.tile.TileMultipartNode;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataConsumer;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataProducer;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class TileReader
extends TileMultipartNode
implements IReader {
    private static final String NBT_CHANNEL = "Channel";
    public static final TileDataParameter<String> CHANNEL = TileReader.createChannelParameter();
    private String channel = "";

    static <T extends TileEntity> TileDataParameter<String> createChannelParameter() {
        return new TileDataParameter<String>(DataSerializers.field_187194_d, "", new ITileDataProducer<String, T>(){

            @Override
            public String getValue(T tile) {
                return ((IReaderWriter)tile).getChannel();
            }
        }, new ITileDataConsumer<String, T>(){

            @Override
            public void setValue(T tile, String value) {
                ((IReaderWriter)tile).setChannel(value);
                tile.func_70296_d();
            }
        }, parameter -> {
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiReaderWriter) {
                ((GuiReaderWriter)Minecraft.func_71410_x().field_71462_r).updateSelection((String)parameter.getValue());
            }
        });
    }

    public TileReader() {
        this.dataManager.addWatchedParameter(CHANNEL);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.readerUsage;
    }

    @Override
    public void updateNode() {
    }

    @Override
    public int getRedstoneStrength() {
        return this.func_145831_w().func_175651_c(this.field_174879_c.func_177972_a(this.getDirection()), this.getDirection());
    }

    @Override
    public String getTitle() {
        return "gui.refinedstorage:reader";
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Override
    public TileDataParameter<String> getChannelParameter() {
        return CHANNEL;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        if (facing != this.getDirection() || this.network == null) {
            return false;
        }
        IReaderWriterChannel channel = this.network.getReaderWriterChannel(this.channel);
        if (channel == null) {
            return false;
        }
        for (IReaderWriterHandler handler : channel.getHandlers()) {
            if (!handler.hasCapability(this, capability)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        T foundCapability = super.getCapability(capability, facing);
        if (foundCapability == null) {
            if (facing != this.getDirection() || this.network == null) {
                return null;
            }
            IReaderWriterChannel channel = this.network.getReaderWriterChannel(this.channel);
            if (channel == null) {
                return null;
            }
            for (IReaderWriterHandler handler : channel.getHandlers()) {
                foundCapability = handler.getCapability(this, capability);
                if (foundCapability == null) continue;
                return foundCapability;
            }
        }
        return foundCapability;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_CHANNEL)) {
            this.channel = tag.func_74779_i(NBT_CHANNEL);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74778_a(NBT_CHANNEL, this.channel);
        return tag;
    }

    public void onOpened(EntityPlayer entity) {
        if (this.isConnected()) {
            this.network.sendReaderWriterChannelUpdate((EntityPlayerMP)entity);
        }
    }
}

