/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.item;

import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ItemStackSerializer {
    @Nullable
    public static ItemStack parseItem(String input) {
        if ((input = input.trim()).isEmpty()) {
            return null;
        }
        CharSequence[] s1 = input.split(" ");
        if (s1.length == 0) {
            return null;
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(s1[0]));
        if (item == null) {
            return null;
        }
        int stackSize = 1;
        int meta = 0;
        if (s1.length >= 2) {
            stackSize = MathHelper.func_82715_a((String)s1[1], (int)1);
        }
        if (s1.length >= 3) {
            meta = s1[2].charAt(0) == '*' ? Short.MAX_VALUE : MathHelper.func_82715_a((String)s1[2], (int)0);
        }
        ItemStack itemstack = new ItemStack(item, stackSize, meta);
        if (s1.length > 3) {
            try {
                itemstack.func_77982_d(JsonToNBT.func_180713_a((String)LMStringUtils.joinSpaceUntilEnd(3, s1)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return itemstack;
    }

    public static String toString(@Nullable ItemStack is) {
        return is == null ? "" : Item.field_150901_e.func_177774_c((Object)is.func_77973_b()) + " " + is.field_77994_a + ' ' + is.func_77952_i();
    }

    public static JsonElement serialize(@Nullable ItemStack is) {
        if (is == null) {
            return JsonNull.INSTANCE;
        }
        String s = ItemStackSerializer.toString(is);
        return s.isEmpty() ? JsonNull.INSTANCE : new JsonPrimitive(s);
    }

    @Nullable
    public static ItemStack deserialize(JsonElement e) {
        if (e.isJsonNull()) {
            return null;
        }
        if (e.isJsonPrimitive()) {
            return ItemStackSerializer.parseItem(e.getAsString());
        }
        try {
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)e.toString());
            return ItemStack.func_77949_a((NBTTagCompound)nbt);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

