/*
 * Decompiled with CFR 0.152.
 */
package mods.belgabor.bitdrawers.item;

import com.jaquadro.minecraft.chameleon.resources.IItemMeshMapper;
import com.jaquadro.minecraft.chameleon.resources.IItemVariantProvider;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import mods.belgabor.bitdrawers.BitDrawers;
import mods.belgabor.bitdrawers.block.tile.TileBitDrawers;
import mods.belgabor.bitdrawers.config.ConfigManager;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ItemBitDrawer
extends ItemBlock
implements IItemMeshMapper,
IItemVariantProvider {
    public ItemBitDrawer(Block block) {
        super(block);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            return false;
        }
        TileBitDrawers tile = (TileBitDrawers)world.func_175625_s(pos);
        if (tile != null) {
            if (side != EnumFacing.UP && side != EnumFacing.DOWN) {
                tile.setDirection(side.ordinal());
            }
            int initCapacity = BitDrawers.config.bitdrawerStorage;
            tile.setDrawerCapacity(initCapacity);
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tile")) {
                tile.readFromPortableNBT(stack.func_77978_p().func_74775_l("tile"));
            }
            tile.setIsSealed(false);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean par4) {
        ConfigManager config = BitDrawers.config;
        list.add(I18n.func_74837_a((String)"storageDrawers.drawers.description", (Object[])new Object[]{config.bitdrawerStorage}));
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("tile")) {
            list.add(ChatFormatting.YELLOW + I18n.func_74838_a((String)"storageDrawers.drawers.sealed"));
        }
    }

    public List<ResourceLocation> getItemVariants() {
        ResourceLocation location = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)this);
        ArrayList<ResourceLocation> variants = new ArrayList<ResourceLocation>();
        for (EnumCompDrawer type : EnumCompDrawer.values()) {
            variants.add(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + '_' + type.func_176610_l()));
        }
        return variants;
    }

    public List<Pair<ItemStack, ModelResourceLocation>> getMeshMappings() {
        ArrayList<Pair<ItemStack, ModelResourceLocation>> mappings = new ArrayList<Pair<ItemStack, ModelResourceLocation>>();
        for (EnumCompDrawer type : EnumCompDrawer.values()) {
            ModelResourceLocation location = new ModelResourceLocation("bitdrawers:bitdrawer_" + type.func_176610_l(), "inventory");
            mappings.add((Pair<ItemStack, ModelResourceLocation>)Pair.of((Object)new ItemStack((Item)this, 1, type.getMetadata()), (Object)location));
        }
        return mappings;
    }
}

