/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.wrappers;

import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidBucketWrapper
implements IFluidHandler,
ICapabilityProvider {
    protected final adz container;

    public FluidBucketWrapper(adz container) {
        this.container = container;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        if (fluid.getFluid() == FluidRegistry.WATER || fluid.getFluid() == FluidRegistry.LAVA || fluid.getFluid().getName().equals("milk")) {
            return true;
        }
        return FluidRegistry.isUniversalBucketEnabled() && FluidRegistry.getBucketFluids().contains(fluid.getFluid());
    }

    @Nullable
    public FluidStack getFluid() {
        adx item = this.container.b();
        if (item == aeb.az) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (item == aeb.aA) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        if (item == aeb.aN) {
            return FluidRegistry.getFluidStack("milk", 1000);
        }
        if (item == ForgeModContainer.getInstance().universalBucket) {
            return ForgeModContainer.getInstance().universalBucket.getFluid(this.container);
        }
        return null;
    }

    protected void setFluid(Fluid fluid) {
        if (fluid == null) {
            this.container.deserializeNBT(new adz(aeb.ay).serializeNBT());
        } else if (fluid == FluidRegistry.WATER) {
            this.container.deserializeNBT(new adz(aeb.az).serializeNBT());
        } else if (fluid == FluidRegistry.LAVA) {
            this.container.deserializeNBT(new adz(aeb.aA).serializeNBT());
        } else if (fluid.getName().equals("milk")) {
            this.container.deserializeNBT(new adz(aeb.aN).serializeNBT());
        } else if (FluidRegistry.isUniversalBucketEnabled() && FluidRegistry.getBucketFluids().contains(fluid)) {
            adz filledBucket = UniversalBucket.getFilledBucket(ForgeModContainer.getInstance().universalBucket, fluid);
            this.container.deserializeNBT(filledBucket.serializeNBT());
        }
    }

    @Override
    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 1000)};
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.b != 1 || resource == null || resource.amount < 1000 || this.container.b() instanceof aeg || this.getFluid() != null || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (doFill) {
            this.setFluid(resource.getFluid());
        }
        return 1000;
    }

    @Override
    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.b != 1 || resource == null || resource.amount < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null && fluidStack.isFluidEqual(resource)) {
            if (doDrain) {
                this.setFluid(null);
            }
            return fluidStack;
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.b != 1 || maxDrain < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            if (doDrain) {
                this.setFluid(null);
            }
            return fluidStack;
        }
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, ct facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, ct facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast(this);
        }
        return null;
    }
}

