/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.client.integration.jei.focusable;

import com.valkyrieofnight.environmentaltech.api.registry.IFocusableRegistry;
import com.valkyrieofnight.environmentaltech.api.util.WeightedStackBase;
import com.valkyrieofnight.environmentaltech.client.integration.jei.focusable.FocusableRecipeWrapper;
import com.valkyrieofnight.valkyrielib.util.helpers.LanguageHelper;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class FocusableRecipeCategory
implements IRecipeCategory {
    public final IDrawable background;
    public final IDrawable elements;
    public final String lensString;
    public final String localizedName;

    public FocusableRecipeCategory(IGuiHelper guiHelper, String localizedName) {
        this.background = guiHelper.createBlankDrawable(128, 48);
        this.elements = guiHelper.createDrawable(new ResourceLocation("environmentaltech", "textures/gui/elements.png"), 0, 0, 18, 18);
        this.lensString = LanguageHelper.toLoc((String)"gui.environmentaltech.lens");
        this.localizedName = localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public void drawExtras(Minecraft minecraft) {
    }

    public void drawAnimations(Minecraft minecraft) {
    }

    public abstract IFocusableRegistry getRegistry();

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper) {
        if (!(recipeWrapper instanceof FocusableRecipeWrapper)) {
            return;
        }
        WeightedStackBase output = this.getRegistry().getWeightedStack((ItemStack)recipeWrapper.getOutputs().get(0));
        recipeLayout.getItemStacks().init(0, false, 6, 14);
        recipeLayout.getItemStacks().set(0, (ItemStack)recipeWrapper.getInputs().get(0));
        recipeLayout.getItemStacks().init(1, false, 104, 14);
        recipeLayout.getItemStacks().set(1, (ItemStack)recipeWrapper.getInputs().get(1));
        recipeLayout.getItemStacks().init(2, false, 55, 14);
        recipeLayout.getItemStacks().set(2, output.getMainStack());
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (!(recipeWrapper instanceof FocusableRecipeWrapper)) {
            return;
        }
        if (ingredients.getOutputs(ItemStack.class).size() > 0) {
            WeightedStackBase output = this.getRegistry().getWeightedStack((ItemStack)ingredients.getOutputs(ItemStack.class).get(0));
            recipeLayout.getItemStacks().init(0, false, 6, 14);
            recipeLayout.getItemStacks().set(0, (ItemStack)((List)ingredients.getInputs(ItemStack.class).get(0)).get(0));
            recipeLayout.getItemStacks().init(1, false, 104, 14);
            recipeLayout.getItemStacks().set(1, (ItemStack)((List)ingredients.getInputs(ItemStack.class).get(1)).get(0));
            recipeLayout.getItemStacks().init(2, false, 55, 14);
            recipeLayout.getItemStacks().set(2, output.getMainStack());
        }
    }
}

