/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import javax.annotation.Nonnull;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.multiblock.IMasterLogic;
import slimeknights.mantle.multiblock.IServantLogic;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.smeltery.tileentity.TileSmelteryComponent;

public class BlockEnumSmeltery<T extends Enum<T> & IStringSerializable>
extends EnumBlock<T>
implements ITileEntityProvider {
    public BlockEnumSmeltery(PropertyEnum<T> prop, Class<T> clazz) {
        this(Material.field_151576_e, prop, clazz);
    }

    public BlockEnumSmeltery(Material material, PropertyEnum<T> prop, Class<T> clazz) {
        super(material, prop, clazz);
        this.func_149711_c(3.0f);
        this.func_149752_b(20.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabSmeltery);
        this.field_149758_A = true;
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileSmelteryComponent();
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileSmelteryComponent) {
            ((TileSmelteryComponent)te).notifyMasterOfChange();
        }
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        for (EnumFacing dir : EnumFacing.values()) {
            TileSmelteryComponent component;
            TileEntity te = worldIn.func_175625_s(pos.func_177972_a(dir));
            if (te instanceof IMasterLogic) {
                TileEntity servant = worldIn.func_175625_s(pos);
                if (!(servant instanceof IServantLogic)) continue;
                ((IMasterLogic)te).notifyChange((IServantLogic)servant, pos);
                break;
            }
            if (!(te instanceof TileSmelteryComponent) || !(component = (TileSmelteryComponent)te).hasValidMaster()) continue;
            component.notifyMasterOfChange();
            break;
        }
    }

    @Deprecated
    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }
}

