/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.base.Strings;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.UsernameCache;

public class StackHelper {
    public static final String[] BASECODES = new String[]{"000", "111", "222", "333", "444", "555", "666", "777", "888", "999", "AAA", "BBB", "CCC", "DDD", "EEE", "FFF"};

    public static ItemStack create(Item item, String code, String ownerUUID, ItemStack personalItem) {
        ItemStack stack = StackHelper.create(item, code, personalItem != null ? ownerUUID : "all");
        if (personalItem != null) {
            String id = personalItem.func_77973_b().getRegistryName().toString() + ":" + personalItem.func_77952_i();
            StackHelper.getTag(stack).func_74778_a("personal", id);
        }
        return stack;
    }

    public static ItemStack create(Item item, String code, String ownerUUID) {
        boolean isPublic = Strings.isNullOrEmpty((String)ownerUUID) || ownerUUID.equalsIgnoreCase("all");
        ItemStack stack = new ItemStack(item, 1, isPublic ? 0 : 1);
        StackHelper.setCode(stack, code);
        StackHelper.setOwner(stack, ownerUUID);
        return stack;
    }

    private static void setOwner(ItemStack stack, String ownerUUID) {
        UUID uuid;
        if (stack.func_77952_i() == 0 || Strings.isNullOrEmpty((String)ownerUUID) || ownerUUID.equalsIgnoreCase("all")) {
            ownerUUID = "all";
        }
        StackHelper.getTag(stack).func_74778_a("owner", ownerUUID);
        if (!ownerUUID.equals("all") && UsernameCache.containsUUID((UUID)(uuid = UUID.fromString(ownerUUID)))) {
            StackHelper.getTag(stack).func_74778_a("ownername", Strings.nullToEmpty((String)UsernameCache.getLastKnownUsername((UUID)uuid)));
            return;
        }
        StackHelper.getTag(stack).func_74778_a("ownername", ownerUUID);
    }

    private static void setCode(ItemStack stack, String code) {
        StackHelper.getTag(stack).func_74778_a("code", StackHelper.formatCode(code));
    }

    public static String getOwnerID(ItemStack stack) {
        if (stack.func_77952_i() == 1) {
            if (StackHelper.getTag(stack).func_74764_b("owner")) {
                return StackHelper.getTag(stack).func_74779_i("owner");
            }
            StackHelper.setOwner(stack, "all");
        }
        return "all";
    }

    public static UUID getOwnerUUID(ItemStack stack) {
        String id = StackHelper.getOwnerID(stack);
        UUID uuid = null;
        try {
            uuid = UUID.fromString(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uuid;
    }

    public static String getOwnerName(ItemStack stack) {
        if (StackHelper.getTag(stack).func_74764_b("ownername")) {
            return StackHelper.getTag(stack).func_74779_i("ownername");
        }
        return StackHelper.getOwnerID(stack);
    }

    public static String getCode(ItemStack stack) {
        if (StackHelper.getTag(stack).func_74764_b("code")) {
            return StackHelper.formatCode(StackHelper.getTag(stack).func_74779_i("code"));
        }
        StackHelper.setCode(stack, "000");
        return "000";
    }

    public static ItemStack getPersonalItem(ItemStack stack) {
        String[] parts;
        String id = StackHelper.getTag(stack).func_74779_i("personal");
        if (!Strings.isNullOrEmpty((String)id) && (parts = id.split(":")).length == 3) {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(parts[0], parts[1]));
            int meta = 0;
            try {
                meta = Integer.parseInt(parts[2]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (item != null) {
                return new ItemStack(item, 1, meta);
            }
        }
        return null;
    }

    private static NBTTagCompound getTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    private static String formatCode(String code) {
        if (Strings.isNullOrEmpty((String)code)) {
            return "000";
        }
        if ((code = code.toUpperCase()).length() != 3) {
            while (code.length() < 3) {
                code = "0" + code;
            }
            code = code.substring(0, 3);
        }
        if (code.matches("[0-9A-F]{3}")) {
            return code;
        }
        char[] parts = code.toCharArray();
        for (int index = 0; index < 3; ++index) {
            if (!("" + parts[index]).matches("[^0-9A-F]")) continue;
            parts[index] = 48;
        }
        return "" + parts[0] + parts[1] + parts[2];
    }
}

