/*
 * Decompiled with CFR 0.152.
 */
package zairus.hermitquest.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.hermitquest.hermits.HermitProps;
import zairus.hermitquest.hermits.Hermits;
import zairus.hermitquest.item.HQItems;

public class TileEntityHermitBanner
extends TileEntity {
    private int hermitIndex = 0;

    public TileEntityHermitBanner() {
    }

    public TileEntityHermitBanner(int hIndex) {
        this.hermitIndex = hIndex;
    }

    public void setItemValues(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_179543_a("BlockEntityTag", false);
        if (nbttagcompound != null && nbttagcompound.func_74764_b("hermitIndex")) {
            this.hermitIndex = nbttagcompound.func_74762_e("hermitIndex");
        }
        this.updateMe();
    }

    public int getHermitIndex() {
        return this.hermitIndex;
    }

    public ItemStack getBannerStack() {
        ItemStack bannerStack = new ItemStack(HQItems.HERMIT_BANNER, 1, this.hermitIndex);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74768_a("hermitIndex", this.hermitIndex);
        nbttagcompound.func_74778_a("hermitName", Hermits.values()[this.hermitIndex].NAME);
        bannerStack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        return bannerStack;
    }

    public static void setBannerInfo(NBTTagCompound compound, int hermitIndex) {
        compound.func_74768_a("hermitIndex", hermitIndex);
    }

    public static int getBaseColor(ItemStack stack) {
        return 0;
    }

    public int getBaseColor() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getResourceLocation() {
        return HermitProps.getBannerTexturesArray()[this.hermitIndex];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        TileEntityHermitBanner.setBannerInfo(compound, this.hermitIndex);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.hermitIndex = compound.func_74762_e("hermitIndex");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeSyncableDataToNBT(syncData);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, syncData);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readSyncableDataFromNBT(pkt.func_148857_g());
    }

    protected void writeSyncableDataToNBT(NBTTagCompound syncData) {
        syncData.func_74768_a("hermitIndex", this.hermitIndex);
    }

    protected void readSyncableDataFromNBT(NBTTagCompound syncData) {
        this.hermitIndex = syncData.func_74762_e("hermitIndex");
    }

    private void updateMe() {
        this.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175704_b(this.func_174877_v().func_177982_a(-1, -1, -1), this.func_174877_v().func_177982_a(1, 1, 1));
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 0);
        }
    }
}

