/*
 * Decompiled with CFR 0.152.
 */
package zairus.hermitquest.entity.boss;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.ZombieType;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.hermitquest.entity.EntityAngryVillager;
import zairus.hermitquest.entity.EntityDiabloElPollo;
import zairus.hermitquest.entity.EntityJevinSlime;
import zairus.hermitquest.entity.EntitySmallSnake;
import zairus.hermitquest.entity.ai.EntityAIHermitBossAttack;
import zairus.hermitquest.entity.ai.EntityAIHermitBossRanged;
import zairus.hermitquest.entity.projectile.EntityDioriteArrow;
import zairus.hermitquest.entity.projectile.EntityIskallBeam;
import zairus.hermitquest.entity.projectile.EntityThrowableBook;
import zairus.hermitquest.entity.projectile.EntityThrowableGoldenApple;
import zairus.hermitquest.entity.projectile.EntityThrowableTorch;
import zairus.hermitquest.hermits.Hermits;
import zairus.hermitquest.item.ItemHermitBanner;
import zairus.hermitquest.item.ItemImpFireball;
import zairus.hermitquest.potion.HQPotionType;
import zairus.hermitquest.sound.HQSoundEvents;

public class EntityHermitBoss
extends EntityCreature
implements IRangedAttackMob {
    public float renderOffsetX;
    @SideOnly(value=Side.CLIENT)
    public float renderOffsetY;
    public float renderOffsetZ;
    private static final DataParameter<Integer> HERMIT_INDEX = EntityDataManager.func_187226_a(EntityHermitBoss.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SHOOTING_TIME = EntityDataManager.func_187226_a(EntityHermitBoss.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityHermitBoss.class, (DataSerializer)DataSerializers.field_187192_b);
    private final EntityAIHermitBossAttack hermitBossStandardAttack = new EntityAIHermitBossAttack(this, 1.5, false);
    private final EntityAIHermitBossRanged rangedAttack = new EntityAIHermitBossRanged(this, 1.0, 20, 15.0f);
    private final BossInfoServer bossInfo = new BossInfoServer(this.getBossName(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS);
    private Hermits hermit;
    private int livingTicks;
    private int shootingTime = 0;
    private int shootingTimeLast = 0;
    private int minionCount = 0;
    private boolean vulnerable = false;
    private int lastVulnerable = 0;
    private int targetAirTicks = 200;
    private int targetDrownTicks = 20;
    protected boolean field_70178_ae = false;

    public EntityHermitBoss(World world) {
        this(world, Hermits.XISUMA);
    }

    public EntityHermitBoss(World world, Hermits h) {
        super(world);
        this.hermit = h;
        this.func_70105_a(0.6f, 1.95f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.func_98053_h(true);
        this.func_110163_bv();
        this.func_184598_c(EnumHand.MAIN_HAND);
        this.field_184627_bm = new ItemStack(Items.field_151048_u);
    }

    @Nullable
    public ItemStack func_184614_ca() {
        return new ItemStack(Items.field_151048_u);
    }

    @Nullable
    public ItemStack func_184592_cb() {
        return new ItemStack(Items.field_151056_x);
    }

    public void setHermit(Hermits h) {
        this.hermit = h;
        this.func_184212_Q().func_187227_b(HERMIT_INDEX, (Object)h.ordinal());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(HERMIT_INDEX, (Object)0);
        this.func_184212_Q().func_187214_a(SHOOTING_TIME, (Object)0);
        this.func_184212_Q().func_187214_a(TARGET_ENTITY, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (HERMIT_INDEX.equals(key)) {
            this.setHermit(Hermits.values()[(Integer)this.func_184212_Q().func_187225_a(HERMIT_INDEX)]);
        }
        if (SHOOTING_TIME.equals(key)) {
            this.shootingTime = (Integer)this.field_70180_af.func_187225_a(SHOOTING_TIME);
        }
    }

    private void setTargetEntity(int entityId) {
        this.func_184212_Q().func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    @Nullable
    private Entity getTargetedEntity() {
        return this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(TARGET_ENTITY)).intValue());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 12.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{((Object)((Object)this)).getClass()}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.changeCombat(true);
        return livingdata;
    }

    private void changeCombat(boolean standard) {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.hermitBossStandardAttack);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.rangedAttack);
        switch (this.hermit) {
            case XISUMA: 
            case ISKALL85: 
            case XBCRAFTED: 
            case CUBFAN135: {
                if (this.field_70146_Z.nextInt(6) == 0 && !standard) {
                    this.shootingTime = 1;
                    this.field_70180_af.func_187227_b(SHOOTING_TIME, (Object)1);
                    this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.rangedAttack);
                    break;
                }
                this.shootingTime = 0;
                this.field_70180_af.func_187227_b(SHOOTING_TIME, (Object)0);
                this.shootingTimeLast = 0;
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.hermitBossStandardAttack);
                break;
            }
            case IJEVIN: {
                if (this.field_70146_Z.nextInt(7) == 0) {
                    EntityJevinSlime slime = new EntityJevinSlime(this.field_70170_p);
                    this.prepareMinion((EntityLivingBase)slime);
                    slime.setSize(3);
                    slime.func_70659_e(8.0f);
                    this.field_70170_p.func_72838_d((Entity)slime);
                }
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.hermitBossStandardAttack);
                break;
            }
            case BIFFA2001: {
                if (this.field_70146_Z.nextInt(7) == 0) {
                    EntityWolf wolf = new EntityWolf(this.field_70170_p);
                    this.prepareMinion((EntityLivingBase)wolf);
                    wolf.func_70916_h(true);
                    wolf.func_70624_b(this.func_70638_az());
                    wolf.func_130011_c((Entity)this.func_110144_aD());
                    this.field_70170_p.func_72838_d((Entity)wolf);
                }
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.hermitBossStandardAttack);
                break;
            }
            case ZOMBIECLEO: 
            case WELSKNIGHT: {
                if (this.field_70146_Z.nextInt(7) == 0) {
                    EntityZombie miniHusk = new EntityZombie(this.field_70170_p);
                    this.prepareMinion((EntityLivingBase)miniHusk);
                    miniHusk.func_189778_a(ZombieType.HUSK);
                    if (this.hermit == Hermits.WELSKNIGHT) {
                        ArrayList<ItemStack> headGear = new ArrayList<ItemStack>();
                        headGear.add(new ItemStack((Item)Items.field_151024_Q));
                        headGear.add(new ItemStack((Item)Items.field_151028_Y));
                        headGear.add(new ItemStack((Item)Items.field_151169_ag));
                        headGear.add(new ItemStack((Item)Items.field_151020_U));
                        headGear.add(new ItemStack((Item)Items.field_151161_ac));
                        ArrayList<ItemStack> chestGear = new ArrayList<ItemStack>();
                        chestGear.add(new ItemStack((Item)Items.field_151027_R));
                        chestGear.add(new ItemStack((Item)Items.field_151030_Z));
                        chestGear.add(new ItemStack((Item)Items.field_151171_ah));
                        chestGear.add(new ItemStack((Item)Items.field_151023_V));
                        chestGear.add(new ItemStack((Item)Items.field_151163_ad));
                        ArrayList<ItemStack> legGear = new ArrayList<ItemStack>();
                        legGear.add(new ItemStack((Item)Items.field_151026_S));
                        legGear.add(new ItemStack((Item)Items.field_151165_aa));
                        legGear.add(new ItemStack((Item)Items.field_151149_ai));
                        legGear.add(new ItemStack((Item)Items.field_151022_W));
                        legGear.add(new ItemStack((Item)Items.field_151173_ae));
                        ArrayList<ItemStack> footGear = new ArrayList<ItemStack>();
                        footGear.add(new ItemStack((Item)Items.field_151021_T));
                        footGear.add(new ItemStack((Item)Items.field_151167_ab));
                        footGear.add(new ItemStack((Item)Items.field_151151_aj));
                        footGear.add(new ItemStack((Item)Items.field_151029_X));
                        footGear.add(new ItemStack((Item)Items.field_151175_af));
                        ArrayList<ItemStack> handGear = new ArrayList<ItemStack>();
                        handGear.add(new ItemStack(Items.field_151041_m));
                        handGear.add(new ItemStack(Items.field_151052_q));
                        handGear.add(new ItemStack(Items.field_151040_l));
                        handGear.add(new ItemStack(Items.field_151010_B));
                        handGear.add(new ItemStack(Items.field_151048_u));
                        miniHusk.func_184201_a(EntityEquipmentSlot.HEAD, (ItemStack)headGear.get(this.field_70146_Z.nextInt(headGear.size())));
                        miniHusk.func_184201_a(EntityEquipmentSlot.CHEST, (ItemStack)chestGear.get(this.field_70146_Z.nextInt(chestGear.size())));
                        miniHusk.func_184201_a(EntityEquipmentSlot.LEGS, (ItemStack)legGear.get(this.field_70146_Z.nextInt(legGear.size())));
                        miniHusk.func_184201_a(EntityEquipmentSlot.FEET, (ItemStack)footGear.get(this.field_70146_Z.nextInt(footGear.size())));
                        miniHusk.func_184201_a(EntityEquipmentSlot.MAINHAND, (ItemStack)handGear.get(this.field_70146_Z.nextInt(handGear.size())));
                    } else {
                        miniHusk.func_82227_f(true);
                    }
                    this.field_70170_p.func_72838_d((Entity)miniHusk);
                }
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.hermitBossStandardAttack);
                break;
            }
            case KINGDADDYDMAC: {
                if (this.field_70146_Z.nextInt(7) == 0) {
                    EntityAngryVillager villager = new EntityAngryVillager(this.field_70170_p);
                    this.prepareMinion((EntityLivingBase)villager);
                    this.field_70170_p.func_72838_d((Entity)villager);
                }
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.hermitBossStandardAttack);
                break;
            }
            case PYTHONGB: {
                if (this.field_70146_Z.nextInt(6) == 0) {
                    EntitySmallSnake snake = new EntitySmallSnake(this.field_70170_p);
                    this.prepareMinion((EntityLivingBase)snake);
                    this.field_70170_p.func_72838_d((Entity)snake);
                }
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.hermitBossStandardAttack);
                break;
            }
            case FALSESYMMETRY: {
                this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 10, 2));
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.hermitBossStandardAttack);
                break;
            }
            case RENDOG: {
                if (this.minionCount < 9 && this.func_70643_av() != null) {
                    EntityDiabloElPollo diablo = new EntityDiabloElPollo(this.field_70170_p, this);
                    this.prepareMinion((EntityLivingBase)diablo);
                    this.field_70170_p.func_72838_d((Entity)diablo);
                }
            }
            case JOEHILLS: {
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.bossTeleport();
                }
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.hermitBossStandardAttack);
                break;
            }
            case ZUELJIN: {
                if (this.field_70146_Z.nextInt(3) == 0 && this.func_70643_av() != null) {
                    EntityLivingBase target = this.func_70643_av();
                    double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
                    double d1 = target.field_70165_t + target.field_70159_w - this.field_70165_t;
                    double d2 = d0 - this.field_70163_u;
                    double d3 = target.field_70161_v + target.field_70179_y - this.field_70161_v;
                    float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
                    PotionType potiontype = PotionTypes.field_185246_r;
                    EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potiontype));
                    entitypotion.field_70125_A -= -20.0f;
                    entitypotion.func_70186_c(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    this.field_70170_p.func_72838_d((Entity)entitypotion);
                }
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.hermitBossStandardAttack);
                break;
            }
            case HYPNO: {
                EntityLivingBase target;
                if (this.field_70146_Z.nextInt(4) == 0 && (target = this.func_70643_av()) != null) {
                    double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
                    double d1 = target.field_70165_t + target.field_70159_w - this.field_70165_t;
                    double d2 = d0 - this.field_70163_u;
                    double d3 = target.field_70161_v + target.field_70179_y - this.field_70161_v;
                    float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
                    Potion pot = MobEffects.field_76431_k;
                    PotionEffect ef = new PotionEffect(pot, 400, 1, true, false);
                    ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
                    effects.add(ef);
                    ItemStack potionStack = new ItemStack((Item)Items.field_185155_bH);
                    PotionUtils.func_185184_a((ItemStack)potionStack, effects);
                    PotionType potiontype = PotionTypes.field_185226_I;
                    EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a((ItemStack)potionStack, (PotionType)potiontype));
                    entitypotion.field_70125_A -= -20.0f;
                    entitypotion.func_70186_c(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    this.field_70170_p.func_72838_d((Entity)entitypotion);
                }
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.hermitBossStandardAttack);
                break;
            }
            case GOODTIMESWITHSCAR: {
                if (this.field_70146_Z.nextInt(4) == 0) {
                    BlockPos leavesPos = new BlockPos(this.field_70165_t + this.func_70040_Z().field_72450_a, this.field_70163_u, this.field_70161_v + this.func_70040_Z().field_72449_c);
                    if (!this.field_70170_p.func_175623_d(leavesPos)) {
                        leavesPos = leavesPos.func_177984_a();
                    }
                    if (this.field_70170_p.func_175623_d(leavesPos)) {
                        ArrayList<IBlockState> leaves = new ArrayList<IBlockState>();
                        leaves.add(Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK));
                        leaves.add(Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.BIRCH));
                        leaves.add(Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE));
                        leaves.add(Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE));
                        leaves.add(Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.ACACIA));
                        leaves.add(Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.DARK_OAK));
                        this.field_70170_p.func_175656_a(leavesPos, (IBlockState)leaves.get(this.field_70146_Z.nextInt(leaves.size())));
                        this.func_184609_a(this.func_184600_cs());
                        if (this.field_70146_Z.nextInt(2) == 0 && this.field_70170_p.func_175623_d(leavesPos.func_177984_a())) {
                            this.field_70170_p.func_175656_a(leavesPos.func_177984_a(), (IBlockState)leaves.get(this.field_70146_Z.nextInt(leaves.size())));
                            this.func_184609_a(this.func_184600_cs());
                        }
                    }
                }
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.hermitBossStandardAttack);
                break;
            }
            case JESSASSIN: {
                if (this.func_70643_av() != null && this.func_70643_av() instanceof EntityPlayer) {
                    this.func_184212_Q().func_187227_b(TARGET_ENTITY, (Object)this.func_70643_av().func_145782_y());
                    if (this.targetAirTicks == 200) {
                        ((EntityPlayer)this.func_70643_av()).func_146105_b((ITextComponent)new TextComponentString("<Jessassin> You're about to drown >:D"));
                    }
                }
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.hermitBossStandardAttack);
                break;
            }
            default: {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.hermitBossStandardAttack);
            }
        }
    }

    private void bossTeleport() {
        this.func_184595_k(this.field_70165_t + (double)(6 - this.field_70146_Z.nextInt(13)), this.field_70163_u, this.field_70161_v + (double)(6 - this.field_70146_Z.nextInt(13)));
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
        this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
    }

    private void prepareMinion(EntityLivingBase minion) {
        minion.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        minion.field_70159_w = this.func_70040_Z().field_72450_a;
        minion.field_70181_x = 0.6;
        minion.field_70179_y = this.func_70040_Z().field_72449_c;
        ++this.minionCount;
    }

    public void decreaseMinion() {
        --this.minionCount;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(180.0);
    }

    public void func_70636_d() {
        Entity p;
        super.func_70636_d();
        this.bossInfo.func_186739_a(this.getBossName());
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (((Integer)this.func_184212_Q().func_187225_a(HERMIT_INDEX)).intValue() == Hermits.JESSASSIN.ordinal() && (p = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(TARGET_ENTITY)).intValue())) != null && p instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)p;
            if (this.targetAirTicks > 0) {
                --this.targetAirTicks;
            } else {
                --this.targetDrownTicks;
                if (this.targetDrownTicks < 0) {
                    this.targetDrownTicks = 20;
                    player.func_70097_a(DamageSource.field_76369_e, 1.0f);
                }
            }
        }
        if ((((Integer)this.func_184212_Q().func_187225_a(HERMIT_INDEX)).intValue() == Hermits.XBCRAFTED.ordinal() || ((Integer)this.func_184212_Q().func_187225_a(HERMIT_INDEX)).intValue() == Hermits.CUBFAN135.ordinal()) && (Integer)this.func_184212_Q().func_187225_a(SHOOTING_TIME) > 0 && this.getTargetedEntity() != null) {
            SoundEvent sound;
            EnumParticleTypes particle;
            if (((Integer)this.func_184212_Q().func_187225_a(HERMIT_INDEX)).intValue() == Hermits.XBCRAFTED.ordinal()) {
                particle = EnumParticleTypes.WATER_BUBBLE;
                sound = SoundEvents.field_187675_cd;
            } else {
                particle = EnumParticleTypes.SMOKE_NORMAL;
                sound = SoundEvents.field_187631_bo;
            }
            Entity entity = this.getTargetedEntity();
            this.func_70671_ap().func_75651_a(entity, 90.0f, 90.0f);
            this.func_70671_ap().func_75649_a();
            double d5 = (float)this.shootingTime / 120.0f;
            double d0 = entity.field_70165_t - this.field_70165_t;
            double d1 = entity.field_70163_u + (double)(entity.field_70131_O * 0.5f) - (this.field_70163_u + (double)this.func_70047_e());
            double d2 = entity.field_70161_v - this.field_70161_v;
            double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
            d0 /= d3;
            d1 /= d3;
            d2 /= d3;
            double d4 = this.field_70146_Z.nextDouble();
            this.func_184185_a(sound, 1.0f, 1.0f);
            while (d4 < d3) {
                this.field_70170_p.func_175688_a(particle, this.field_70165_t + d0 * (d4 += 1.8 - d5 + this.field_70146_Z.nextDouble() * (1.7 - d5)), this.field_70163_u + d1 * d4 + (double)this.func_70047_e(), this.field_70161_v + d2 * d4, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void func_70071_h_() {
        block4: {
            block3: {
                super.func_70071_h_();
                ++this.livingTicks;
                if (this.shootingTime > 0) {
                    ++this.shootingTime;
                    this.field_70180_af.func_187227_b(SHOOTING_TIME, (Object)this.shootingTime);
                }
                if (this.hermit != Hermits.IJEVIN && this.hermit != Hermits.HYPNO) break block3;
                List potList = this.field_70170_p.func_72872_a(EntityPotion.class, this.func_174813_aQ().func_186662_g(1.0));
                for (EntityPotion pot : potList) {
                    ItemStack itemstack = pot.func_184543_l();
                    PotionType potiontype = PotionUtils.func_185191_c((ItemStack)itemstack);
                    if (!potiontype.func_185174_b("").contains("water")) continue;
                    EntityDamageSource ds = new EntityDamageSource("water", (Entity)pot.func_85052_h());
                    this.func_70097_a((DamageSource)ds, 1.0f);
                }
                break block4;
            }
            if (this.hermit != Hermits.ZOMBIECLEO) break block4;
            List potList = this.field_70170_p.func_72872_a(EntityPotion.class, this.func_174813_aQ().func_186662_g(1.0));
            for (EntityPotion pot : potList) {
                ItemStack itemstack = pot.func_184543_l();
                PotionType potiontype = PotionUtils.func_185191_c((ItemStack)itemstack);
                if (!potiontype.func_185174_b("").contains("healing")) continue;
                EntityDamageSource ds = new EntityDamageSource("healing", (Entity)pot.func_85052_h());
                this.func_70097_a((DamageSource)ds, 1.0f);
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        List list = this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0), Predicates.and((Predicate)EntitySelectors.field_94557_a, (Predicate)EntitySelectors.field_180132_d));
        for (int i = 0; i < 10 && !list.isEmpty(); ++i) {
            EntityPlayer player = (EntityPlayer)list.get(this.field_70146_Z.nextInt(list.size()));
            if (player != null && player.func_70089_S() && this.func_70685_l((Entity)player)) {
                if (player.field_71075_bZ.field_75102_a || player.field_71075_bZ.field_75098_d) break;
                this.func_70624_b((EntityLivingBase)player);
                break;
            }
            list.remove(player);
        }
        int shootingTimer = 80;
        if (this.hermit == Hermits.XBCRAFTED) {
            shootingTimer = 120;
        }
        if (this.hermit == Hermits.CUBFAN135) {
            shootingTimer = 10;
        }
        if (this.field_70146_Z.nextInt(12) == 0 && (this.shootingTime > shootingTimer + this.field_70146_Z.nextInt(shootingTimer) || this.shootingTime == 0)) {
            this.changeCombat(false);
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected int func_70693_a(EntityPlayer player) {
        return 150;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        float damage;
        float damageFactor = 0.05f;
        Entity sourceEntity = source.func_76346_g();
        if (this.hermit == Hermits.XISUMA) {
            Object heldStack;
            if (sourceEntity != null && sourceEntity instanceof EntityLivingBase && (heldStack = ((EntityLivingBase)sourceEntity).func_184614_ca()) == null) {
                damageFactor = 4.0f + this.field_70146_Z.nextFloat() * 4.0f;
            }
        } else if (this.hermit == Hermits.ISKALL85) {
            if (source.func_76364_f() != null && source.func_76364_f() instanceof EntityDioriteArrow) {
                damageFactor = 1.0f;
            }
        } else if (this.hermit == Hermits.FALSESYMMETRY) {
            if (source.func_76364_f() != null && source.func_76364_f() instanceof EntityThrowableGoldenApple) {
                amount = 6.0f;
                damageFactor = 1.0f;
            }
        } else if (this.hermit == Hermits.RENDOG) {
            if (sourceEntity != null) {
                for (ItemStack heldStack : sourceEntity.func_184214_aD()) {
                    if (heldStack == null || heldStack.func_77973_b() != Items.field_151056_x) continue;
                    damageFactor = 1.0f;
                }
            }
        } else if (this.hermit == Hermits.IJEVIN || this.hermit == Hermits.HYPNO) {
            if (source.func_76355_l() == "water") {
                damageFactor = 12.0f;
            }
        } else if (this.hermit == Hermits.ZOMBIECLEO) {
            if (source.func_76355_l() == "healing") {
                damageFactor = 22.0f;
            }
        } else if (this.hermit == Hermits.CUBFAN135) {
            if (sourceEntity != null) {
                for (ItemStack heldStack : sourceEntity.func_184214_aD()) {
                    if (heldStack == null || heldStack.func_77973_b() != Items.field_151097_aZ || !(sourceEntity instanceof EntityLivingBase)) continue;
                    heldStack.func_77972_a(2, (EntityLivingBase)sourceEntity);
                    damageFactor = 4.0f + this.field_70146_Z.nextFloat() * 4.0f;
                }
            }
        } else if (this.hermit == Hermits.KINGDADDYDMAC) {
            if (sourceEntity != null) {
                ArrayList<Item> weaknessItem = new ArrayList<Item>();
                weaknessItem.add(Items.field_151006_E);
                weaknessItem.add(Items.field_151011_C);
                weaknessItem.add(Items.field_151005_D);
                weaknessItem.add(Items.field_151010_B);
                for (ItemStack heldStack : sourceEntity.func_184214_aD()) {
                    if (heldStack == null || !weaknessItem.contains(heldStack.func_77973_b())) continue;
                    damageFactor = 1.0f;
                }
            }
        } else if (this.hermit == Hermits.PYTHONGB) {
            if (this.vulnerable) {
                damageFactor = source.field_76373_n == "fire" ? 1.0f : 0.7f;
                if (this.livingTicks - this.lastVulnerable > 200) {
                    this.vulnerable = false;
                }
            }
        } else if (this.hermit == Hermits.WELSKNIGHT) {
            if (source.func_76364_f() != null && source.func_76364_f() instanceof EntityArrow) {
                damageFactor = 1.0f;
            }
        } else if (this.hermit == Hermits.XBCRAFTED) {
            if (source.func_76346_g() != null) {
                source.func_76346_g().func_70097_a(DamageSource.func_92087_a((Entity)this), 2.0f);
            }
            if (source == DamageSource.field_76371_c) {
                damageFactor = 1.0f;
            }
        } else if (this.hermit == Hermits.ZUELJIN) {
            if (this.field_70134_J) {
                damageFactor = 0.8f;
            }
        } else if (this.hermit == Hermits.JOEHILLS) {
            if (this.field_70146_Z.nextInt(4) == 0) {
                this.bossTeleport();
            } else if (source.func_76364_f() != null && source.func_76364_f() instanceof EntityThrowableBook) {
                amount = 6.0f;
                damageFactor = 1.0f;
            }
        } else if (this.hermit == Hermits.JESSASSIN) {
            if (source.func_76364_f() != null && source.func_76364_f() instanceof EntityThrowableTorch) {
                amount = 6.0f;
                damageFactor = 1.0f;
            }
        } else if (this.hermit == Hermits.BIFFA2001) {
            for (PotionEffect effect : this.func_70651_bq()) {
                if (effect.func_188419_a() != HQPotionType.EFFECT_RELAXING) continue;
                damageFactor = 1.0f;
            }
        } else if (this.hermit == Hermits.GOODTIMESWITHSCAR) {
            AxisAlignedBB axis = new AxisAlignedBB(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v));
            List cats = this.field_70170_p.func_72872_a(EntityOcelot.class, axis.func_72314_b(8.0, 4.0, 8.0));
            if (cats.size() > 0) {
                if (!this.field_70170_p.field_72995_K && source.func_76346_g() instanceof EntityPlayer) {
                    ((EntityPlayer)source.func_76346_g()).func_146105_b((ITextComponent)new TextComponentString("<GoodTimesWithScar> I can't defend my self when pretty little kitties are around! :S"));
                }
                damageFactor = 1.0f;
            }
        } else if (sourceEntity != null) {
            for (ItemStack heldStack : sourceEntity.func_184214_aD()) {
                if (heldStack == null || heldStack.func_77973_b() != Items.field_151056_x) continue;
                damageFactor = 2.0f;
            }
        }
        if (super.func_70097_a(source, damage = amount * damageFactor)) {
            boolean flag = true;
            if (sourceEntity instanceof EntityPlayer && ((EntityPlayer)sourceEntity).field_71075_bZ.field_75098_d) {
                flag = false;
            }
            if (!(sourceEntity instanceof EntityLivingBase)) {
                flag = false;
            }
            if (flag) {
                this.func_130011_c(sourceEntity);
            }
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        DamageSource source;
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (this.hermit == Hermits.XISUMA) {
            f += 16.0f;
        }
        if (flag = entity.func_70097_a(source = DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            if (this.func_70027_ad()) {
                entity.func_70015_d(11);
            }
            if (entity instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entity;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : null;
                if (itemstack != null && itemstack1 != null && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entity);
            this.func_184609_a(EnumHand.MAIN_HAND);
        }
        return flag;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand, @Nullable ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K && this.hermit == Hermits.PYTHONGB && !this.func_70027_ad()) {
                this.func_70015_d(11);
                stack.func_77972_a(2, (EntityLivingBase)player);
                this.vulnerable = true;
                this.lastVulnerable = this.livingTicks;
                this.func_70097_a((DamageSource)new EntityDamageSource("fire", (Entity)player), 9.0f);
                return true;
            }
        }
        return super.func_184645_a(player, hand, stack);
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
    }

    protected SoundEvent func_184639_G() {
        return this.hermit.AMBIENT_SOUND;
    }

    protected SoundEvent func_184601_bQ() {
        return this.hermit.HURT_SOUND;
    }

    protected SoundEvent func_184615_bR() {
        return this.hermit.DEATH_SOUND;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        super.func_180429_a(pos, block);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.hermit.LOOT_TABLE;
    }

    public void func_70645_a(DamageSource cause) {
        ItemStack banner = ItemHermitBanner.getHermitBannerFromIndex(this.hermit.ordinal());
        EntityItem itemEntity = new EntityItem(this.field_70170_p);
        itemEntity.func_92058_a(banner);
        itemEntity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)itemEntity);
        }
        super.func_70645_a(cause);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slot) {
        return null;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    public String func_70005_c_() {
        String name;
        if (this.func_145818_k_()) {
            name = this.func_95999_t();
        } else {
            Hermits h = Hermits.values()[this.getHermitIdFromData()];
            name = h.NAME;
        }
        return name;
    }

    public ITextComponent getBossName() {
        return new TextComponentString(this.func_70005_c_() + " Boss");
    }

    public boolean isWearing(EnumPlayerModelParts part) {
        return true;
    }

    private int getHermitIdFromData() {
        return (Integer)this.func_184212_Q().func_187225_a(HERMIT_INDEX);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getLocationSkin() {
        int hIndex = this.getHermitIdFromData();
        return new ResourceLocation("hermitquest", "textures/entity/hermits/" + Hermits.values()[hIndex].NAME + ".png");
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("HermitIndex")) {
            int hId = compound.func_74762_e("HermitIndex");
            this.setHermit(Hermits.values()[hId]);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("HermitIndex", this.getHermitIdFromData());
    }

    public void func_82196_d(EntityLivingBase target, float f1) {
        switch (this.hermit) {
            case XISUMA: {
                if (this.shootingTime - this.shootingTimeLast <= 8 + this.field_70146_Z.nextInt(12)) break;
                this.shootingTimeLast = this.shootingTime;
                this.func_184185_a(HQSoundEvents.FIREBALL_SHOOT, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + 1.5f);
                this.func_184609_a(EnumHand.MAIN_HAND);
                ItemImpFireball.shootFireball(this.field_70170_p, (EntityLivingBase)this, EnumHand.MAIN_HAND);
                break;
            }
            case ISKALL85: {
                this.func_184185_a(HQSoundEvents.BEAM_SHOT, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + 1.5f);
                if (this.field_70170_p.field_72995_K) break;
                EntityIskallBeam beam = new EntityIskallBeam(this.field_70170_p, (EntityLivingBase)this, this.func_70040_Z().field_72450_a, this.func_70040_Z().field_72448_b, this.func_70040_Z().field_72449_c);
                beam.damage = 2;
                this.field_70170_p.func_72838_d((Entity)beam);
                break;
            }
            case XBCRAFTED: {
                if (this.func_70638_az() == null) break;
                EntityLivingBase entitylivingbase = this.func_70638_az();
                this.setTargetEntity(entitylivingbase.func_145782_y());
                if (!((float)this.shootingTime > 80.0f)) break;
                entitylivingbase.func_70097_a(DamageSource.func_92087_a((Entity)this), 3.0f);
                this.shootingTime -= 10 + this.field_70146_Z.nextInt(50);
                if (this.field_70146_Z.nextInt(100) != 0) break;
                this.changeCombat(true);
                break;
            }
            case CUBFAN135: {
                if (this.func_70638_az() == null) break;
                EntityLivingBase entitylivingbase = this.func_70638_az();
                this.setTargetEntity(entitylivingbase.func_145782_y());
                if (!((float)this.shootingTime > 6.0f)) break;
                entitylivingbase.func_70097_a(DamageSource.field_76376_m, 1.0f);
                entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 2));
                this.changeCombat(true);
                break;
            }
        }
    }
}

