/*
 * Decompiled with CFR 0.152.
 */
package zairus.hermitquest.client.renderer;

import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderFactory<T extends Entity>
implements IRenderFactory<T> {
    public final Class<? extends Render<? super T>> renderClass;

    public static <T extends Entity> RenderFactory<T> create(Class<? extends Render<? super T>> renderClass) {
        return new RenderFactory<T>(renderClass);
    }

    public static <T extends Entity> RenderFactory<T> createR2(Class<? extends Render> renderClass) {
        return new RenderFactory<T>(renderClass);
    }

    public RenderFactory(Class<? extends Render<? super T>> clazz) {
        this.renderClass = clazz;
    }

    public Render<? super T> createRenderFor(RenderManager manager) {
        try {
            return this.renderClass.getConstructor(RenderManager.class).newInstance(manager);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to construct an entity renderer of type " + this.renderClass + ".", e);
        }
    }
}

