/*
 * Decompiled with CFR 0.152.
 */
package zairus.hermitquest.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zairus.hermitquest.client.renderer.ISpecialRendered;
import zairus.hermitquest.client.renderer.tileentity.TileEntityHermitBannerRenderer;
import zairus.hermitquest.item.HQItems;
import zairus.hermitquest.tileentity.TileEntityHermitBanner;

public class BlockHermitBanner
extends BlockContainer
implements ISpecialRendered {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyInteger ROTATION = PropertyInteger.func_177719_a((String)"rotation", (int)0, (int)15);
    protected static final AxisAlignedBB STANDING_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);

    public BlockHermitBanner() {
        super(Material.field_151575_d);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityHermitBanner(meta);
    }

    public String func_149732_F() {
        return I18n.func_74838_a((String)"item.banner.Xisuma.name");
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_181623_g() {
        return false;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return HQItems.HERMIT_BANNER;
    }

    @Nullable
    private ItemStack getTileDataItemStack(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        ItemStack bannerStack = null;
        if (tileEntity instanceof TileEntityHermitBanner) {
            TileEntityHermitBanner banner = (TileEntityHermitBanner)tileEntity;
            bannerStack = banner.getBannerStack();
        }
        return bannerStack;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        ItemStack itemstack = this.getTileDataItemStack(world, pos, state);
        return itemstack != null ? itemstack : new ItemStack(HQItems.HERMIT_BANNER);
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(world, pos, state, chance, fortune);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return !this.func_181087_e(world, pos) && super.func_176196_c(world, pos);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        if (te instanceof TileEntityHermitBanner) {
            TileEntityHermitBanner banner = (TileEntityHermitBanner)te;
            ItemStack itemstack = banner.getBannerStack();
            BlockHermitBanner.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemstack);
        } else {
            super.func_180657_a(world, player, pos, state, (TileEntity)null, stack);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity te = world.func_175625_s(pos);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (te instanceof TileEntityHermitBanner) {
            TileEntityHermitBanner banner = (TileEntityHermitBanner)te;
            ItemStack item = banner.getBannerStack();
            ret.add(item);
        } else {
            ret.add(new ItemStack(HQItems.HERMIT_BANNER, 1, 0));
        }
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Object getTESR() {
        return new TileEntityHermitBannerRenderer();
    }

    public static class BlockHermitBannerStanding
    extends BlockHermitBanner {
        public BlockHermitBannerStanding() {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(0)));
        }

        public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
            return STANDING_AABB;
        }

        public IBlockState func_185499_a(IBlockState state, Rotation rot) {
            return state.func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(rot.func_185833_a(((Integer)state.func_177229_b((IProperty)ROTATION)).intValue(), 16)));
        }

        public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
            return state.func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(mirror.func_185802_a(((Integer)state.func_177229_b((IProperty)ROTATION)).intValue(), 16)));
        }

        public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
            if (!world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a()) {
                this.func_176226_b(world, pos, state, 0);
                world.func_175698_g(pos);
            }
            super.func_189540_a(state, world, pos, block);
        }

        public IBlockState func_176203_a(int meta) {
            return this.func_176223_P().func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(meta));
        }

        public int func_176201_c(IBlockState state) {
            return (Integer)state.func_177229_b((IProperty)ROTATION);
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{ROTATION});
        }
    }

    public static class BlockHermitBannerHanging
    extends BlockHermitBanner {
        protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 0.78125, 1.0);
        protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.78125, 0.125);
        protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 0.78125, 1.0);
        protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 0.78125, 1.0);

        public BlockHermitBannerHanging() {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        }

        public IBlockState func_185499_a(IBlockState state, Rotation rot) {
            return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
        }

        public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
            return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
        }

        public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                default: {
                    return NORTH_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
                case EAST: 
            }
            return EAST_AABB;
        }

        public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (!world.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_185904_a().func_76220_a()) {
                this.func_176226_b(world, pos, state, 0);
                world.func_175698_g(pos);
                super.func_189540_a(state, world, pos, block);
            }
        }

        public IBlockState func_176203_a(int meta) {
            EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
            if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
                enumfacing = EnumFacing.NORTH;
            }
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }

        public int func_176201_c(IBlockState state) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{FACING});
        }
    }
}

