/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.main;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import elec332.core.api.APIHandlerInject;
import elec332.core.api.IElecCoreMod;
import elec332.core.api.data.IExternalSaveHandler;
import elec332.core.api.module.IModuleContainer;
import elec332.core.api.network.INetworkManager;
import elec332.core.api.network.ModNetworkHandler;
import elec332.core.api.registry.ISingleRegister;
import elec332.core.client.util.WrappedResourcePack;
import elec332.core.java.ReflectionHelper;
import elec332.core.main.ElecCore;
import elec332.core.module.ModuleManager;
import elec332.core.server.SaveHandler;
import elec332.core.util.CommandHelper;
import elec332.core.util.FMLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class ElecModHandler {
    @APIHandlerInject
    private static INetworkManager networkManager;
    private static List<Pair<ModContainer, IElecCoreMod>> mods;

    static void identifyMods() {
        for (ModContainer mc : FMLUtil.getLoader().getActiveModList()) {
            Object o = mc.getMod();
            if (o instanceof ElecCore) {
                mods.add(0, (Pair<ModContainer, IElecCoreMod>)Pair.of((Object)mc, (Object)((IElecCoreMod)o)));
                continue;
            }
            if (!(o instanceof IElecCoreMod)) continue;
            mods.add((Pair<ModContainer, IElecCoreMod>)Pair.of((Object)mc, (Object)((IElecCoreMod)o)));
        }
    }

    static void init() {
        ElecModHandler.init(mods);
        ArrayList modules = Lists.newArrayList();
        for (IModuleContainer moduleContainer : ModuleManager.INSTANCE.getActiveModules()) {
            if (!(moduleContainer.getModule() instanceof IElecCoreMod)) continue;
            modules.add(Pair.of((Object)moduleContainer.getOwnerMod(), (Object)((IElecCoreMod)moduleContainer.getModule())));
        }
        ElecModHandler.init(modules);
    }

    private static void init(List<Pair<ModContainer, IElecCoreMod>> mods) {
        for (Pair<ModContainer, IElecCoreMod> p : mods) {
            IElecCoreMod mod = (IElecCoreMod)p.getRight();
            final ModContainer mc = (ModContainer)p.getLeft();
            mod.registerClientCommands(CommandHelper.getClientCommandRegistry());
            mod.registerServerCommands(CommandHelper.getServerCommandRegistry());
            mod.registerSaveHandlers(new ISingleRegister<IExternalSaveHandler>(){

                @Override
                public boolean register(IExternalSaveHandler iExternalSaveHandler) {
                    return SaveHandler.INSTANCE.registerSaveHandler(mc, (IExternalSaveHandler)Preconditions.checkNotNull((Object)iExternalSaveHandler));
                }
            });
        }
    }

    private static void registerSimpleFieldHandlers(Map<Class<? extends Annotation>, Function<ModContainer, Object>> registry) {
        registry.put(ModNetworkHandler.class, new Function<ModContainer, Object>(){

            @Nullable
            public Object apply(@Nullable ModContainer input) {
                return networkManager.getNetworkHandler(input);
            }
        });
    }

    static void initAnnotations(ASMDataTable dataTable) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            ElecModHandler.setupLangCompat();
        }
        HashMap reg = Maps.newHashMap();
        ElecModHandler.registerSimpleFieldHandlers(reg);
        for (Map.Entry entry : reg.entrySet()) {
            for (ModContainer mc : FMLUtil.getLoader().getActiveModList()) {
                ElecModHandler.parseSimpleFieldAnnotation(mc, (SetMultimap<String, ASMDataTable.ASMData>)dataTable.getAnnotationsFor(mc), ((Class)entry.getKey()).getName(), (Function<ModContainer, Object>)((Function)entry.getValue()));
            }
        }
    }

    private static void parseSimpleFieldAnnotation(ModContainer mc_, SetMultimap<String, ASMDataTable.ASMData> annotations, String annotationClassName, Function<ModContainer, Object> retriever) {
        try {
            String[] annName = annotationClassName.split("\\.");
            String annotationName = annName[annName.length - 1];
            for (ASMDataTable.ASMData targets : annotations.get((Object)annotationClassName)) {
                String targetMod = (String)targets.getAnnotationInfo().get("value");
                Field f = null;
                Object injectedMod = null;
                Object mc = mc_;
                boolean isStatic = false;
                Class<?> clz = mc_.getMod().getClass();
                if (!Strings.isNullOrEmpty((String)targetMod)) {
                    mc = Loader.isModLoaded((String)targetMod) ? (ModContainer)Loader.instance().getIndexedModList().get(targetMod) : null;
                }
                if (mc != null) {
                    try {
                        clz = Class.forName(targets.getClassName(), true, (ClassLoader)Loader.instance().getModClassLoader());
                        f = clz.getDeclaredField(targets.getObjectName());
                        f.setAccessible(true);
                        isStatic = Modifier.isStatic(f.getModifiers());
                        injectedMod = retriever.apply(mc);
                    }
                    catch (Exception e) {
                        Throwables.propagateIfPossible((Throwable)e);
                        FMLLog.log((String)mc_.getModId(), (Level)Level.WARN, (Throwable)e, (String)"Attempting to load @%s in class %s for %s and failing", (Object[])new Object[]{annotationName, targets.getClassName(), mc.getModId()});
                    }
                }
                if (f == null) continue;
                Object target = null;
                if (!isStatic && !(target = mc_.getMod()).getClass().equals(clz)) {
                    FMLLog.log((String)mc_.getModId(), (Level)Level.WARN, (String)"Unable to inject @%s in non-static field %s.%s for %s as it is NOT the primary mod instance", (Object[])new Object[]{annotationName, targets.getClassName(), targets.getObjectName(), mc.getModId()});
                    continue;
                }
                f.set(target, injectedMod);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void setupLangCompat() {
        try {
            List resourcePacks = (List)ReflectionHelper.makeFieldAccessible(FMLClientHandler.class.getDeclaredField("resourcePackList")).get(FMLClientHandler.instance());
            Map resourcePackMap = (Map)ReflectionHelper.makeFieldAccessible(FMLClientHandler.class.getDeclaredField("resourcePackMap")).get(FMLClientHandler.instance());
            for (Pair<ModContainer, IElecCoreMod> mod : mods) {
                if (!((IElecCoreMod)mod.getValue()).useLangCompat()) continue;
                IResourcePack resourcePack = (IResourcePack)resourcePackMap.get(((ModContainer)mod.getKey()).getModId());
                resourcePacks.remove(resourcePack);
                resourcePack = new WrappedResourcePack(resourcePack, (ModContainer)mod.getKey()){

                    @Override
                    @Nonnull
                    public InputStream func_110590_a(@Nonnull ResourceLocation location) throws IOException {
                        try {
                            return super.func_110590_a(location);
                        }
                        catch (Exception e) {
                            if (location.func_110623_a().endsWith(".lang")) {
                                String[] split = location.func_110623_a().split("/");
                                String file = split[split.length - 1];
                                String lang = file.split(".")[0];
                                return super.func_110590_a(new ResourceLocation(location.func_110624_b(), location.func_110623_a().replace(lang, lang.toLowerCase())));
                            }
                            throw e;
                        }
                    }
                };
                resourcePacks.add(resourcePack);
                resourcePackMap.put(((ModContainer)mod.getKey()).getModId(), resourcePack);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mods = Lists.newArrayList();
    }
}

