/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.inventory;

import com.minemaarten.signals.inventory.slots.IPhantomSlot;
import com.minemaarten.signals.network.GuiSynced;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.NetworkUtils;
import com.minemaarten.signals.network.PacketUpdateGui;
import com.minemaarten.signals.network.SyncedField;
import com.minemaarten.signals.tileentity.IGUIButtonSensitive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerBase<Tile extends TileEntity>
extends Container
implements IGUIButtonSensitive {
    public Tile te;
    private final List<SyncedField> syncedFields = new ArrayList<SyncedField>();
    private boolean firstTick = true;
    private int playerSlotsStart;

    public ContainerBase(Tile te) {
        this.te = te;
        if (te != null) {
            this.addSyncedFields(te);
        }
    }

    protected void addSyncedField(SyncedField field) {
        this.syncedFields.add(field);
        field.setLazy(false);
    }

    protected void addSyncedFields(Object annotatedObject) {
        List<SyncedField> fields = NetworkUtils.getSyncedFields(annotatedObject, GuiSynced.class);
        for (SyncedField field : fields) {
            this.addSyncedField(field);
        }
    }

    public void updateField(int index, Object value) {
        this.syncedFields.get(index).setValue(value);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.te == null ? false : player.func_174791_d().func_72438_d(new Vec3d((Vec3i)this.te.func_174877_v())) < 8.0;
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.syncedFields.size(); ++i) {
            if (!this.syncedFields.get(i).update() && !this.firstTick) continue;
            this.sendToCrafters(new PacketUpdateGui(i, this.syncedFields.get(i)));
        }
        this.firstTick = false;
    }

    protected void sendToCrafters(IMessage message) {
        for (IContainerListener crafter : this.field_75149_d) {
            if (!(crafter instanceof EntityPlayerMP)) continue;
            NetworkHandler.sendTo(message, (EntityPlayerMP)crafter);
        }
    }

    protected void addPlayerSlots(InventoryPlayer inventoryPlayer, int yOffset) {
        this.addPlayerSlots(inventoryPlayer, 8, yOffset);
    }

    protected void addPlayerSlots(InventoryPlayer inventoryPlayer, int xOffset, int yOffset) {
        this.playerSlotsStart = this.field_75151_b.size();
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, xOffset + inventoryColumnIndex * 18, yOffset + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, actionBarSlotIndex, xOffset + actionBarSlotIndex * 18, yOffset + 58));
        }
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
        ItemStack var3 = null;
        Slot var4 = (Slot)this.field_75151_b.get(par2);
        if (var4 != null && var4.func_75216_d()) {
            ItemStack var5 = var4.func_75211_c();
            var3 = var5.func_77946_l();
            if (par2 < this.playerSlotsStart) {
                if (!this.func_75135_a(var5, this.playerSlotsStart, this.playerSlotsStart + 36, false)) {
                    return null;
                }
                var4.func_75220_a(var5, var3);
            } else {
                if (!this.func_75135_a(var5, 0, this.playerSlotsStart, false)) {
                    return null;
                }
                var4.func_75220_a(var5, var3);
            }
            if (var5.field_77994_a == 0) {
                var4.func_75215_d((ItemStack)null);
            } else {
                var4.func_75218_e();
            }
            if (var5.field_77994_a == var3.field_77994_a) {
                return null;
            }
            var4.func_82870_a(par1EntityPlayer, var5);
        }
        return var3;
    }

    private ItemStack slotClickPhantom(Slot slot, int mouseButton, int modifier, EntityPlayer player) {
        ItemStack stack = null;
        if (mouseButton == 2) {
            if (((IPhantomSlot)slot).canAdjust()) {
                slot.func_75215_d(null);
            }
        } else if (mouseButton == 0 || mouseButton == 1) {
            InventoryPlayer playerInv = player.field_71071_by;
            slot.func_75218_e();
            ItemStack stackSlot = slot.func_75211_c();
            ItemStack stackHeld = playerInv.func_70445_o();
            if (stackSlot != null) {
                stack = stackSlot.func_77946_l();
            }
            if (stackSlot == null) {
                if (stackHeld != null && slot.func_75214_a(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, modifier);
                }
            } else if (stackHeld == null) {
                this.adjustPhantomSlot(slot, mouseButton, modifier);
                slot.func_82870_a(player, playerInv.func_70445_o());
            } else if (slot.func_75214_a(stackHeld)) {
                if (this.canStacksMerge(stackSlot, stackHeld)) {
                    this.adjustPhantomSlot(slot, mouseButton, modifier);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, modifier);
                }
            }
        }
        return stack;
    }

    public boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    protected void adjustPhantomSlot(Slot slot, int mouseButton, int modifier) {
        int stackSize;
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        ItemStack stackSlot = slot.func_75211_c();
        if (modifier == 1) {
            stackSize = mouseButton == 0 ? (stackSlot.field_77994_a + 1) / 2 : stackSlot.field_77994_a * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.field_77994_a - 1 : stackSlot.field_77994_a + 1;
        }
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        stackSlot.field_77994_a = stackSize;
        if (stackSlot.field_77994_a <= 0) {
            slot.func_75215_d((ItemStack)null);
        }
    }

    protected void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton, int modifier) {
        int stackSize;
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.field_77994_a : 1;
        if (stackSize > slot.func_75219_a()) {
            stackSize = slot.func_75219_a();
        }
        ItemStack phantomStack = stackHeld.func_77946_l();
        phantomStack.field_77994_a = stackSize;
        slot.func_75215_d(phantomStack);
    }

    @Override
    public void handleGUIButtonPress(EntityPlayer player, int ... data) {
        if (this.te instanceof IGUIButtonSensitive) {
            ((IGUIButtonSensitive)this.te).handleGUIButtonPress(player, data);
        }
    }
}

