/*
 * Decompiled with CFR 0.152.
 */
package com.sci.torcherino;

import com.sci.torcherino.TorcherinoRegistry;
import com.sci.torcherino.init.ModBlocks;
import com.sci.torcherino.init.ModRecipes;
import com.sci.torcherino.proxy.CommonProxy;
import com.sci.torcherino.tile.TileCompressedTorcherino;
import com.sci.torcherino.tile.TileDoubleCompressedTorcherino;
import com.sci.torcherino.tile.TileTorcherino;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="Torcherino", name="Torcherino", version="4.2s", acceptedMinecraftVersions="[1.10.2]")
public final class Torcherino {
    private static Torcherino instance;
    @SidedProxy(clientSide="com.sci.torcherino.proxy.ClientProxy", serverSide="com.sci.torcherino.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static boolean logPlacement;
    public static boolean overPoweredRecipe;
    public static boolean compressedTorcherino;
    public static boolean doubleCompressedTorcherino;
    private String[] blacklistedBlocks;
    private String[] blacklistedTiles;
    public static Logger logger;

    @Mod.InstanceFactory
    public static Torcherino instance() {
        if (instance == null) {
            instance = new Torcherino();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        logger = evt.getModLog();
        File folder = new File(evt.getModConfigurationDirectory(), "sci4me");
        if (!folder.exists()) {
            folder.mkdir();
        }
        Configuration cfg = new Configuration(new File(folder, "Torcherino.cfg"));
        try {
            cfg.load();
            logPlacement = cfg.getBoolean("logPlacement", "general", false, "(For Server Owners) Is it logged when someone places a Torcherino?");
            overPoweredRecipe = cfg.getBoolean("overPoweredRecipe", "general", true, "Is the recipe for Torcherino extremely OP?");
            compressedTorcherino = cfg.getBoolean("compressedTorcherino", "general", false, "Is the recipe for the Compressed Torcherino enabled?");
            doubleCompressedTorcherino = cfg.getBoolean("doubleCompressedTorcherino", "general", false, "Is the recipe for the Double Compressed Torcherino enabled? Only takes effect if Compressed Torcherinos are enabled.");
            this.blacklistedBlocks = cfg.getStringList("blacklistedBlocks", "blacklist", new String[0], "modid:unlocalized");
            this.blacklistedTiles = cfg.getStringList("blacklistedTiles", "blacklist", new String[0], "Fully qualified class name");
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
        ModBlocks.init();
        ModRecipes.init();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        TorcherinoRegistry.blacklistBlock(Blocks.field_150350_a);
        TorcherinoRegistry.blacklistBlock((Block)ModBlocks.torcherino);
        TorcherinoRegistry.blacklistBlock((Block)ModBlocks.compressedTorcherino);
        TorcherinoRegistry.blacklistBlock((Block)ModBlocks.doubleCompressedTorcherino);
        TorcherinoRegistry.blacklistTile(TileTorcherino.class);
        TorcherinoRegistry.blacklistTile(TileCompressedTorcherino.class);
        TorcherinoRegistry.blacklistTile(TileDoubleCompressedTorcherino.class);
        TorcherinoRegistry.blacklistBlock((Block)Blocks.field_150355_j);
        TorcherinoRegistry.blacklistBlock((Block)Blocks.field_150358_i);
        TorcherinoRegistry.blacklistBlock((Block)Blocks.field_150353_l);
        TorcherinoRegistry.blacklistBlock((Block)Blocks.field_150356_k);
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        for (String block : this.blacklistedBlocks) {
            this.blacklistBlock(block);
        }
        for (String tile : this.blacklistedTiles) {
            this.blacklistTile(tile);
        }
        proxy.postInit();
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        ModBlocks.handleMissingMappings(event);
    }

    @Mod.EventHandler
    public void imcMessage(FMLInterModComms.IMCEvent evt) {
        for (FMLInterModComms.IMCMessage message : evt.getMessages()) {
            if (!message.isStringMessage()) {
                System.out.println("Received non-string message! Ignoring");
                continue;
            }
            String s = message.getStringValue();
            if (message.key.equals("blacklist-block")) {
                this.blacklistBlock(s);
                continue;
            }
            if (!message.key.equals("blacklist-tile")) continue;
            this.blacklistTile(s);
        }
    }

    private void blacklistBlock(String s) {
        String[] parts = s.split(":");
        if (parts.length != 2) {
            System.out.println("Received malformed message: " + s);
            return;
        }
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(parts[0], parts[1]));
        if (block == null) {
            System.out.println("Could not find block: " + s + ", ignoring");
            return;
        }
        System.out.println("Blacklisting block: " + block.func_149739_a());
        TorcherinoRegistry.blacklistBlock(block);
    }

    private void blacklistTile(String s) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(s);
            if (clazz == null) {
                System.out.println("Class null: " + s);
                return;
            }
            if (!TileEntity.class.isAssignableFrom(clazz)) {
                System.out.println("Class not a TileEntity: " + s);
                return;
            }
            TorcherinoRegistry.blacklistTile(clazz);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found: " + s + ", ignoring");
        }
    }
}

