/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.share;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.IVoxelAccess;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.share.ScreenshotDecoder;
import mod.chiselsandbits.share.ShareFormatReader;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;

public class ShareWorldData {
    private int xSize;
    private int ySize;
    private int zSize;
    private int xySize;
    int[] blocks;
    SharedWorldBlock[] models;
    private byte[] structureData;

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public int getZSize() {
        return this.zSize;
    }

    public ShareWorldData(String data) throws IOException {
        String header = "[C&B](";
        String footer = ")[C&B]";
        int start = data.indexOf("[C&B](");
        int end = data.indexOf(")[C&B]");
        if (start == -1 || end == -1) {
            throw new IOException("Unable to locate C&B Data.");
        }
        data = data.substring(start += "[C&B](".length(), end);
        byte[] compressed = Base64.getDecoder().decode(data);
        this.readCompressed(compressed);
    }

    public ShareWorldData(byte[] compressed) throws IOException {
        this.readCompressed(compressed);
    }

    public ShareWorldData(BufferedImage img) throws IOException {
        byte[] data = new byte[img.getWidth() * img.getHeight() * 4];
        ScreenshotDecoder sdecoder = new ScreenshotDecoder();
        byte[] compressed = sdecoder.imageDecode(data);
        this.readCompressed(compressed);
    }

    private void readCompressed(byte[] compressed) throws IOException {
        int b;
        byte[] uncompressed = null;
        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(compressed));
        ByteArrayOutputStream bout = new ByteArrayOutputStream(compressed.length);
        while ((b = in.read()) != -1) {
            bout.write(b);
        }
        bout.close();
        in.close();
        uncompressed = bout.toByteArray();
        ShareFormatReader reader = new ShareFormatReader(uncompressed);
        int format = reader.readInt();
        if (format != 1) {
            throw new IOException("Invalid format!");
        }
        this.xSize = reader.readInt();
        this.ySize = reader.readInt();
        this.zSize = reader.readInt();
        this.xySize = this.xSize * this.ySize;
        int bits = reader.readInt();
        this.blocks = new int[this.xSize * this.ySize * this.zSize];
        for (int x = 0; x < this.blocks.length; ++x) {
            this.blocks[x] = reader.readBits(bits);
        }
        reader.snapToByte();
        int modelCount = reader.readInt();
        this.models = new SharedWorldBlock[modelCount];
        for (int x = 0; x < this.models.length; ++x) {
            this.models[x] = new SharedWorldBlock(reader.readBytes());
        }
        this.structureData = new byte[Math.min(reader.consumedBytes(), uncompressed.length)];
        System.arraycopy(uncompressed, 0, this.structureData, 0, this.structureData.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getStuctureData() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(this.structureData.length);
        try {
            DeflaterOutputStream zipStream = new DeflaterOutputStream(byteStream);
            try {
                zipStream.write(this.structureData);
            }
            finally {
                zipStream.close();
            }
        }
        finally {
            byteStream.close();
        }
        return byteStream.toByteArray();
    }

    public IVoxelAccess getBlob(int x, int y, int z) {
        SharedWorldBlock swb = this.getAtPos(x, y, z);
        if (swb != null) {
            if (swb.blob == null) {
                IBlockState bs = swb.getState();
                int stateID = Block.func_176210_f((IBlockState)bs);
                if (BlockBitInfo.supportsBlock(bs)) {
                    return new VoxelBlobStateReference(stateID, 0L);
                }
                return new VoxelBlobStateReference(0, 0L);
            }
            return swb.blob;
        }
        return new VoxelBlobStateReference(0, 0L);
    }

    SharedWorldBlock getAtPos(int x, int y, int z) {
        int modelid;
        if (x >= 0 && y >= 0 && z >= 0 && x < this.xSize && y < this.ySize && z < this.zSize && this.models.length > (modelid = this.blocks[x + y * this.xSize + z * this.xySize]) && modelid >= 0) {
            return this.models[modelid];
        }
        return null;
    }

    public IBlockState getStateAt(BlockPos p) {
        SharedWorldBlock swb = this.getAtPos(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
        if (swb != null) {
            if (swb.blob != null) {
                return ChiselsAndBits.getBlocks().getChiseledDefaultState();
            }
            return swb.getState();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public TileEntityBlockChiseled getTileAt(BlockPos p) {
        SharedWorldBlock swb = this.getAtPos(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
        if (swb != null && swb.blob != null) {
            TileEntityBlockChiseled te = new TileEntityBlockChiseled();
            te.setState(te.getBasicState().withProperty(BlockChiseled.UProperty_VoxelBlob, (Object)swb.blob));
            return te;
        }
        return null;
    }

    public static class SharedWorldBlock {
        final boolean isBlob;
        final String blockName;
        final VoxelBlobStateReference blob;

        public SharedWorldBlock(byte[] bytes) {
            if (bytes.length > 0 && bytes[0] == 1) {
                this.blob = null;
                this.isBlob = false;
                this.blockName = new String(bytes, 1, bytes.length - 1);
            } else if (bytes.length > 0 && bytes[0] == 2) {
                this.isBlob = true;
                this.blockName = null;
                byte[] tmp = new byte[bytes.length - 1];
                System.arraycopy(bytes, 1, tmp, 0, tmp.length);
                this.blob = new VoxelBlobStateReference(tmp, 0L);
            } else {
                this.isBlob = false;
                this.blob = null;
                this.blockName = "minecraft:air";
            }
        }

        public IBlockState getState() {
            return ModUtil.getStateFromString((String)this.blockName, (String)"");
        }
    }
}

