/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLLog;
import portablejim.bbw.BetterBuildersWandsMod;
import portablejim.bbw.basics.EnumFluidLock;
import portablejim.bbw.basics.EnumLock;
import portablejim.bbw.basics.Point3d;
import portablejim.bbw.basics.ReplacementTriplet;
import portablejim.bbw.core.conversion.CustomMapping;
import portablejim.bbw.core.wands.IWand;
import portablejim.bbw.shims.IPlayerShim;
import portablejim.bbw.shims.IWorldShim;

public class WandWorker {
    private final IWand wand;
    private final IPlayerShim player;
    private final IWorldShim world;
    HashSet<Point3d> allCandidates = new HashSet();

    public WandWorker(IWand wand, IPlayerShim player, IWorldShim world) {
        this.wand = wand;
        this.player = player;
        this.world = world;
    }

    public ReplacementTriplet getProperItemStack(IWorldShim world, IPlayerShim player, Point3d blockPos) {
        Block block = world.getBlock(blockPos);
        IBlockState startBlockState = world.getWorld().func_180495_p(blockPos.toBlockPos());
        int meta = world.getMetadata(blockPos);
        String blockString = String.format("%s/%s", Block.field_149771_c.func_177774_c((Object)block), meta);
        if (!BetterBuildersWandsMod.instance.configValues.HARD_BLACKLIST_SET.contains(blockString)) {
            RayTraceResult rayTraceResult;
            ArrayList<CustomMapping> customMappings = BetterBuildersWandsMod.instance.mappingManager.getMappings(block, meta);
            for (CustomMapping customMapping : customMappings) {
                if (player.countItems(customMapping.getItems()) <= 0) continue;
                return new ReplacementTriplet(customMapping.getLookBlock().func_176203_a(customMapping.getMeta()), customMapping.getItems(), customMapping.getPlaceBlock().func_176203_a(customMapping.getPlaceMeta()));
            }
            if (startBlockState.func_177230_c() instanceof BlockSlab) {
                Item itemDropped = startBlockState.func_177230_c().func_180660_a(startBlockState, world.rand(), 0);
                ItemStack itemStackDropped = new ItemStack(itemDropped, startBlockState.func_177230_c().func_149745_a(world.rand()), startBlockState.func_177230_c().func_180651_a(startBlockState));
                if (itemDropped != null && player.countItems(itemStackDropped) > 0) {
                    return new ReplacementTriplet(startBlockState, itemStackDropped, startBlockState);
                }
            }
            if ((rayTraceResult = ForgeHooks.rayTraceEyes((EntityLivingBase)player.getPlayer(), (double)player.getReachDistance())) == null) {
                return null;
            }
            ItemStack exactItemstack = block.getPickBlock(startBlockState, rayTraceResult, world.getWorld(), blockPos.toBlockPos(), player.getPlayer());
            if (player.countItems(exactItemstack) > 0) {
                if (exactItemstack != null && exactItemstack.func_77973_b() instanceof ItemBlock) {
                    IBlockState newState = ((ItemBlock)exactItemstack.func_77973_b()).func_179223_d().func_176203_a(exactItemstack.func_77960_j());
                    return new ReplacementTriplet(startBlockState, exactItemstack, newState);
                }
                return null;
            }
            return this.getEquivalentItemStack(blockPos);
        }
        return null;
    }

    public ReplacementTriplet getEquivalentItemStack(Point3d blockPos) {
        ItemStack stack;
        Item dropped;
        Block block = this.world.getBlock(blockPos);
        int meta = this.world.getMetadata(blockPos);
        IBlockState startBlockState = this.world.getWorld().func_180495_p(blockPos.toBlockPos());
        String blockString = String.format("%s/%s", Block.field_149771_c.func_177774_c((Object)block), meta);
        if (!block.canSilkHarvest(this.world.getWorld(), blockPos.toBlockPos(), block.func_176203_a(meta), this.player.getPlayer()) && !BetterBuildersWandsMod.instance.configValues.SOFT_BLACKLIST_SET.contains(blockString) && (dropped = block.func_180660_a(block.func_176203_a(meta), new Random(), 0)) != null && (stack = new ItemStack(dropped, block.quantityDropped(block.func_176203_a(meta), 0, new Random()), block.func_180651_a(block.func_176203_a(meta)))).func_77973_b() instanceof ItemBlock) {
            return new ReplacementTriplet(startBlockState, stack, ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j()));
        }
        return null;
    }

    private boolean shouldContinue(Point3d currentCandidate, Block targetBlock, int targetMetadata, EnumFacing facing, Block candidateSupportingBlock, int candidateSupportingMeta, AxisAlignedBB blockBB, EnumFluidLock fluidLock) {
        if (!this.world.blockIsAir(currentCandidate)) {
            Block currrentCandidateBlock = this.world.getBlock(currentCandidate);
            if (fluidLock != EnumFluidLock.IGNORE || currrentCandidateBlock == null || !(currrentCandidateBlock instanceof IFluidBlock) && !(currrentCandidateBlock instanceof BlockLiquid)) {
                return false;
            }
        }
        if (!targetBlock.equals(candidateSupportingBlock)) {
            return false;
        }
        if (targetMetadata != candidateSupportingMeta) {
            return false;
        }
        if (!targetBlock.func_176196_c(this.world.getWorld(), new BlockPos(currentCandidate.x, currentCandidate.y, currentCandidate.z))) {
            return false;
        }
        if (!targetBlock.func_176193_a(this.world.getWorld(), new BlockPos(currentCandidate.x, currentCandidate.y, currentCandidate.z), facing, new ItemStack(candidateSupportingBlock, 1, candidateSupportingMeta))) {
            return false;
        }
        return !this.world.entitiesInBox(blockBB);
    }

    public LinkedList<Point3d> getBlockPositionList(Point3d blockLookedAt, EnumFacing placeDirection, int maxBlocks, EnumLock directionLock, EnumLock faceLock, EnumFluidLock fluidLock) {
        LinkedList<Point3d> candidates = new LinkedList<Point3d>();
        LinkedList<Point3d> toPlace = new LinkedList<Point3d>();
        Block targetBlock = this.world.getBlock(blockLookedAt);
        int targetMetadata = this.world.getMetadata(blockLookedAt);
        Point3d startingPoint = blockLookedAt.move(placeDirection);
        int directionMaskInt = directionLock.mask;
        int faceMaskInt = faceLock.mask;
        if ((directionLock != EnumLock.HORIZONTAL && directionLock != EnumLock.VERTICAL || placeDirection != EnumFacing.UP && placeDirection != EnumFacing.DOWN) && (directionLock != EnumLock.NORTHSOUTH || placeDirection != EnumFacing.NORTH && placeDirection != EnumFacing.SOUTH) && (directionLock != EnumLock.EASTWEST || placeDirection != EnumFacing.EAST && placeDirection != EnumFacing.WEST)) {
            candidates.add(startingPoint);
        }
        while (candidates.size() > 0 && toPlace.size() < maxBlocks) {
            AxisAlignedBB blockBB;
            int candidateSupportingMeta;
            Point3d supportingPoint;
            Block candidateSupportingBlock;
            Point3d currentCandidate = (Point3d)candidates.removeFirst();
            if (!this.shouldContinue(currentCandidate, targetBlock, targetMetadata, placeDirection, candidateSupportingBlock = this.world.getBlock(supportingPoint = currentCandidate.move(placeDirection.func_176734_d())), candidateSupportingMeta = this.world.getMetadata(supportingPoint), blockBB = targetBlock.func_176203_a(targetMetadata).func_185900_c((IBlockAccess)this.world.getWorld(), new BlockPos(currentCandidate.x, currentCandidate.y, currentCandidate.z)).func_72317_d((double)currentCandidate.x, (double)currentCandidate.y, (double)currentCandidate.z), fluidLock) || !this.allCandidates.add(currentCandidate)) continue;
            toPlace.add(currentCandidate);
            switch (placeDirection) {
                case DOWN: 
                case UP: {
                    if ((faceMaskInt & 2) <= 0) break;
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.NORTH));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.EAST));
                    }
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.SOUTH));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.WEST));
                    }
                    if ((directionMaskInt & 1) <= 0 || (directionMaskInt & 4) <= 0) break;
                    candidates.add(currentCandidate.move(EnumFacing.NORTH).move(EnumFacing.EAST));
                    candidates.add(currentCandidate.move(EnumFacing.NORTH).move(EnumFacing.WEST));
                    candidates.add(currentCandidate.move(EnumFacing.SOUTH).move(EnumFacing.EAST));
                    candidates.add(currentCandidate.move(EnumFacing.SOUTH).move(EnumFacing.WEST));
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if ((faceMaskInt & 1) <= 0) break;
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.UP));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.EAST));
                    }
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.DOWN));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.WEST));
                    }
                    if ((directionMaskInt & 2) <= 0 || (directionMaskInt & 4) <= 0) break;
                    candidates.add(currentCandidate.move(EnumFacing.UP).move(EnumFacing.EAST));
                    candidates.add(currentCandidate.move(EnumFacing.UP).move(EnumFacing.WEST));
                    candidates.add(currentCandidate.move(EnumFacing.DOWN).move(EnumFacing.EAST));
                    candidates.add(currentCandidate.move(EnumFacing.DOWN).move(EnumFacing.WEST));
                    break;
                }
                case WEST: 
                case EAST: {
                    if ((faceMaskInt & 4) <= 0) break;
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.UP));
                    }
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.NORTH));
                    }
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.DOWN));
                    }
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.SOUTH));
                    }
                    if ((directionMaskInt & 2) <= 0 || (directionMaskInt & 1) <= 0) break;
                    candidates.add(currentCandidate.move(EnumFacing.UP).move(EnumFacing.NORTH));
                    candidates.add(currentCandidate.move(EnumFacing.UP).move(EnumFacing.SOUTH));
                    candidates.add(currentCandidate.move(EnumFacing.DOWN).move(EnumFacing.NORTH));
                    candidates.add(currentCandidate.move(EnumFacing.DOWN).move(EnumFacing.SOUTH));
                }
            }
        }
        return toPlace;
    }

    public ArrayList<Point3d> placeBlocks(ItemStack wandItem, LinkedList<Point3d> blockPosList, IBlockState targetBlock, ItemStack sourceItems, EnumFacing side, float hitX, float hitY, float hitZ) {
        ArrayList<Point3d> placedBlocks = new ArrayList<Point3d>();
        for (Point3d blockPos : blockPosList) {
            boolean takeFromInventory;
            boolean blockPlaceSuccess = this.world.setBlock(blockPos, targetBlock);
            if (!blockPlaceSuccess) continue;
            this.world.playPlaceAtBlock(blockPos, targetBlock.func_177230_c());
            placedBlocks.add(blockPos);
            if (!this.player.isCreative()) {
                this.wand.placeBlock(wandItem, (EntityLivingBase)this.player.getPlayer());
            }
            if (takeFromInventory = this.player.useItem(sourceItems)) continue;
            FMLLog.info((String)"BBW takeback: %s", (Object[])new Object[]{blockPos.toString()});
            this.world.setBlockToAir(blockPos);
            placedBlocks.remove(placedBlocks.size() - 1);
        }
        return placedBlocks;
    }
}

