/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.Properties;
import erogenousbeef.bigreactors.common.multiblock.PartTier;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import erogenousbeef.bigreactors.common.multiblock.block.BlockMultiblockDevice;
import erogenousbeef.bigreactors.common.multiblock.block.ControllerState;
import erogenousbeef.bigreactors.common.multiblock.interfaces.IActivateable;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorController;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineController;
import erogenousbeef.bigreactors.init.BrBlocks;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.api.multiblock.MultiblockTileEntityBase;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockMultiblockController
extends BlockMultiblockDevice {
    public BlockMultiblockController(PartType type, String blockName) {
        super(type, blockName);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (this._type) {
            case ReactorController: {
                return new TileEntityReactorController();
            }
            case TurbineController: {
                return new TileEntityTurbineController();
            }
        }
        throw new IllegalArgumentException("Invalid part type");
    }

    @Override
    public void registerRecipes() {
        if (PartType.ReactorController == this._type) {
            if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Legacy)) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Legacy, 1), new Object[]{"C C", "GDG", "CRC", Character.valueOf('D'), Items.field_151045_i, Character.valueOf('G'), BigReactors.CONFIG.recipeYelloriumIngotName, Character.valueOf('C'), BrBlocks.reactorCasing.createItemStack(PartTier.Legacy, 1), Character.valueOf('R'), Items.field_151137_ax}));
            }
            if (PartTier.REACTOR_TIERS.contains((Object)PartTier.Basic)) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Basic, 1), new Object[]{"C C", "GDG", "CRC", Character.valueOf('D'), Items.field_151045_i, Character.valueOf('G'), BigReactors.CONFIG.recipeYelloriumIngotName, Character.valueOf('C'), BrBlocks.reactorCasing.createItemStack(PartTier.Basic, 1), Character.valueOf('R'), Items.field_151137_ax}));
            }
        } else if (PartType.TurbineController == this._type) {
            if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Legacy)) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Legacy, 1), new Object[]{"H H", "BDB", "H H", Character.valueOf('H'), BrBlocks.turbineHousing.createItemStack(PartTier.Legacy, 1), Character.valueOf('D'), Items.field_151045_i, Character.valueOf('B'), BigReactors.CONFIG.recipeBlutoniumIngotName}));
            }
            if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Basic)) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Basic, 1), new Object[]{"H H", "BDB", "H H", Character.valueOf('H'), BrBlocks.turbineHousing.createItemStack(PartTier.Basic, 1), Character.valueOf('D'), Items.field_151045_i, Character.valueOf('B'), BigReactors.CONFIG.recipeBlutoniumIngotName}));
            }
        }
    }

    @Override
    protected void buildBlockState(BlockStateContainer.Builder builder) {
        super.buildBlockState(builder);
        builder.add(new IProperty[]{Properties.CONTROLLERSTATE});
    }

    @Override
    protected IBlockState buildDefaultState(IBlockState state) {
        return super.buildDefaultState(state).func_177226_a(Properties.CONTROLLERSTATE, (Comparable)((Object)ControllerState.Off));
    }

    @Override
    protected IBlockState buildActualState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos position, @Nonnull MultiblockTileEntityBase part) {
        MultiblockControllerBase controller = part.getMultiblockController();
        ControllerState controllerState = null == controller || !controller.isAssembled() || !(controller instanceof IActivateable) ? ControllerState.Off : (((IActivateable)controller).getActive() ? ControllerState.Active : ControllerState.Idle);
        return super.buildActualState(state, world, position, part).func_177226_a(Properties.CONTROLLERSTATE, (Comparable)((Object)controllerState));
    }
}

