/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.wire;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IRedstoneConductor;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.component.wire.ComponentWirePostBase;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class ComponentRedstonePost
extends ComponentWirePostBase {
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "post_rs");
    private byte power = 0;
    private boolean shouldOutputPower = true;
    private boolean shouldPropagate = true;

    public ComponentRedstonePost(ICircuit circuit) {
        super(circuit);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.006f;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isBundled() {
        return false;
    }

    @Override
    public EnumDyeColor getColor() {
        return EnumDyeColor.SILVER;
    }

    @Override
    public boolean isColorBiased() {
        return false;
    }

    @Override
    public byte getInput(EnumDyeColor color) {
        Pair<IComponent, EnumComponentSlot> neighbor;
        if (!this.shouldPropagate) {
            return 0;
        }
        int input = 0;
        Pair<IComponent, EnumComponentSlot> pair = neighbor = this.getNeighbors()[EnumCircuitSide.TOP.ordinal()].getNeighbor() == null ? this.getNeighborPair(EnumComponentSlot.CENTER, EnumCircuitSide.TOP) : null;
        if (neighbor != null && !(neighbor.getKey() instanceof IRedstoneConductor)) {
            for (EnumDyeColor c : EnumDyeColor.values()) {
                input = Math.max(input, ((IComponent)neighbor.getKey()).getOutputSignal((EnumComponentSlot)((Object)neighbor.getValue()), EnumCircuitSide.BOTTOM, c, false) & 0xFF);
            }
        }
        Pair<IComponent, EnumComponentSlot> pair2 = neighbor = this.getNeighbors()[EnumCircuitSide.BOTTOM.ordinal()].getNeighbor() == null ? this.getNeighborPair(EnumComponentSlot.CENTER, EnumCircuitSide.BOTTOM) : null;
        if (neighbor != null && !(neighbor.getKey() instanceof IRedstoneConductor)) {
            for (EnumDyeColor c : EnumDyeColor.values()) {
                input = Math.max(input, ((IComponent)neighbor.getKey()).getOutputSignal((EnumComponentSlot)((Object)neighbor.getValue()), EnumCircuitSide.TOP, c, false) & 0xFF);
            }
        }
        return (byte)input;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        return !bundled && this.shouldOutputPower && this.isOutput(slot, side) ? this.power : (byte)0;
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side.face.func_176740_k() == EnumFacing.Axis.Y;
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side.face.func_176740_k() == EnumFacing.Axis.Y;
    }

    @Override
    public boolean isStrongOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side == EnumCircuitSide.TOP;
    }

    @Override
    public void propagate(IRedstoneConductor from, EnumDyeColor color, Multimap<IRedstoneConductor, EnumDyeColor> wires, Set<Triple<IRedstoneConductor, IRedstoneConductor, EnumDyeColor>> scheduled) {
        if (this.shouldPropagate) {
            super.propagate(from, color, wires, scheduled);
        }
    }

    @Override
    public void onPropagated(Set<EnumDyeColor> colors, byte power) {
        if (this.power != power) {
            this.power = power;
            super.onPropagated(colors, power);
            this.getCircuit().markDirty();
            this.getCircuit().notifyUpdate(this.getPos(), this.getSlot(), this.cond.getNeighbors()[EnumCircuitSide.BOTTOM.ordinal()].getNeighbor() == null ? EnumCircuitSide.BOTTOM : null, this.cond.getNeighbors()[EnumCircuitSide.TOP.ordinal()].getNeighbor() == null ? EnumCircuitSide.TOP : null);
        }
    }

    @Override
    public boolean connect(EnumCircuitSide side, IRedstoneConductor conductor, IRedstoneConductor.EnumConnectionType type, boolean simulated) {
        return side.face.func_176740_k() == EnumFacing.Axis.Y && !conductor.isBundled() && super.connect(side, conductor, type, simulated);
    }

    @Override
    public void onConnect(EnumCircuitSide side, IRedstoneConductor conductor, IRedstoneConductor.EnumConnectionType type) {
        this.getCircuit().markDirty();
    }

    @Override
    public void onDisconnect(EnumCircuitSide side) {
        this.getCircuit().markDirty();
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(SCMItems.resource, 1, EnumResourceType.REDSTONE_STICK.ordinal());
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        super.addSelectionBoxes(boxes);
        double d = 0.4375;
        boxes.add(new AxisAlignedBB(d, 0.0, d, 1.0 - d, 1.0, 1.0 - d));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("power", this.power);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.power = tag.func_74771_c("power");
    }

    @Override
    public void debug(EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentString("Power Level: " + (this.power & 0xFF)));
    }

    public static class Factory
    extends SimpleFactory<ComponentRedstonePost> {
        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[0]);
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/post_rs");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.resource && stack.func_77952_i() == EnumResourceType.REDSTONE_STICK.ordinal();
        }

        @Override
        public ComponentRedstonePost instantiate(ICircuit circuit) {
            return new ComponentRedstonePost(circuit);
        }
    }
}

