/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.api.component;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IRedstoneConductor;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public interface IComponent {
    public static final float COMPONENT_SIZE = 0.125f;

    public ResourceLocation getName();

    public float getComplexity();

    public boolean isDynamic();

    public IBlockState getActualState();

    default public IBlockState getExtendedState(IBlockState state) {
        return state;
    }

    default public float getSize() {
        return 0.125f;
    }

    default public Vec3d getOffset() {
        return null;
    }

    public ICircuit getCircuit();

    public BlockPos getPos();

    public void setPos(BlockPos var1);

    public EnumSet<EnumComponentSlot> getSlots();

    public boolean isInput(EnumComponentSlot var1, EnumCircuitSide var2);

    public boolean isOutput(EnumComponentSlot var1, EnumCircuitSide var2);

    default public boolean isStrongOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return false;
    }

    public byte getOutputSignal(EnumComponentSlot var1, EnumCircuitSide var2, EnumDyeColor var3, boolean var4);

    default public byte getOutputSignalAny(EnumComponentSlot slot, EnumCircuitSide side) {
        int power = 0;
        for (EnumDyeColor color : EnumDyeColor.values()) {
            power = Math.max(power, this.getOutputSignal(slot, side, color, false) & 0xFF);
        }
        return (byte)power;
    }

    default public IRedstoneConductor.EnumConnectionType getBundledConnection(EnumComponentSlot slot, EnumCircuitSide side) {
        return IRedstoneConductor.EnumConnectionType.NONE;
    }

    default public void tick() {
    }

    default public void onCircuitAdded() {
    }

    default public void onCircuitRemoved() {
    }

    default public void onAdded() {
    }

    default public void onAddedPost() {
    }

    default public void onRemoved() {
    }

    default public void onRemovedPost() {
    }

    default public void onScheduledTick(int type, Object data) {
    }

    default public void onNeighborChange(EnumCircuitSide side, EnumComponentSlot slot, IComponent component, EnumCircuitUpdate updateType) {
    }

    default public void onWorldChange() {
    }

    default public void onWorldTileChange() {
    }

    default public boolean canRotate(Rotation rotation) {
        return true;
    }

    default public void rotatePre(Rotation rotation) {
    }

    default public void rotatePost() {
    }

    default public void onLoaded() {
    }

    default public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, Vec3d hit) {
        return false;
    }

    default public boolean harvest(EntityPlayer player, Vec3d hitPos) {
        this.getCircuit().removeComponent(this);
        return true;
    }

    default public boolean isSideSolid(EnumCircuitSide side) {
        return false;
    }

    public void addSelectionBoxes(List<AxisAlignedBB> var1);

    default public AxisAlignedBB getSelectionBox(AxisAlignedBB box) {
        return box;
    }

    public ItemStack getPickedItem();

    public List<ItemStack> getDrops();

    public List<ItemStack> getPlacementItems();

    default public int getColorMultiplier(int index) {
        return -1;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound var1);

    public void readFromNBT(NBTTagCompound var1);

    public void writeDescription(PacketBuffer var1);

    public void readDescription(PacketBuffer var1);

    default public NBTTagCompound serializeTickData(int type, Object data) {
        return null;
    }

    default public Object deserializeTickData(int type, NBTTagCompound tag) {
        return null;
    }

    default public void handleCustomPayload(ByteBuf buf) {
    }

    default public void debug(EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentString("No debug data available"));
    }
}

