/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits;

import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.circuit.Circuit;
import com.amadornes.rscircuits.component.ComponentRegistry;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.network.NetworkHandler;
import com.amadornes.rscircuits.network.PacketCircuitUpdate;
import com.amadornes.rscircuits.util.BoolFunction;
import com.amadornes.rscircuits.util.IntBoolFunction;
import com.google.common.base.Supplier;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Pair;

public class CommonProxy {
    public static final Set<Circuit> updatedCircuits = new HashSet<Circuit>();

    public void preInit() {
    }

    public EntityPlayer getPlayer() {
        return null;
    }

    public RayTraceResult getHit() {
        return null;
    }

    public void playPlaceSound(BlockPos pos) {
    }

    @SubscribeEvent
    public <T> void serverBreakPrevention(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (event.getWorld() != null && !event.getWorld().field_72995_K && stack != null && stack.func_77973_b() == SCMItems.screwdriver) {
            event.setCanceled(true);
            event.setUseItem(Event.Result.DENY);
            event.setUseBlock(Event.Result.DENY);
            event.getWorld().func_180495_p(event.getPos()).func_177230_c().func_180649_a(event.getWorld(), event.getPos(), event.getEntityPlayer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public <T> void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Set<Circuit> set = updatedCircuits;
            synchronized (set) {
                updatedCircuits.forEach(circuit -> {
                    if (circuit.getWorld() == null || circuit.getPos() == null) {
                        return;
                    }
                    PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
                    Map<Pair<BlockPos, EnumComponentSlot>, Boolean> updates = circuit.getUpdates();
                    buf.writeInt(updates.size());
                    updates.forEach((k, v) -> {
                        buf.func_179255_a((BlockPos)k.getKey());
                        buf.func_179249_a((Enum)k.getValue());
                        buf.writeBoolean(v.booleanValue());
                        IComponent comp = circuit.getComponent((BlockPos)k.getKey(), (EnumComponentSlot)((Object)((Object)((Object)k.getValue()))));
                        if (comp == null) {
                            buf.writeBoolean(false);
                        } else {
                            buf.writeBoolean(true);
                            buf.func_180714_a(comp.getName().toString());
                            comp.writeDescription(buf);
                        }
                    });
                    updates.clear();
                    NetworkHandler.instance.sendToAllAround(new PacketCircuitUpdate(circuit.getPos(), circuit.getFace(), buf.array()), circuit.getWorld());
                });
                updatedCircuits.clear();
            }
        }
    }

    public void handleUpdate(Circuit circuit, PacketBuffer buf) {
        boolean reRender = false;
        int count = buf.readInt();
        HashSet<IComponent> newComponents = new HashSet<IComponent>();
        for (int i = 0; i < count; ++i) {
            BlockPos pos = buf.func_179259_c();
            EnumComponentSlot slot = (EnumComponentSlot)buf.func_179257_a(EnumComponentSlot.class);
            reRender |= buf.readBoolean();
            if (buf.readBoolean()) {
                IComponent comp = circuit.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][slot.ordinal()];
                ResourceLocation name = new ResourceLocation(buf.func_150789_c(128));
                if (comp == null || !comp.getName().equals((Object)name)) {
                    circuit.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][slot.ordinal()] = comp = ComponentRegistry.INSTANCE.getFactory(name).instantiate(circuit);
                    comp.setPos(pos);
                    comp.readDescription(buf);
                    IComponent comp_ = comp;
                    comp.getSlots().forEach(s -> {
                        circuit.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][s.ordinal()] = comp_;
                    });
                    newComponents.add(comp);
                    continue;
                }
                comp.readDescription(buf);
                continue;
            }
            circuit.components[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()][slot.ordinal()] = null;
        }
        newComponents.forEach(IComponent::onLoaded);
        if (reRender && !circuit.isEncapsulated()) {
            circuit.getWorld().func_175704_b(circuit.getPos(), circuit.getPos());
        }
    }

    public void displayTimerGui(IntBoolFunction<String> titleSupplier, BoolFunction<String> shortSupplier, Supplier<Integer> getter, Consumer<Integer> setter, int min, int max, double shiftMul) {
    }
}

