/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import java.util.Random;
import lumien.randomthings.block.BlockBase;
import lumien.randomthings.block.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockFertilizedDirt
extends BlockBase {
    boolean tilled;
    protected static final AxisAlignedBB TILLED_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);

    protected BlockFertilizedDirt(boolean tilled) {
        super("fertilizedDirt" + (tilled ? "Tilled" : ""), Material.field_151578_c);
        this.tilled = tilled;
        this.func_149675_a(true);
        this.func_149711_c(0.6f);
        this.func_149672_a(SoundType.field_185849_b);
        if (tilled) {
            this.func_149713_g(255);
            this.func_149647_a(null);
            this.field_149783_u = true;
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.tilled) {
            return TILLED_AABB;
        }
        return super.func_185496_a(state, source, pos);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)ModBlocks.fertilizedDirt, 1, 0);
    }

    public String func_149739_a() {
        return "tile.fertilizedDirt";
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185505_j;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.fertilizedDirt);
    }

    public boolean func_149662_c(IBlockState state) {
        return !this.tilled;
    }

    public boolean isFertile(World world, BlockPos pos) {
        return true;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177984_a());
        switch (plantType) {
            case Desert: {
                return !this.tilled;
            }
            case Nether: {
                return false;
            }
            case Crop: {
                return this.tilled;
            }
            case Cave: {
                return !this.tilled;
            }
            case Plains: {
                return !this.tilled;
            }
            case Water: {
                return false;
            }
            case Beach: {
                return !this.tilled;
            }
        }
        return false;
    }

    public void func_180650_b(World worldObj, BlockPos pos, IBlockState state, Random rand) {
        if (!worldObj.field_72995_K) {
            IBlockState plantState = worldObj.func_180495_p(pos.func_177984_a());
            Block toBoost = plantState.func_177230_c();
            if (plantState != null && toBoost != null && toBoost != Blocks.field_150350_a && toBoost instanceof IPlantable) {
                worldObj.func_175718_b(2005, pos.func_177984_a(), 0);
            }
            for (int i = 0; i < 3; ++i) {
                plantState = worldObj.func_180495_p(pos.func_177984_a());
                toBoost = plantState.func_177230_c();
                if (plantState == null || toBoost == null || toBoost == Blocks.field_150350_a || !(toBoost instanceof IPlantable)) continue;
                toBoost.func_180650_b(worldObj, pos.func_177984_a(), plantState, rand);
            }
        }
    }
}

