/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.IconArrivesEvent;
import mcjty.lib.gui.events.IconClickedEvent;
import mcjty.lib.gui.events.IconHolderClickedEvent;
import mcjty.lib.gui.events.IconHoverEvent;
import mcjty.lib.gui.events.IconLeavesEvent;
import mcjty.lib.gui.icons.IIcon;
import mcjty.lib.gui.icons.IconManager;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import org.lwjgl.input.Keyboard;

public class IconHolder
extends AbstractWidget<IconHolder> {
    private IIcon icon;
    private boolean makeCopy = false;
    private List<IconArrivesEvent> iconArrivesEvents = null;
    private List<IconLeavesEvent> iconLeavesEvents = null;
    private List<IconClickedEvent> iconClickedEvents = null;
    private List<IconHolderClickedEvent> iconHolderClickedEvents = null;
    private List<IconHoverEvent> iconHoverEvents = null;
    private boolean selectable = false;
    private int border = 0;
    private Integer borderColor = null;
    private Integer selectedBorderColor = -1;

    public IconHolder(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public IIcon getIcon() {
        return this.icon;
    }

    public boolean setIcon(IIcon icon) {
        if (this.fireIconArrived(icon)) {
            this.icon = icon;
            return true;
        }
        return false;
    }

    public int getBorder() {
        return this.border;
    }

    public IconHolder setBorder(int border) {
        this.border = border;
        return this;
    }

    public Integer getBorderColor() {
        return this.borderColor;
    }

    public IconHolder setBorderColor(Integer borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public Integer getSelectedBorderColor() {
        return this.selectedBorderColor;
    }

    public IconHolder setSelectedBorderColor(Integer selectedBorderColor) {
        this.selectedBorderColor = selectedBorderColor;
        return this;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public IconHolder setSelectable(boolean selectable) {
        this.selectable = selectable;
        return this;
    }

    public boolean isMakeCopy() {
        return this.makeCopy;
    }

    public IconHolder setMakeCopy(boolean makeCopy) {
        this.makeCopy = makeCopy;
        return this;
    }

    @Override
    public void mouseMove(int x, int y) {
        if (this.isEnabledAndVisible()) {
            int dx = x - this.bounds.x - this.border;
            int dy = y - this.bounds.y - this.border;
            this.fireIconHover(this.icon, dx, dy);
        }
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        if (this.isEnabledAndVisible() && !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            if (this.selectable) {
                window.setTextFocus(this);
            }
            int dx = x - this.bounds.x - this.border;
            int dy = y - this.bounds.y - this.border;
            this.fireIconHolderClicked(this.icon, dx, dy);
            if (this.icon != null && this.fireIconClicked(this.icon, dx, dy) && this.fireIconLeaves(this.icon)) {
                IconManager iconManager = window.getWindowManager().getIconManager();
                if (this.makeCopy) {
                    iconManager.startDragging(this.icon.clone(), this, dx, dy);
                } else {
                    iconManager.startDragging(this.icon, this, dx, dy);
                    this.icon = null;
                }
            }
        }
        return null;
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        super.draw(window, x, y);
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        if (!(this.border <= 0 || this.borderColor == null || this.selectable && window.getTextFocus() == this)) {
            RenderHelper.drawFlatBox(xx, yy, xx + this.bounds.width, yy + this.bounds.height, this.borderColor, -1);
        }
        if (this.icon != null) {
            this.icon.draw(this.mc, this.gui, xx + this.border, yy + this.border);
        }
    }

    @Override
    public void drawPhase2(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        super.drawPhase2(window, x, y);
        if (this.border > 0 && this.selectable && this.selectedBorderColor != null && window.getTextFocus() == this) {
            int xx = x + this.bounds.x;
            int yy = y + this.bounds.y;
            RenderHelper.drawFlatBox(xx, yy, xx + this.bounds.width, yy + this.bounds.height, this.selectedBorderColor, -1);
        }
    }

    public IconHolder addIconArrivesEvent(IconArrivesEvent event) {
        if (this.iconArrivesEvents == null) {
            this.iconArrivesEvents = new ArrayList<IconArrivesEvent>();
        }
        this.iconArrivesEvents.add(event);
        return this;
    }

    private boolean fireIconArrived(IIcon icon) {
        if (this.iconArrivesEvents != null) {
            for (IconArrivesEvent event : this.iconArrivesEvents) {
                boolean b = event.iconArrives(this, icon);
                if (b) continue;
                return false;
            }
        }
        return true;
    }

    public IconHolder addIconLeavesEvent(IconLeavesEvent event) {
        if (this.iconLeavesEvents == null) {
            this.iconLeavesEvents = new ArrayList<IconLeavesEvent>();
        }
        this.iconLeavesEvents.add(event);
        return this;
    }

    private boolean fireIconLeaves(IIcon icon) {
        if (this.iconLeavesEvents != null) {
            for (IconLeavesEvent event : this.iconLeavesEvents) {
                boolean b = event.iconLeaves(this, icon);
                if (b) continue;
                return false;
            }
        }
        return true;
    }

    public IconHolder addIconClickedEvent(IconClickedEvent event) {
        if (this.iconClickedEvents == null) {
            this.iconClickedEvents = new ArrayList<IconClickedEvent>();
        }
        this.iconClickedEvents.add(event);
        return this;
    }

    private boolean fireIconClicked(IIcon icon, int dx, int dy) {
        if (this.iconClickedEvents != null) {
            for (IconClickedEvent event : this.iconClickedEvents) {
                boolean b = event.iconClicked(this, icon, dx, dy);
                if (b) continue;
                return false;
            }
        }
        return true;
    }

    public IconHolder addIconHolderClickedEvent(IconHolderClickedEvent event) {
        if (this.iconHolderClickedEvents == null) {
            this.iconHolderClickedEvents = new ArrayList<IconHolderClickedEvent>();
        }
        this.iconHolderClickedEvents.add(event);
        return this;
    }

    private void fireIconHolderClicked(IIcon icon, int dx, int dy) {
        if (this.iconHolderClickedEvents != null) {
            for (IconHolderClickedEvent event : this.iconHolderClickedEvents) {
                event.holderClicked(this, icon, dx, dy);
            }
        }
    }

    public IconHolder addIconHoverEvent(IconHoverEvent event) {
        if (this.iconHoverEvents == null) {
            this.iconHoverEvents = new ArrayList<IconHoverEvent>();
        }
        this.iconHoverEvents.add(event);
        return this;
    }

    private void fireIconHover(IIcon icon, int dx, int dy) {
        if (this.iconHoverEvents != null) {
            for (IconHoverEvent event : this.iconHoverEvents) {
                event.hover(this, icon, dx, dy);
            }
        }
    }
}

