/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network;

import io.netty.buffer.ByteBuf;
import journeymap.client.feature.FeatureManager;
import journeymap.common.Journeymap;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.PermissionProperties;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DimensionPermissionPacket
implements IMessage {
    public static final String CHANNEL_NAME = "jm_dim_permission";
    private String prop;

    public DimensionPermissionPacket() {
    }

    public DimensionPermissionPacket(PermissionProperties prop) {
        this.prop = prop.toJsonString(false);
    }

    public String getProp() {
        return this.prop;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.prop = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message: %s", t));
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            if (this.prop != null) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.prop);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to read message: " + t);
        }
    }

    public static class Listener
    implements IMessageHandler<DimensionPermissionPacket, IMessage> {
        public IMessage onMessage(DimensionPermissionPacket message, MessageContext ctx) {
            PermissionProperties prop = (PermissionProperties)new DimensionProperties(0).load(message.getProp(), false);
            FeatureManager.instance().disableDimensionFeature(prop);
            Journeymap.getClient().setServerEnabled(true);
            return null;
        }
    }
}

