/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.cluster;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import jotato.quantumflux.blocks.TileBase;
import jotato.quantumflux.machines.cluster.QuibitClusterSettings;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileQuibitCluster
extends TileBase
implements IEnergyProvider,
IEnergyReceiver,
ITickable {
    protected EnergyStorage localEnergyStorage;
    private int transferRate;
    private int capacity;
    public int level;
    public int lastUsed;

    public TileQuibitCluster(QuibitClusterSettings settings) {
        this.transferRate = settings.transferRate;
        this.capacity = settings.capacity;
        this.level = settings.level;
        this.localEnergyStorage = new EnergyStorage(this.capacity, this.transferRate);
    }

    public TileQuibitCluster() {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.localEnergyStorage.writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
        tag.func_74768_a("XferRate", this.transferRate);
        tag.func_74768_a("Capacity", this.capacity);
        tag.func_74768_a("Level", this.level);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.level = tag.func_74762_e("Level");
        this.capacity = tag.func_74762_e("Capacity");
        this.transferRate = tag.func_74762_e("XferRate");
        if (this.localEnergyStorage == null) {
            this.localEnergyStorage = new EnergyStorage(this.capacity, this.transferRate);
        }
        NBTTagCompound energyTag = tag.func_74775_l("Energy");
        this.localEnergyStorage.readFromNBT(energyTag);
    }

    @SideOnly(value=Side.CLIENT)
    public int getBufferScaled(int scale) {
        double stored = this.getEnergyStored(null);
        double max = this.getMaxEnergyStored(null);
        double v = stored / max * (double)scale;
        return (int)v;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (EnumFacing dir : EnumFacing.values()) {
            IEnergyReceiver receiver;
            BlockPos targetBlock = this.func_174877_v().func_177971_a(dir.func_176730_m());
            TileEntity tile = this.field_145850_b.func_175625_s(targetBlock);
            if (tile instanceof TileQuibitCluster) {
                return;
            }
            if (!(tile instanceof IEnergyReceiver) || !(receiver = (IEnergyReceiver)tile).canConnectEnergy(dir.func_176734_d())) continue;
            int tosend = this.localEnergyStorage.extractEnergy(this.transferRate, true);
            int used = receiver.receiveEnergy(dir.func_176734_d(), tosend, false);
            if (used > 0) {
                this.func_70296_d();
            }
            this.lastUsed = used;
            this.localEnergyStorage.extractEnergy(used, false);
        }
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int used = this.localEnergyStorage.receiveEnergy(maxReceive, simulate);
        if (used > 0 && !simulate) {
            this.func_70296_d();
        }
        return used;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        int given = this.localEnergyStorage.extractEnergy(maxExtract, simulate);
        if (given > 0 && !simulate) {
            this.func_70296_d();
        }
        return given;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.localEnergyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.localEnergyStorage.getMaxEnergyStored();
    }
}

