/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.chunkloading;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.mojang.authlib.GameProfile;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.chunkloading.ChunkLoaderLoginTimes;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.tile.TileChunkLoader;
import com.rwtema.extrautils2.utils.helpers.DescribeHelper;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import gnu.trove.list.array.TIntArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class XUChunkLoaderManager
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    public static final HashMultimap<World, TileChunkLoader> chunkLoaders = HashMultimap.create();
    public static XUChunkLoaderManager instance = new XUChunkLoaderManager();
    public static boolean dirty = false;
    private static WeakHashMap<World, Void> worldsLoaded = new WeakHashMap();
    private static HashMap<World, HashMap<GameProfile, ForgeChunkManager.Ticket>> playerTickets = new HashMap();

    public static void init() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)ExtraUtils2.instance, (ForgeChunkManager.LoadingCallback)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(TileChunkLoader loader) {
        HashMultimap<World, TileChunkLoader> hashMultimap = chunkLoaders;
        synchronized (hashMultimap) {
            ForgeChunkManager.Ticket playerTicket;
            GameProfile profile = loader.getProfile();
            World world = loader.world();
            if (profile != null && ForgeChunkManager.getPersistentChunksFor((World)world) != ImmutableSetMultimap.of() && (playerTicket = instance.getPlayerTicket(profile, world)) != null) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)playerTicket, (ChunkPos)new ChunkPos(loader.func_174877_v().func_177958_n() >> 4, loader.func_174877_v().func_177952_p() >> 4));
            }
            chunkLoaders.put((Object)world, (Object)loader);
            dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(TileChunkLoader loader) {
        HashMultimap<World, TileChunkLoader> hashMultimap = chunkLoaders;
        synchronized (hashMultimap) {
            chunkLoaders.remove((Object)loader.world(), (Object)loader);
            dirty = true;
        }
    }

    public static void clear() {
        chunkLoaders.clear();
        playerTickets.clear();
        ChunkLoaderLoginTimes.instance.loaded = false;
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (dirty) {
            this.reloadChunkLoaders();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void worldLoad(WorldEvent.Load event) {
        if (!worldsLoaded.containsKey(event.getWorld())) {
            worldsLoaded.put(event.getWorld(), null);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void worldLoad(WorldEvent.Unload event) {
        if (!worldsLoaded.containsKey(event.getWorld())) {
            worldsLoaded.remove(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        playerTickets.remove(event.getWorld());
        chunkLoaders.removeAll((Object)event.getWorld());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadChunkLoaders() {
        HashMultimap<World, TileChunkLoader> hashMultimap = chunkLoaders;
        synchronized (hashMultimap) {
            dirty = false;
            HashMultimap worldChunks = HashMultimap.create();
            HashMultimap toUnload = HashMultimap.create();
            HashMultimap loaded = HashMultimap.create();
            HashMultimap toAdd = HashMultimap.create();
            for (HashMap<GameProfile, ForgeChunkManager.Ticket> map : playerTickets.values()) {
                for (ForgeChunkManager.Ticket ticket : map.values()) {
                    ImmutableSet chunkList = ticket.getChunkList();
                    for (ChunkPos pair : chunkList) {
                        ticket.world.func_180495_p(CompatHelper.getCenterBlock(pair, 20));
                    }
                    worldChunks.putAll((Object)ticket.world, (Iterable)chunkList);
                    toUnload.putAll((Object)ticket, (Iterable)chunkList);
                    loaded.putAll((Object)ticket, (Iterable)chunkList);
                }
            }
            Iterator iterator = chunkLoaders.values().iterator();
            while (iterator.hasNext()) {
                ForgeChunkManager.Ticket ticket;
                TileChunkLoader chunkLoader = (TileChunkLoader)iterator.next();
                if (chunkLoader.func_145837_r()) {
                    dirty = true;
                    iterator.remove();
                }
                if (!chunkLoader.isLoaded()) {
                    dirty = true;
                    continue;
                }
                World world = chunkLoader.world();
                if (world == null || DimensionManager.getWorld((int)world.field_73011_w.getDimension()) != world || !worldsLoaded.containsKey(world)) {
                    dirty = true;
                    continue;
                }
                GameProfile profile = chunkLoader.getProfile();
                if (!chunkLoader.active || profile == null || !ChunkLoaderLoginTimes.instance.isValid(profile) || (ticket = this.getPlayerTicket(profile, world)) == null) continue;
                for (ChunkPos coordIntPair : chunkLoader.getChunkCoords()) {
                    worldChunks.remove((Object)world, (Object)coordIntPair);
                    toUnload.remove((Object)ticket, (Object)coordIntPair);
                    if (loaded.containsEntry((Object)ticket, (Object)coordIntPair)) continue;
                    toAdd.put((Object)ticket, (Object)coordIntPair);
                }
            }
            for (HashMap<GameProfile, ForgeChunkManager.Ticket> map : playerTickets.values()) {
                Iterator<ForgeChunkManager.Ticket> iterator2 = map.values().iterator();
                while (iterator2.hasNext()) {
                    ForgeChunkManager.Ticket ticket;
                    ticket = iterator2.next();
                    for (ChunkPos pair : toUnload.get((Object)ticket)) {
                        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pair);
                    }
                    for (ChunkPos pair : toAdd.get((Object)ticket)) {
                        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pair);
                    }
                    if (ticket.getChunkList().isEmpty()) {
                        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                        iterator2.remove();
                        continue;
                    }
                    TIntArrayList x = new TIntArrayList();
                    TIntArrayList z = new TIntArrayList();
                    for (ChunkPos ChunkPos2 : ticket.getChunkList()) {
                        x.add(ChunkPos2.field_77276_a);
                        z.add(ChunkPos2.field_77275_b);
                    }
                    ticket.getModData().func_74783_a("x", x.toArray());
                    ticket.getModData().func_74783_a("z", z.toArray());
                }
            }
        }
    }

    public ForgeChunkManager.Ticket getPlayerTicket(GameProfile profile, World world) {
        HashMap gameProfileTicketHashMap = playerTickets.computeIfAbsent(world, k -> new HashMap());
        ForgeChunkManager.Ticket ticket = (ForgeChunkManager.Ticket)gameProfileTicketHashMap.get(profile);
        if (ticket == null) {
            ticket = ForgeChunkManager.requestPlayerTicket((Object)ExtraUtils2.instance, (String)profile.getName(), (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            NBTTagCompound tag = ticket.getModData();
            tag.func_74778_a("Name", profile.getName());
            UUID id = profile.getId();
            if (id != null) {
                tag.func_74772_a("UUIDL", id.getLeastSignificantBits());
                tag.func_74772_a("UUIDU", id.getMostSignificantBits());
            }
            gameProfileTicketHashMap.put(profile, ticket);
        }
        return ticket;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        dirty = true;
        HashMap<GameProfile, ForgeChunkManager.Ticket> cache = new HashMap<GameProfile, ForgeChunkManager.Ticket>();
        playerTickets.put(world, cache);
        for (ForgeChunkManager.Ticket ticket : tickets) {
            int[] z;
            NBTTagCompound modData = ticket.getModData();
            GameProfile profile = NBTHelper.profileFromNBT(modData);
            cache.put(profile, ticket);
            int[] x = modData.func_74759_k("x");
            if (x.length != (z = modData.func_74759_k("z")).length) continue;
            for (int i = 0; i < x.length; ++i) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(x[i], z[i]));
                Chunk chunk = world.func_72964_e(x[i], z[i]);
            }
        }
    }

    public void getDebug(List<String> info) {
        DescribeHelper.addDescription(info, "Chunk Loaders", chunkLoaders);
        DescribeHelper.addDescription(info, "Player Tickets", playerTickets);
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return tickets;
    }
}

