/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.CapabilityState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities.CapabilitiesSupportedListEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehServerMessageException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.CommandFilter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.event.ClearChatEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.event.GlobalUserStateEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.event.RoomStateEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.event.UserNoticeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.event.UserStateEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Badges;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.BanDuration;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.BanReason;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Bits;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.BroadcasterLang;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Color;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.DisplayName;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.EmoteSets;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Emotes;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Id;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Mod;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.MsgId;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.MsgParamMonths;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.MsgParamSubPlan;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.MsgParamSubPlanName;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.R9k;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.RoomId;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Slow;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.SubsOnly;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Subscriber;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.SystemMsg;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Turbo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.UserId;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.UserType;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;

public class TwitchListener {
    public static final String CAPABILITY_COMMANDS = "twitch.tv/commands";
    public static final String CAPABILITY_MEMBERSHIP = "twitch.tv/membership";
    public static final String CAPABILITY_TAGS = "twitch.tv/tags";
    private final Client client;

    public TwitchListener(@Nonnull Client client) {
        this.client = Sanity.nullCheck(client, "Client cannot be null");
        ((Client.WithManagement)client).getActorTracker().setQueryChannelInformation(false);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "badges", Badges.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "ban-duration", BanDuration.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "ban-reason", BanReason.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "bits", Bits.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "broadcaster-lang", BroadcasterLang.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "color", Color.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "display-name", DisplayName.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "emotes", Emotes.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "emote-sets", EmoteSets.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "id", Id.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "msg-id", MsgId.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "msg-param-months", MsgParamMonths.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "msg-param-sub-plan", MsgParamSubPlan.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "msg-param-sub-plan-name", MsgParamSubPlanName.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "mod", Mod.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "r9k", R9k.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "room-id", RoomId.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "slow", Slow.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "subs-only", SubsOnly.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "subscriber", Subscriber.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "system-msg", SystemMsg.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "turbo", Turbo.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "user", User.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "user-id", UserId.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "user-type", UserType.FUNCTION);
    }

    @Handler
    public void capList(@Nonnull CapabilitiesSupportedListEvent event) {
        List already = this.client.getCapabilityManager().getCapabilities().stream().map(CapabilityState::getName).collect(Collectors.toList());
        if (!already.contains(CAPABILITY_COMMANDS)) {
            event.addRequest(CAPABILITY_COMMANDS);
        }
        if (!already.contains(CAPABILITY_MEMBERSHIP)) {
            event.addRequest(CAPABILITY_MEMBERSHIP);
        }
        if (!already.contains(CAPABILITY_TAGS)) {
            event.addRequest(CAPABILITY_TAGS);
        }
    }

    @CommandFilter(value="CLEARCHAT")
    @Handler(priority=0x7FFFFFFD)
    public void clearChat(ClientReceiveCommandEvent event) {
        this.client.getEventManager().callEvent(new ClearChatEvent(this.client, event.getOriginalMessages(), this.getChannel(event)));
    }

    @CommandFilter(value="GLOBALUSERSTATE")
    @Handler(priority=0x7FFFFFFD)
    public void globalUserState(ClientReceiveCommandEvent event) {
        this.client.getEventManager().callEvent(new GlobalUserStateEvent(this.client, event.getOriginalMessages()));
    }

    @CommandFilter(value="ROOMSTATE")
    @Handler(priority=0x7FFFFFFD)
    public void roomState(ClientReceiveCommandEvent event) {
        this.client.getEventManager().callEvent(new RoomStateEvent(this.client, event.getOriginalMessages(), this.getChannel(event)));
    }

    @CommandFilter(value="USERNOTICE")
    @Handler(priority=0x7FFFFFFD)
    public void userNotice(ClientReceiveCommandEvent event) {
        String message = null;
        if (event.getParameters().size() > 1) {
            message = event.getParameters().get(1);
        }
        this.client.getEventManager().callEvent(new UserNoticeEvent(this.client, event.getOriginalMessages(), this.getChannel(event), message));
    }

    @CommandFilter(value="USERSTATE")
    @Handler(priority=0x7FFFFFFD)
    public void userState(ClientReceiveCommandEvent event) {
        this.client.getEventManager().callEvent(new UserStateEvent(this.client, event.getOriginalMessages(), this.getChannel(event)));
    }

    @Nonnull
    private Channel getChannel(ClientReceiveCommandEvent event) {
        Optional<Channel> channel = this.client.getChannel(event.getParameters().get(0));
        if (!channel.isPresent()) {
            throw new KittehServerMessageException(event.getServerMessage(), "Invalid channel name");
        }
        return channel.get();
    }
}

