/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.block.BlockCapabilities;
import org.cyclops.cyclopscore.datastructure.DimPos;

public final class BlockHelpers {
    public static <T extends Comparable<T>> T getSafeBlockStateProperty(@Nullable IBlockState state, IProperty<T> property, T fallback) {
        Comparable value;
        if (state == null) {
            return fallback;
        }
        try {
            value = state.func_177229_b(property);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
        if (value == null) {
            return fallback;
        }
        return (T)value;
    }

    public static <T> T getSafeBlockStateProperty(@Nullable IExtendedBlockState state, IUnlistedProperty<T> property, T fallback) {
        Object value;
        if (state == null) {
            return fallback;
        }
        try {
            value = state.getValue(property);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
        if (value == null) {
            return fallback;
        }
        return (T)value;
    }

    public static Pair<String, Integer> serializeBlockState(IBlockState blockState) {
        String blockName = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)blockState.func_177230_c())).toString();
        int meta = blockState.func_177230_c().func_176201_c(blockState);
        return Pair.of((Object)blockName, (Object)meta);
    }

    public static IBlockState deserializeBlockState(Pair<String, Integer> serializedBlockState) {
        Block block = Block.func_149684_b((String)((String)serializedBlockState.getLeft()));
        if (block != null) {
            return block.func_176203_a(((Integer)serializedBlockState.getRight()).intValue());
        }
        return null;
    }

    public static IBlockState getBlockStateFromItemStack(ItemStack itemStack) {
        Block block = ((ItemBlock)itemStack.func_77973_b()).func_179223_d();
        return block.func_176203_a(itemStack.func_77960_j());
    }

    public static ItemStack getItemStackFromBlockState(IBlockState blockState) {
        Item item = Item.func_150898_a((Block)blockState.func_177230_c());
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item, 1, item.func_77614_k() ? blockState.func_177230_c().func_180651_a(blockState) : 0);
    }

    public static void markForUpdate(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        world.func_184138_a(pos, blockState, blockState, 3);
    }

    public static void addCollisionBoxToList(BlockPos pos, AxisAlignedBB collidingBox, List<AxisAlignedBB> collisions, AxisAlignedBB addingBox) {
        AxisAlignedBB axisalignedbb;
        if (addingBox != null && collidingBox.func_72326_a(axisalignedbb = addingBox.func_186670_a(pos))) {
            collisions.add(axisalignedbb);
        }
    }

    public static boolean doesBlockHaveSolidTopSurface(IBlockAccess world, BlockPos blockPos) {
        return world.func_180495_p(blockPos.func_177982_a(0, -1, 0)).func_185914_p();
    }

    public static boolean isValidCreativeTab(Block block, @Nullable CreativeTabs creativeTab) {
        return creativeTab == null || creativeTab == CreativeTabs.field_78027_g || block.func_149708_J() == creativeTab;
    }

    @Optional.Method(modid="commoncapabilities")
    public static <C> C getCapability(DimPos dimPos, Capability<C> capability) {
        World world = dimPos.getWorld();
        if (world == null) {
            return null;
        }
        return BlockHelpers.getCapability(world, dimPos.getBlockPos(), null, capability);
    }

    @Optional.Method(modid="commoncapabilities")
    public static <C> C getCapability(DimPos dimPos, EnumFacing side, Capability<C> capability) {
        World world = dimPos.getWorld();
        if (world == null) {
            return null;
        }
        return BlockHelpers.getCapability(world, dimPos.getBlockPos(), side, capability);
    }

    @Optional.Method(modid="commoncapabilities")
    public static <C> C getCapability(World world, BlockPos pos, EnumFacing side, Capability<C> capability) {
        return BlockHelpers.getCapability((IBlockAccess)world, pos, side, capability);
    }

    @Optional.Method(modid="commoncapabilities")
    public static <C> C getCapability(IBlockAccess world, BlockPos pos, Capability<C> capability) {
        return BlockHelpers.getCapability(world, pos, null, capability);
    }

    @Optional.Method(modid="commoncapabilities")
    public static <C> C getCapability(IBlockAccess world, BlockPos pos, EnumFacing side, Capability<C> capability) {
        IBlockState blockState = world.func_180495_p(pos);
        if (BlockCapabilities.getInstance().hasCapability(blockState, capability, world, pos, side)) {
            return (C)BlockCapabilities.getInstance().getCapability(blockState, capability, world, pos, side);
        }
        return null;
    }
}

