/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entities;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingSprite;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectBootes;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.item.wearable.ItemCape;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.util.DamageUtil;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFlare
extends EntityFlying {
    private static final int strollRange = 31;
    public Object texSprite = null;
    private BlockPos moveTarget = null;
    private boolean isAmbient = false;
    private int entityAge = 0;
    private int followingEntityId = -1;

    public EntityFlare(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.7f);
    }

    public EntityFlare(World worldIn, double x, double y, double z) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.7f);
        this.func_70080_a(x, y, z, 0.0f, 0.0f);
    }

    public EntityFlare setAmbient(boolean ambient) {
        this.isAmbient = ambient;
        return this;
    }

    public EntityFlare setFollowingTarget(EntityPlayer player) {
        this.followingEntityId = player.func_145782_y();
        return this;
    }

    public static void spawnAmbient(World world, Vector3 at) {
        if (world.field_72995_K) {
            return;
        }
        if (Config.ambientFlareChance <= 0) {
            return;
        }
        float nightPerc = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(world);
        if (world.field_73012_v.nextInt(Config.ambientFlareChance) == 0 && world.func_175623_d(at.toBlockPos()) && world.field_73012_v.nextFloat() < nightPerc) {
            world.func_72838_d((Entity)new EntityFlare(world, at.getX(), at.getY(), at.getZ()).setAmbient(true));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected void func_184651_r() {
        super.func_184651_r();
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn != null && entityIn instanceof EntityFlare) {
            super.func_70108_f(entityIn);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn != null && entityIn instanceof EntityFlare) {
            super.func_82167_n(entityIn);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.entityAge;
        if (this.field_70170_p.field_72995_K) {
            if (this.texSprite == null) {
                this.setupSprite();
            }
            this.clientUpdate();
        } else {
            if (this.followingEntityId != -1) {
                if (this.getFollowingEntity() == null) {
                    this.func_70665_d(DamageSource.field_76376_m, 20.0f);
                }
            } else if (this.entityAge > 300 && this.field_70146_Z.nextInt(700) == 0) {
                this.func_70665_d(DamageSource.field_76376_m, 20.0f);
            }
            if (!this.field_70128_L) {
                Entity closest;
                if (Config.flareKillsBats && this.entityAge % 70 == 0 && this.field_70146_Z.nextBoolean() && (closest = this.field_70170_p.func_72857_a(EntityBat.class, this.func_174813_aQ().func_186662_g(10.0), (Entity)this)) != null && closest instanceof EntityBat && ((EntityBat)closest).func_110143_aJ() > 0.0f && !closest.field_70128_L) {
                    DamageUtil.attackEntityFrom(closest, CommonProxy.dmgSourceStellar, 40.0f);
                    PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.FLARE_PROC, new Vector3(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v));
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(this.field_70170_p, (Vec3i)this.func_180425_c(), 16.0));
                    AstralSorcery.proxy.fireLightning(this.field_70170_p, Vector3.atEntityCenter((Entity)this), Vector3.atEntityCenter(closest), new Color(0, 0, 216));
                }
                if (this.isAmbient) {
                    if ((this.moveTarget == null || this.func_174818_b(this.moveTarget) < 5.0) && this.field_70146_Z.nextInt(260) == 0) {
                        this.moveTarget = this.func_180425_c().func_177982_a(-15, -15, -15).func_177982_a(this.field_70146_Z.nextInt(31), this.field_70146_Z.nextInt(31), this.field_70146_Z.nextInt(31));
                    }
                    if (this.moveTarget != null && (this.moveTarget.func_177956_o() <= 1 || !this.field_70170_p.func_175623_d(this.moveTarget) || this.func_174818_b(this.moveTarget) < 5.0)) {
                        this.moveTarget = null;
                    }
                } else if (this.followingEntityId != -1) {
                    if (this.getFollowingEntity() != null) {
                        EntityPlayer e = this.getFollowingEntity();
                        CapeEffectBootes cb = (CapeEffectBootes)ItemCape.getCapeEffect(e, Constellations.bootes);
                        if (cb == null) {
                            this.followingEntityId = -1;
                            return;
                        }
                        if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
                            this.func_70624_b(null);
                        }
                        if (this.func_70638_az() == null) {
                            this.moveTarget = Vector3.atEntityCenter((Entity)this.getFollowingEntity()).addY(-1.0 + (double)this.field_70146_Z.nextFloat() * 2.5).toBlockPos();
                        }
                    }
                } else if (this.func_70638_az() != null) {
                    if (this.func_70638_az().field_70128_L) {
                        if (this.field_70146_Z.nextInt(30) == 0) {
                            this.func_70665_d(DamageSource.field_76376_m, 20.0f);
                        }
                    } else {
                        this.moveTarget = Vector3.atEntityCenter((Entity)this.func_70638_az()).toBlockPos();
                    }
                    if (this.moveTarget != null && (this.moveTarget.func_177956_o() <= 1 || this.func_174818_b(this.moveTarget) < 3.0)) {
                        this.moveTarget = null;
                    }
                }
                if (this.func_70638_az() != null && !this.func_70638_az().field_70128_L && this.func_70638_az().func_70032_d((Entity)this) < 10.0f && this.field_70146_Z.nextInt(40) == 0) {
                    DamageUtil.attackEntityFrom((Entity)this.func_70638_az(), CommonProxy.dmgSourceStellar, 5.5f);
                    PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.FLARE_PROC, new Vector3(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v));
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(this.field_70170_p, (Vec3i)this.func_180425_c(), 16.0));
                    AstralSorcery.proxy.fireLightning(this.field_70170_p, Vector3.atEntityCenter((Entity)this), Vector3.atEntityCenter((Entity)this.func_70638_az()), new Color(0, 0, 216));
                }
                if (this.moveTarget != null) {
                    this.field_70159_w += (Math.signum((double)this.moveTarget.func_177958_n() + 0.5 - this.field_70165_t) * 0.5 - this.field_70159_w) * (this.isAmbient ? 0.01 : 0.02);
                    this.field_70181_x += (Math.signum((double)this.moveTarget.func_177956_o() + 0.5 - this.field_70163_u) * 0.7 - this.field_70181_x) * (this.isAmbient ? 0.01 : 0.02);
                    this.field_70179_y += (Math.signum((double)this.moveTarget.func_177952_p() + 0.5 - this.field_70161_v) * 0.5 - this.field_70179_y) * (this.isAmbient ? 0.01 : 0.02);
                    this.field_191988_bg = 0.2f;
                }
            }
        }
    }

    @Nullable
    public EntityPlayer getFollowingEntity() {
        Entity e = this.field_70170_p.func_73045_a(this.followingEntityId);
        if (e == null || e.field_70128_L || !(e instanceof EntityPlayer)) {
            return null;
        }
        return (EntityPlayer)e;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70601_bi() {
        return false;
    }

    public AxisAlignedBB func_184177_bl() {
        return super.func_184177_bl();
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        super.func_70665_d(damageSrc, damageAmount);
        this.func_70606_j(0.0f);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected void func_70609_aI() {
        this.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            this.deathEffectsEnd();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("as_entityAge", this.entityAge);
        compound.func_74757_a("isSpawnedAmbient", this.isAmbient);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.entityAge = compound.func_74762_e("as_entityAge");
        this.isAmbient = compound.func_74767_n("isSpawnedAmbient");
    }

    @SideOnly(value=Side.CLIENT)
    private void deathEffectsEnd() {
        EntityFXFacingParticle particle;
        int i;
        EntityFXFacingSprite p = (EntityFXFacingSprite)this.texSprite;
        if (p != null) {
            p.requestRemoval();
        }
        for (i = 0; i < 29; ++i) {
            particle = EffectHelper.genericFlareParticle(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v);
            particle.motion(-0.1 + (double)this.field_70146_Z.nextFloat() * 0.2, -0.1 + (double)this.field_70146_Z.nextFloat() * 0.2, -0.1 + (double)this.field_70146_Z.nextFloat() * 0.2);
            particle.scale(0.1f + this.field_70146_Z.nextFloat() * 0.2f).gravity(-0.02);
            if (!this.field_70146_Z.nextBoolean()) continue;
            particle.setColor(Color.WHITE);
        }
        for (i = 0; i < 35; ++i) {
            particle = EffectHelper.genericFlareParticle(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            particle.offset(-0.2 + (double)this.field_70146_Z.nextFloat() * 0.4, (double)(this.field_70131_O / 2.0f) - 0.2 + (double)this.field_70146_Z.nextFloat() * 0.4, -0.2 + (double)this.field_70146_Z.nextFloat() * 0.4);
            particle.scale(0.1f + this.field_70146_Z.nextFloat() * 0.2f).gravity(0.004);
            if (!this.field_70146_Z.nextBoolean()) continue;
            particle.setColor(Color.WHITE);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void clientUpdate() {
        EntityFXFacingSprite p = (EntityFXFacingSprite)this.texSprite;
        if (p.isRemoved()) {
            EffectHandler.getInstance().registerFX(p);
        }
        if (this.field_70146_Z.nextBoolean()) {
            EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            particle.offset(-0.3 + (double)this.field_70146_Z.nextFloat() * 0.6, (double)(this.field_70131_O / 2.0f) - 0.3 + (double)this.field_70146_Z.nextFloat() * 0.6, -0.3 + (double)this.field_70146_Z.nextFloat() * 0.6);
            particle.scale(0.1f + this.field_70146_Z.nextFloat() * 0.2f).gravity(-0.02);
            if (this.field_70146_Z.nextBoolean()) {
                particle.setColor(Color.WHITE);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void setupSprite() {
        EntityFXFacingSprite p = EntityFXFacingSprite.fromSpriteSheet(SpriteLibrary.spriteFlare1, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.8f, 2);
        p.setPositionUpdateFunction((fx, v, m) -> Vector3.atEntityCenter((Entity)this));
        p.setRefreshFunc(() -> !this.field_70128_L);
        EffectHandler.getInstance().registerFX(p);
        this.texSprite = p;
    }

    @SideOnly(value=Side.CLIENT)
    public static void playParticles(PktParticleEvent pktParticleEvent) {
        Random rand = new Random();
        Vector3 at = pktParticleEvent.getVec();
        for (int i = 0; i < 17; ++i) {
            EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
            particle.motion(-0.05 + (double)rand.nextFloat() * 0.1, -0.05 + (double)rand.nextFloat() * 0.1, -0.05 + (double)rand.nextFloat() * 0.1);
            particle.scale(0.1f + rand.nextFloat() * 0.2f).gravity(-0.02);
            if (!rand.nextBoolean()) continue;
            particle.setColor(Color.WHITE);
        }
    }
}

