/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.key;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.KeyPerk;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.structure.array.BlockArray;
import hellfirepvp.astralsorcery.common.util.BlockDropCaptureAssist;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.struct.BlockDiscoverer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class KeyChainMining
extends KeyPerk {
    private float chainChance = 0.2f;
    private int chainLength = 4;
    private static boolean chainOngoing = false;

    public KeyChainMining(String name, int x, int y) {
        super(name, x, y);
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.PERKS, name){

            @Override
            public void loadFromConfig(Configuration cfg) {
                KeyChainMining.this.chainLength = cfg.getInt("ChainLength", this.getConfigurationSection(), KeyChainMining.this.chainLength, 2, 20, "Defines the maximum length of a single break-chain.");
                KeyChainMining.this.chainChance = cfg.getFloat("ChainChance", this.getConfigurationSection(), KeyChainMining.this.chainChance, 0.01f, 1.0f, "Defines the base chance a chain is tried to be built.");
            }
        });
    }

    @Override
    protected void applyEffectMultiplier(double multiplier) {
        super.applyEffectMultiplier(multiplier);
        this.chainChance = (float)((double)this.chainChance * multiplier);
        this.chainLength = MathHelper.func_76143_f((double)((double)this.chainLength * multiplier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        Side side = player.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER;
        PlayerProgress prog = ResearchManager.getProgress(player, side);
        if (side == Side.SERVER && player instanceof EntityPlayerMP && prog.hasPerkEffect(this) && !MiscUtils.isPlayerFakeMP((EntityPlayerMP)player) && !player.func_70093_af() && event.getWorld() instanceof WorldServer && !player.func_184812_l_()) {
            if (chainOngoing) {
                return;
            }
            chainOngoing = true;
            try {
                WorldServer world = (WorldServer)event.getWorld();
                if (this.doMiningChain(world, event.getPos(), event.getState(), player, side)) {
                    float doubleChance = PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, "astralsorcery.chainchancing");
                    if (rand.nextFloat() < doubleChance) {
                        while (this.doMiningChain(world, event.getPos(), event.getState(), player, side)) {
                        }
                    }
                }
            }
            finally {
                chainOngoing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doMiningChain(WorldServer world, BlockPos pos, IBlockState state, EntityPlayer player, Side side) {
        PlayerProgress prog = ResearchManager.getProgress(player, side);
        float ch = this.chainChance;
        ch = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, "astralsorcery.chainchance", ch);
        if (rand.nextFloat() < ch) {
            float fLength = this.chainLength;
            fLength = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, "astralsorcery.chainlength", fLength);
            BlockArray chain = BlockDiscoverer.discoverBlocksWithSameStateAroundChain((World)world, pos, state, Math.round(fLength), null, (world1, pos1, state1) -> pos1.func_177956_o() >= player.func_180425_c().func_177956_o() && state1.func_185887_b(world1, pos1) >= 0.0f && world1.func_175625_s(pos1) == null && !world1.func_175623_d(pos1) && state1.func_177230_c().canHarvestBlock((IBlockAccess)world1, pos1, player));
            if (!chain.isEmpty()) {
                int broken = 0;
                FakePlayer fp = AstralSorcery.proxy.getASFakePlayerServer(world);
                for (BlockPos at : chain.getPattern().keySet()) {
                    int exp;
                    IBlockState atState = world.func_180495_p(at);
                    try {
                        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent((World)world, pos, atState, (EntityPlayer)fp);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        exp = event.getExpToDrop();
                        if (event.isCanceled()) {
                            return false;
                        }
                    }
                    catch (Exception exc) {
                        return false;
                    }
                    boolean capturing = false;
                    try {
                        BlockDropCaptureAssist.startCapturing();
                        capturing = true;
                        TileEntity te = world.func_175625_s(at);
                        Block block = atState.func_177230_c();
                        if (block.removedByPlayer(atState, (World)world, at, player, true)) {
                            block.func_176206_d((World)world, at, atState);
                            block.func_180657_a((World)world, player, at, atState, te, player.func_184614_ca());
                            if (exp > 0) {
                                block.func_180637_b((World)world, at, exp);
                            }
                            PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.ARCHITECT_PLACE, (Vec3i)at);
                            ev.setAdditionalDataLong(Block.func_176210_f((IBlockState)atState));
                            PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos((World)world, (Vec3i)at, 16.0));
                            ++broken;
                        }
                        NonNullList<ItemStack> drops = BlockDropCaptureAssist.getCapturedStacksAndStop();
                        capturing = false;
                        Vector3 plPos = Vector3.atEntityCenter((Entity)player);
                        for (ItemStack stack : drops) {
                            if (player.func_191521_c(stack)) continue;
                            ItemUtils.dropItemNaturally(player.func_130014_f_(), plPos.getX() + (double)rand.nextFloat() - (double)rand.nextFloat(), player.field_70163_u, plPos.getZ() + (double)rand.nextFloat() - (double)rand.nextFloat(), stack);
                        }
                    }
                    catch (Exception exception) {}
                    continue;
                    finally {
                        if (!capturing) continue;
                        BlockDropCaptureAssist.getCapturedStacksAndStop();
                    }
                }
                return broken >= chain.getPattern().size() / 2;
            }
        }
        return false;
    }
}

