/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.module;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import elec332.core.api.module.ElecModule;
import elec332.core.api.module.IModuleContainer;
import elec332.core.api.module.IModuleController;
import elec332.core.api.module.IModuleInfo;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;

public class DefaultWrappedModule
implements IModuleContainer {
    private final String name;
    private final String owner;
    private final String clazz;
    private final ResourceLocation comName;
    private final boolean depB;
    private final boolean alwaysEnabled;
    private final Object module;
    private final List<String> moduleDependencies;
    private final List<ArtifactVersion> modDependencies;
    private final IModuleController moduleController;
    private final ModContainer mod;

    public DefaultWrappedModule(Object o, IModuleInfo moduleInfo) {
        this.module = o;
        this.name = moduleInfo.getName();
        this.owner = moduleInfo.getOwner();
        this.comName = new ResourceLocation(moduleInfo.getCombinedName().toString().toLowerCase());
        this.depB = moduleInfo.autoDisableIfRequirementsNotMet();
        this.moduleDependencies = ImmutableList.copyOf(moduleInfo.getModuleDependencies());
        this.modDependencies = ImmutableList.copyOf(moduleInfo.getModDependencies());
        this.clazz = moduleInfo.getModuleClass();
        this.alwaysEnabled = moduleInfo.alwaysEnabled();
        this.moduleController = moduleInfo.getModuleController();
        ModContainer mc = null;
        for (ModContainer m : Loader.instance().getActiveModList()) {
            if (!m.getModId().equals(this.owner)) continue;
            mc = m;
            break;
        }
        this.mod = (ModContainer)Preconditions.checkNotNull(mc);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public ResourceLocation getCombinedName() {
        return this.comName;
    }

    @Override
    public boolean autoDisableIfRequirementsNotMet() {
        return this.depB;
    }

    @Override
    @Nonnull
    public Object getModule() {
        return this.module;
    }

    @Override
    @Nonnull
    public ModContainer getOwnerMod() {
        return this.mod;
    }

    @Override
    public void invokeEvent(Object event) throws Exception {
        Class<?> objClass = this.module.getClass();
        for (Method method : objClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ElecModule.EventHandler.class) && !method.isAnnotationPresent(Mod.EventHandler.class) || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(event.getClass())) continue;
            method.invoke(this.module, event);
        }
    }

    @Override
    @Nonnull
    public List<ArtifactVersion> getModDependencies() {
        return this.modDependencies;
    }

    @Override
    @Nonnull
    public List<String> getModuleDependencies() {
        return this.moduleDependencies;
    }

    @Override
    @Nonnull
    public String getModuleClass() {
        return this.clazz;
    }

    @Override
    public boolean alwaysEnabled() {
        return this.alwaysEnabled;
    }

    @Override
    @Nonnull
    public IModuleController getModuleController() {
        return this.moduleController;
    }
}

