/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.loader;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import elec332.core.ElecCore;
import elec332.core.api.APIHandlerInject;
import elec332.core.api.IAPIHandler;
import elec332.core.api.discovery.IASMDataHelper;
import elec332.core.api.module.IModuleContainer;
import elec332.core.api.module.IModuleController;
import elec332.core.api.module.IModuleInfo;
import elec332.core.api.module.IModuleManager;
import elec332.core.module.DefaultWrappedModule;
import elec332.core.util.FMLUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;

enum ModuleManager implements IModuleManager
{
    INSTANCE;

    private static final IModuleController DEFAULT_CONTROLLER;
    private static final BiFunction<Object, IModuleInfo, IModuleContainer> defaultImpl;
    private Set<IModuleContainer> activeModules;
    private Set<IModuleContainer> activeModules_;
    private Set<IModuleInfo> registeredModules = Sets.newHashSet();
    private Map<ResourceLocation, IModuleContainer> activeModuleNames;
    private Map<String, IModuleController> moduleControllers = Maps.newHashMap();
    private Map<Class<? extends Annotation>, Function<IModuleContainer, Object>> fieldProcessors;
    private Set<BiFunction<IASMDataHelper, Function<String, IModuleController>, List<IModuleInfo>>> moduleDiscoverers;
    private Set<String> erroredMods;
    private boolean locked;
    private boolean loaded;
    @APIHandlerInject
    private IASMDataHelper asmData = null;
    private static Field eventBus;

    private ModuleManager() {
        this.activeModules = Sets.newHashSet();
        this.activeModules_ = Collections.unmodifiableSet(this.activeModules);
        this.activeModuleNames = Maps.newHashMap();
        this.fieldProcessors = Maps.newHashMap();
        this.moduleDiscoverers = Sets.newHashSet();
        this.erroredMods = Sets.newHashSet();
    }

    void init() {
        this.moduleControllers = FMLUtil.getLoader().getActiveModList().stream().filter(mc -> mc.getMod() instanceof IModuleController).collect(Collectors.toMap(ModContainer::getModId, mc -> (IModuleController)mc.getMod()));
        this.moduleControllers.values().forEach(moduleController -> moduleController.registerAdditionalModules(INSTANCE::registerAdditionalModule));
        this.locked = true;
        this.moduleDiscoverers.forEach(func -> {
            List list = (List)func.apply(this.asmData, this::getModuleController);
            if (list == null) {
                return;
            }
            list.stream().filter(Objects::nonNull).filter(moduleInfo -> moduleInfo.alwaysEnabled() || moduleInfo.getModuleController().isModuleEnabled(moduleInfo.getName())).forEach(this.registeredModules::add);
        });
        List<IModuleInfo> depCheckModules = this.checkModDependencies();
        while (depCheckModules.size() != (depCheckModules = this.checkModuleDependencies(depCheckModules)).size()) {
        }
        this.constructModules(depCheckModules);
        this.registerModulesToModBus();
        this.fieldProcessors.forEach(INSTANCE::processModuleField);
        this.loaded = true;
    }

    private List<IModuleInfo> checkModDependencies() {
        HashMap names = Maps.newHashMap();
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            names.put(mod.getModId(), mod.getProcessedVersion());
        }
        ArrayList list = Lists.newArrayList();
        for (IModuleInfo module : this.registeredModules) {
            boolean add = true;
            HashSet missingMods = Sets.newHashSet();
            List<ArtifactVersion> requirements = module.getModDependencies();
            for (ArtifactVersion dep : requirements) {
                ArtifactVersion ver = (ArtifactVersion)names.get(dep.getLabel());
                if (ver != null && dep.containsVersion(ver)) continue;
                if (!module.autoDisableIfRequirementsNotMet()) {
                    missingMods.add(dep);
                }
                add = false;
            }
            if (!missingMods.isEmpty()) {
                String s = "Module: " + module.getCombinedName().toString();
                throw new MissingModsException((Set)missingMods, s, s);
            }
            if (!add) continue;
            list.add(module);
        }
        return list;
    }

    private List<IModuleInfo> checkModuleDependencies(List<IModuleInfo> list) {
        Set moduleNames = list.stream().map(IModuleInfo::getCombinedName).map(Object::toString).collect(Collectors.toSet());
        return list.stream().filter(moduleInfo -> {
            List missingDeps = moduleInfo.getModuleDependencies().stream().filter(Objects::nonNull).filter(s -> !moduleNames.contains(s)).collect(Collectors.toList());
            if (!missingDeps.isEmpty()) {
                if (!moduleInfo.autoDisableIfRequirementsNotMet()) {
                    throw new RuntimeException("Module: " + moduleInfo.getCombinedName() + " requires module(s) " + missingDeps + " to be present.");
                }
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private void constructModules(List<IModuleInfo> list) {
        for (IModuleInfo module : list) {
            if (this.activeModuleNames.get(module.getCombinedName()) != null) {
                throw new RuntimeException("Found duplicate module name: " + module.getCombinedName());
            }
            try {
                ModContainer owner = FMLUtil.findMod(module.getOwner());
                if (owner == null) {
                    throw new IllegalStateException("Error finding owner mod for module: " + module.getCombinedName());
                }
                IModuleContainer module_ = module.getModuleController().wrap(module, defaultImpl);
                if (module_ == null) continue;
                this.activeModules.add(module_);
                this.activeModuleNames.put(new ResourceLocation(module.getCombinedName().toString().toLowerCase()), module_);
                ElecCore.logger.info("Successfully registered module " + module.getName() + " from mod " + module.getOwner());
            }
            catch (Exception e) {
                ElecCore.logger.error("Error registering module " + module.getName() + " from mod " + module.getOwner());
                ElecCore.logger.error((Object)e);
            }
        }
    }

    private void registerModulesToModBus() {
        for (final IModuleContainer module : this.activeModules) {
            ModContainer mc = module.getOwnerMod();
            if (!FMLUtil.hasFMLModContainer(mc)) {
                throw new UnsupportedOperationException();
            }
            try {
                ((EventBus)eventBus.get(mc)).register(new Object(){

                    @Subscribe
                    public void onEvent(Object event) {
                        try {
                            module.invokeEvent(event);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error invoking event on module " + module.getModule() + ", owned by: " + module.getOwnerMod(), e.getCause());
                        }
                    }
                });
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void processModuleField(Class<? extends Annotation> clazz, Function<IModuleContainer, Object> function) {
        for (IModuleContainer module : this.activeModules) {
            for (Field field : module.getModule().getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(clazz)) continue;
                field.setAccessible(true);
                String name = "";
                try {
                    name = (String)clazz.getDeclaredMethod("value", new Class[0]).invoke((Object)field.getAnnotation(clazz), new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IModuleContainer module_ = module;
                if (!Strings.isNullOrEmpty((String)name)) {
                    module_ = this.activeModuleNames.get(new ResourceLocation(name));
                }
                Object o = function.apply(module_);
                try {
                    field.set(module.getModule(), o);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void registerAdditionalModule(IModuleInfo module) {
        if (this.locked) {
            throw new IllegalStateException("Mod " + Loader.instance().activeModContainer().getModId() + " attempted to register a module too late!");
        }
        if (module == null) {
            return;
        }
        this.registeredModules.add(module);
    }

    @Override
    @Nonnull
    public Set<IModuleContainer> getActiveModules() {
        return this.activeModules_;
    }

    @Override
    @Nullable
    public IModuleContainer getActiveModule(ResourceLocation module) {
        return this.activeModuleNames.get(new ResourceLocation(module.toString().toLowerCase()));
    }

    @Override
    public void registerFieldProcessor(Class<? extends Annotation> annotation, Function<IModuleContainer, Object> function) {
        this.fieldProcessors.put(annotation, function);
    }

    @Override
    public void registerModuleDiscoverer(BiFunction<IASMDataHelper, Function<String, IModuleController>, List<IModuleInfo>> discoverer) {
        this.moduleDiscoverers.add(discoverer);
    }

    @Override
    public void invokeEvent(Object event) {
        if (!this.loaded) {
            throw new IllegalStateException();
        }
        this.activeModules.forEach(module -> {
            try {
                module.invokeEvent(event);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking event of type: " + event.getClass().getCanonicalName() + " for module: " + module.getCombinedName(), e);
            }
        });
    }

    @APIHandlerInject
    public void injectModuleManager(IAPIHandler apiHandler) {
        apiHandler.inject(INSTANCE, IModuleManager.class);
    }

    @Nonnull
    private IModuleController getModuleController(String mod) {
        IModuleController ret = this.moduleControllers.get(mod);
        if (ret == null) {
            if (this.erroredMods.add(mod)) {
                ElecCore.logger.error("Mod: " + mod + " does not have a module controller!");
            }
            return DEFAULT_CONTROLLER;
        }
        return ret;
    }

    static {
        DEFAULT_CONTROLLER = moduleName -> true;
        defaultImpl = DefaultWrappedModule::new;
        try {
            eventBus = FMLModContainer.class.getDeclaredField("eventBus");
            eventBus.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

