/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part.aspect;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.aspect.build.AspectBuilder;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectValuePropagator;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectWriteActivator;
import org.cyclops.integrateddynamics.core.part.aspect.build.IAspectWriteDeactivator;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectProperties;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.part.aspect.read.AspectReadBuilders;
import org.cyclops.integrateddynamics.part.aspect.write.AspectWriteBuilders;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.IntegratedTunnels;
import org.cyclops.integratedtunnels.api.network.IItemNetwork;
import org.cyclops.integratedtunnels.capability.network.FluidNetworkConfig;
import org.cyclops.integratedtunnels.capability.network.ItemNetworkConfig;
import org.cyclops.integratedtunnels.core.ItemHandlerWorldEntityExportWrapper;
import org.cyclops.integratedtunnels.core.ItemHandlerWorldEntityImportWrapper;
import org.cyclops.integratedtunnels.core.ItemStoragePlayerWrapper;
import org.cyclops.integratedtunnels.core.TunnelEnergyHelpers;
import org.cyclops.integratedtunnels.core.TunnelFluidHelpers;
import org.cyclops.integratedtunnels.core.TunnelHelpers;
import org.cyclops.integratedtunnels.core.TunnelItemHelpers;
import org.cyclops.integratedtunnels.core.part.PartStatePositionedAddon;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;
import org.cyclops.integratedtunnels.part.PartStatePlayerSimulator;
import org.cyclops.integratedtunnels.part.aspect.ChanneledTargetInformation;
import org.cyclops.integratedtunnels.part.aspect.IChanneledTarget;
import org.cyclops.integratedtunnels.part.aspect.IEnergyTarget;
import org.cyclops.integratedtunnels.part.aspect.IFluidTarget;
import org.cyclops.integratedtunnels.part.aspect.IItemTarget;
import org.cyclops.integratedtunnels.part.aspect.ITunnelTransfer;
import org.cyclops.integratedtunnels.part.aspect.TunnelTransferComposite;
import org.cyclops.integratedtunnels.part.aspect.TunnelTransferEntities;
import org.cyclops.integratedtunnels.part.aspect.TunnelTransferEntity;

public class TunnelAspectWriteBuilders {
    public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_BLACKLIST = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.blacklist.name");
    public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_CHANNEL = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integrateddynamics.integer.channel.name");
    public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_ROUNDROBIN = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.roundrobin.name");
    public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_EXACTAMOUNT = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.exactamount.name");
    public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_EMPTYISANY = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.emptyisany.name");
    public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CRAFT = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.craft.name");
    public static final IAspectProperties PROPERTIES_CHANNEL = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN));

    @Nullable
    public static Entity getEntity(PartPos target, int entityIndex) {
        List entities = target.getPos().getWorld().func_72872_a(Entity.class, new AxisAlignedBB(target.getPos().getBlockPos()));
        Entity entity = null;
        if (entities.size() > 0 && entityIndex < entities.size()) {
            entity = entityIndex == -1 ? (Entity)entities.get(target.getPos().getWorld().field_73012_v.nextInt(entities.size())) : (Entity)entities.get(entityIndex);
        }
        return entity;
    }

    public static <N extends IPositionedAddonsNetwork, T> IAspectWriteActivator createPositionedNetworkAddonActivator(final Supplier<Capability<N>> networkCapability, final Capability<T> targetCapability) {
        return new IAspectWriteActivator(){

            public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onActivate(P partType, PartTarget target, S state) {
                state.addVolatileCapability(targetCapability, state);
                DimPos pos = target.getCenter().getPos();
                INetwork network = NetworkHelpers.getNetwork((IBlockAccess)pos.getWorld(), (BlockPos)pos.getBlockPos(), (EnumFacing)target.getCenter().getSide());
                if (network != null && network.hasCapability((Capability)networkCapability.get())) {
                    ((PartStatePositionedAddon)state).setPositionedAddonsNetwork((IPositionedAddonsNetwork)network.getCapability((Capability)networkCapability.get()));
                    DimPos originPos = target.getCenter().getPos();
                    DimPos targetPos = target.getTarget().getPos();
                    targetPos.getWorld().func_190524_a(targetPos.getBlockPos(), targetPos.getWorld().func_180495_p(targetPos.getBlockPos()).func_177230_c(), originPos.getBlockPos());
                }
            }
        };
    }

    public static <N extends IPositionedAddonsNetwork, T> IAspectWriteDeactivator createPositionedNetworkAddonDeactivator(final Supplier<Capability<N>> networkCapability, final Capability<T> targetCapability) {
        return new IAspectWriteDeactivator(){

            public <P extends IPartTypeWriter<P, S>, S extends IPartStateWriter<P>> void onDeactivate(P partType, PartTarget target, S state) {
                state.removeVolatileCapability(targetCapability);
                DimPos pos = target.getCenter().getPos();
                INetwork network = NetworkHelpers.getNetwork((IBlockAccess)pos.getWorld(), (BlockPos)pos.getBlockPos(), (EnumFacing)target.getCenter().getSide());
                if (network != null && network.hasCapability((Capability)networkCapability.get())) {
                    ((PartStatePositionedAddon)state).setPositionedAddonsNetwork((IPositionedAddonsNetwork)network.getCapability((Capability)networkCapability.get()));
                    DimPos originPos = target.getCenter().getPos();
                    DimPos targetPos = target.getTarget().getPos();
                    targetPos.getWorld().func_190524_a(targetPos.getBlockPos(), targetPos.getWorld().func_180495_p(targetPos.getBlockPos()).func_177230_c(), originPos.getBlockPos());
                }
            }
        };
    }

    static {
        PROPERTIES_CHANNEL.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
        PROPERTIES_CHANNEL.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
    }

    public static final class Player {
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Triple<PartTarget, IAspectProperties, Boolean>> BUILDER_BOOLEAN = AspectWriteBuilders.BUILDER_BOOLEAN.byMod((ModBase)IntegratedTunnels._instance).appendKind("player").handle(AspectWriteBuilders.PROP_GET_BOOLEAN).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedTunnels._instance).appendKind("player").handle(AspectWriteBuilders.PROP_GET_INTEGER).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack, Triple<PartTarget, IAspectProperties, ItemStack>> BUILDER_ITEMSTACK = AspectWriteBuilders.BUILDER_ITEMSTACK.byMod((ModBase)IntegratedTunnels._instance).appendKind("player").handle(AspectWriteBuilders.PROP_GET_ITEMSTACK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeFluidStack.ValueFluidStack, ValueObjectTypeFluidStack, Triple<PartTarget, IAspectProperties, FluidStack>> BUILDER_FLUIDSTACK = AspectWriteBuilders.BUILDER_FLUIDSTACK.byMod((ModBase)IntegratedTunnels._instance).appendKind("player").handle(AspectWriteBuilders.PROP_GET_FLUIDSTACK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>> BUILDER_LIST = AspectWriteBuilders.BUILDER_LIST.byMod((ModBase)IntegratedTunnels._instance).appendKind("player").withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeOperator.ValueOperator, ValueTypeOperator, Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>> BUILDER_OPERATOR = AspectWriteBuilders.BUILDER_OPERATOR.byMod((ModBase)IntegratedTunnels._instance).appendKind("player").withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeNbt.ValueNbt, ValueTypeNbt, Triple<PartTarget, IAspectProperties, NBTTagCompound>> BUILDER_NBT = AspectWriteBuilders.BUILDER_NBT.byMod((ModBase)IntegratedTunnels._instance).appendKind("player").handle(AspectWriteBuilders.PROP_GET_NBT).withProperties(PROPERTIES_CHANNEL);
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_RIGHT_CLICK = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.player.rightclick.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CONTINUOUS_CLICK = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.player.continuousclick.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_SNEAK = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.player.sneak.name");
        public static final IAspectProperties PROPERTIES_CLICK_EMPTY = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_RIGHT_CLICK, World.PROP_HAND_RIGHT, PROP_CONTINUOUS_CLICK, PROP_SNEAK, World.PROPERTY_ENTITYINDEX, World.PROP_OFFSET_X, World.PROP_OFFSET_Y, World.PROP_OFFSET_Z));
        public static final IAspectProperties PROPERTIES_CLICK_SIMPLE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_RIGHT_CLICK, World.PROP_HAND_RIGHT, PROP_CONTINUOUS_CLICK, PROP_SNEAK, Item.PROP_RATE, World.PROPERTY_ENTITYINDEX, World.PROP_OFFSET_X, World.PROP_OFFSET_Y, World.PROP_OFFSET_Z));
        public static final IAspectProperties PROPERTIES_CLICK_NORATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_RIGHT_CLICK, World.PROP_HAND_RIGHT, PROP_CONTINUOUS_CLICK, PROP_SNEAK, World.PROPERTY_ENTITYINDEX, World.PROP_OFFSET_X, World.PROP_OFFSET_Y, World.PROP_OFFSET_Z));
        public static final IAspectProperties PROPERTIES_CLICK = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_RIGHT_CLICK, PROP_EMPTYISANY, World.PROP_HAND_RIGHT, PROP_CONTINUOUS_CLICK, PROP_SNEAK, Item.PROP_CHECK_STACKSIZE, Item.PROP_CHECK_DAMAGE, Item.PROP_CHECK_NBT, Item.PROP_RATE, (Object[])new IAspectPropertyTypeInstance[]{World.PROPERTY_ENTITYINDEX, World.PROP_OFFSET_X, World.PROP_OFFSET_Y, World.PROP_OFFSET_Z}));
        public static final IAspectProperties PROPERTIES_CLICKCRAFT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_CRAFT, PROP_RIGHT_CLICK, World.PROP_HAND_RIGHT, PROP_CONTINUOUS_CLICK, PROP_SNEAK, Item.PROP_CHECK_STACKSIZE, Item.PROP_CHECK_DAMAGE, Item.PROP_CHECK_NBT, Item.PROP_RATE, (Object[])new IAspectPropertyTypeInstance[]{World.PROPERTY_ENTITYINDEX, World.PROP_OFFSET_X, World.PROP_OFFSET_Y, World.PROP_OFFSET_Z}));
        public static final IAspectProperties PROPERTIES_CLICKLIST;
        public static final IAspectProperties PROPERTIES_CLICK_NBT;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Void> PROP_CLICK_EMPTY;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>, IItemTarget> PROP_ITEMTARGET_CLICK;

        static {
            PROPERTIES_CLICK_EMPTY.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_CLICK_EMPTY.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK_EMPTY.setValue(PROP_RIGHT_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_EMPTY.setValue(World.PROP_HAND_RIGHT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_EMPTY.setValue(PROP_CONTINUOUS_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_EMPTY.setValue(PROP_SNEAK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK_EMPTY.setValue(World.PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_CLICK_EMPTY.setValue(World.PROP_OFFSET_X, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_EMPTY.setValue(World.PROP_OFFSET_Y, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_EMPTY.setValue(World.PROP_OFFSET_Z, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_SIMPLE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_CLICK_SIMPLE.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK_SIMPLE.setValue(PROP_RIGHT_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_SIMPLE.setValue(World.PROP_HAND_RIGHT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_SIMPLE.setValue(PROP_CONTINUOUS_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_SIMPLE.setValue(PROP_SNEAK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK_SIMPLE.setValue(Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1));
            PROPERTIES_CLICK_SIMPLE.setValue(World.PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_CLICK_SIMPLE.setValue(World.PROP_OFFSET_X, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_SIMPLE.setValue(World.PROP_OFFSET_Y, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_SIMPLE.setValue(World.PROP_OFFSET_Z, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_NORATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_CLICK_NORATE.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK_NORATE.setValue(PROP_RIGHT_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_NORATE.setValue(World.PROP_HAND_RIGHT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_NORATE.setValue(PROP_CONTINUOUS_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_NORATE.setValue(PROP_SNEAK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK_NORATE.setValue(World.PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_CLICK_NORATE.setValue(World.PROP_OFFSET_X, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_NORATE.setValue(World.PROP_OFFSET_Y, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK_NORATE.setValue(World.PROP_OFFSET_Z, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_CLICK.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK.setValue(PROP_RIGHT_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK.setValue(PROP_EMPTYISANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK.setValue(World.PROP_HAND_RIGHT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK.setValue(PROP_CONTINUOUS_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK.setValue(PROP_SNEAK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK.setValue(Item.PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK.setValue(Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK.setValue(Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK.setValue(Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1));
            PROPERTIES_CLICK.setValue(World.PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_CLICK.setValue(World.PROP_OFFSET_X, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK.setValue(World.PROP_OFFSET_Y, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICK.setValue(World.PROP_OFFSET_Z, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICKCRAFT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_CLICKCRAFT.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICKCRAFT.setValue(PROP_CRAFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICKCRAFT.setValue(PROP_RIGHT_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICKCRAFT.setValue(World.PROP_HAND_RIGHT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICKCRAFT.setValue(PROP_CONTINUOUS_CLICK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICKCRAFT.setValue(PROP_SNEAK, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICKCRAFT.setValue(Item.PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICKCRAFT.setValue(Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICKCRAFT.setValue(Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICKCRAFT.setValue(Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1));
            PROPERTIES_CLICKCRAFT.setValue(World.PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_CLICKCRAFT.setValue(World.PROP_OFFSET_X, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICKCRAFT.setValue(World.PROP_OFFSET_Y, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICKCRAFT.setValue(World.PROP_OFFSET_Z, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
            PROPERTIES_CLICKLIST = PROPERTIES_CLICK.clone();
            PROPERTIES_CLICK_NBT = PROPERTIES_CLICK_SIMPLE.clone();
            PROPERTIES_CLICKLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_CLICK_NBT.setValue(Item.PROP_NBT_SUBSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_NBT.setValue(Item.PROP_NBT_SUPERSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_NBT.setValue(Item.PROP_NBT_REQUIRE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_CLICK_NBT.setValue(Item.PROP_NBT_RECURSIVE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROP_CLICK_EMPTY = input -> {
                if (((Boolean)input.getRight()).booleanValue()) {
                    PartTarget partTarget = (PartTarget)input.getLeft();
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    EnumHand hand = ((ValueTypeBoolean.ValueBoolean)properties.getValue(World.PROP_HAND_RIGHT)).getRawValue() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
                    boolean rightClick = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_RIGHT_CLICK)).getRawValue();
                    boolean continuousClick = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CONTINUOUS_CLICK)).getRawValue();
                    boolean sneak = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_SNEAK)).getRawValue();
                    int entityIndex = ((ValueTypeInteger.ValueInteger)properties.getValue(World.PROPERTY_ENTITYINDEX)).getRawValue();
                    double offsetX = ((ValueTypeDouble.ValueDouble)properties.getValue(World.PROP_OFFSET_X)).getRawValue();
                    double offsetY = ((ValueTypeDouble.ValueDouble)properties.getValue(World.PROP_OFFSET_Y)).getRawValue();
                    double offsetZ = ((ValueTypeDouble.ValueDouble)properties.getValue(World.PROP_OFFSET_Z)).getRawValue();
                    int channel = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_CHANNEL)).getRawValue();
                    PartPos center = partTarget.getCenter();
                    PartPos target = partTarget.getTarget();
                    INetwork network = IChanneledTarget.getNetworkChecked(center);
                    PartStatePlayerSimulator partState = (PartStatePlayerSimulator)PartHelpers.getPart((PartPos)center).getState();
                    ItemStoragePlayerWrapper storage = new ItemStoragePlayerWrapper(partState.getPlayer(), (WorldServer)target.getPos().getWorld(), target.getPos().getBlockPos(), offsetX, offsetY, offsetZ, target.getSide(), hand, rightClick, sneak, continuousClick, entityIndex, (IIngredientComponentStorage<ItemStack, Integer>)((IItemNetwork)network.getCapability(ItemNetworkConfig.CAPABILITY)).getChannel(channel));
                    storage.insert(ItemStack.field_190927_a, false);
                }
                return null;
            };
            PROP_ITEMTARGET_CLICK = input -> {
                PartTarget partTarget = (PartTarget)input.getLeft();
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                IngredientPredicate<ItemStack, Integer> itemStackMatcher = ((ChanneledTargetInformation)input.getRight()).getIngredientPredicate();
                EnumHand hand = ((ValueTypeBoolean.ValueBoolean)((IAspectProperties)input.getMiddle()).getValue(World.PROP_HAND_RIGHT)).getRawValue() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
                boolean rightClick = ((ValueTypeBoolean.ValueBoolean)((IAspectProperties)input.getMiddle()).getValue(PROP_RIGHT_CLICK)).getRawValue();
                boolean continuousClick = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CONTINUOUS_CLICK)).getRawValue();
                boolean sneak = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_SNEAK)).getRawValue();
                int entityIndex = ((ValueTypeInteger.ValueInteger)properties.getValue(World.PROPERTY_ENTITYINDEX)).getRawValue();
                double offsetX = ((ValueTypeDouble.ValueDouble)properties.getValue(World.PROP_OFFSET_X)).getRawValue();
                double offsetY = ((ValueTypeDouble.ValueDouble)properties.getValue(World.PROP_OFFSET_Y)).getRawValue();
                double offsetZ = ((ValueTypeDouble.ValueDouble)properties.getValue(World.PROP_OFFSET_Z)).getRawValue();
                int channel = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_CHANNEL)).getRawValue();
                PartPos center = partTarget.getCenter();
                PartPos target = partTarget.getTarget();
                INetwork network = IChanneledTarget.getNetworkChecked(center);
                PartStatePlayerSimulator partState = (PartStatePlayerSimulator)PartHelpers.getPart((PartPos)center).getState();
                ItemStoragePlayerWrapper storage = new ItemStoragePlayerWrapper(partState.getPlayer(), (WorldServer)target.getPos().getWorld(), target.getPos().getBlockPos(), offsetX, offsetY, offsetZ, target.getSide(), hand, rightClick, sneak, continuousClick, entityIndex, (IIngredientComponentStorage<ItemStack, Integer>)((IItemNetwork)network.getCapability(ItemNetworkConfig.CAPABILITY)).getChannel(channel));
                ITunnelTransfer transfer = ((ChanneledTargetInformation)input.getRight()).getTransfer();
                return IItemTarget.ofStorage(transfer, network, partTarget, properties, itemStackMatcher, storage, -1);
            };
        }
    }

    public static final class World {
        public static final AspectBuilder<ValueObjectTypeBlock.ValueBlock, ValueObjectTypeBlock, Triple<PartTarget, IAspectProperties, ValueObjectTypeBlock.ValueBlock>> BUILDER_BLOCK_BASE = AspectWriteBuilders.getValue((AspectBuilder)AspectBuilder.forWriteType((IValueType)ValueTypes.OBJECT_BLOCK)).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Triple<PartTarget, IAspectProperties, Boolean>> BUILDER_BOOLEAN = AspectWriteBuilders.BUILDER_BOOLEAN.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").handle(AspectWriteBuilders.PROP_GET_BOOLEAN).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").handle(AspectWriteBuilders.PROP_GET_INTEGER).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack, Triple<PartTarget, IAspectProperties, ItemStack>> BUILDER_ITEMSTACK = AspectWriteBuilders.BUILDER_ITEMSTACK.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").handle(AspectWriteBuilders.PROP_GET_ITEMSTACK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeBlock.ValueBlock, ValueObjectTypeBlock, Triple<PartTarget, IAspectProperties, IBlockState>> BUILDER_BLOCK = BUILDER_BLOCK_BASE.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").handle(AspectWriteBuilders.PROP_GET_BLOCK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeFluidStack.ValueFluidStack, ValueObjectTypeFluidStack, Triple<PartTarget, IAspectProperties, FluidStack>> BUILDER_FLUIDSTACK = AspectWriteBuilders.BUILDER_FLUIDSTACK.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").handle(AspectWriteBuilders.PROP_GET_FLUIDSTACK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>> BUILDER_LIST = AspectWriteBuilders.BUILDER_LIST.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeOperator.ValueOperator, ValueTypeOperator, Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>> BUILDER_OPERATOR = AspectWriteBuilders.BUILDER_OPERATOR.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeNbt.ValueNbt, ValueTypeNbt, Triple<PartTarget, IAspectProperties, NBTTagCompound>> BUILDER_NBT = AspectWriteBuilders.BUILDER_NBT.byMod((ModBase)IntegratedTunnels._instance).appendKind("world").handle(AspectWriteBuilders.PROP_GET_NBT).withProperties(PROPERTIES_CHANNEL);
        public static final Predicate<ValueTypeDouble.ValueDouble> VALIDATOR_DOUBLE_ANGLE = input -> input.getRawValue() >= -180.0 && input.getRawValue() <= 180.0;
        public static final Predicate<ValueTypeDouble.ValueDouble> VALIDATOR_DOUBLE_OFFSET = input -> input.getRawValue() >= 0.0 && input.getRawValue() <= 1.0;
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_BLOCK_UPDATE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.blockupdate.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_HAND_RIGHT = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.righthand.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_SILK_TOUCH = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.silktouch.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_IGNORE_REPLACABLE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.ignorereplacable.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_BREAK_ON_NO_DROPS = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.breaknodrops.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_IGNORE_PICK_UP_DELAY = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.ignorepickupdelay.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_DISPENSE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.world.dispense.name");
        public static final IAspectPropertyTypeInstance<ValueTypeDouble, ValueTypeDouble.ValueDouble> PROP_OFFSET_X = new AspectPropertyTypeInstance((IValueType)ValueTypes.DOUBLE, "aspect.aspecttypes.integratedtunnels.double.world.offsetx.name", VALIDATOR_DOUBLE_OFFSET);
        public static final IAspectPropertyTypeInstance<ValueTypeDouble, ValueTypeDouble.ValueDouble> PROP_OFFSET_Y = new AspectPropertyTypeInstance((IValueType)ValueTypes.DOUBLE, "aspect.aspecttypes.integratedtunnels.double.world.offsety.name", VALIDATOR_DOUBLE_OFFSET);
        public static final IAspectPropertyTypeInstance<ValueTypeDouble, ValueTypeDouble.ValueDouble> PROP_OFFSET_Z = new AspectPropertyTypeInstance((IValueType)ValueTypes.DOUBLE, "aspect.aspecttypes.integratedtunnels.double.world.offsetz.name", VALIDATOR_DOUBLE_OFFSET);
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_LIFESPAN = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.boolean.world.lifespan.name", AspectReadBuilders.VALIDATOR_INTEGER_POSITIVE);
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_DELAY_BEFORE_PICKUP = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.boolean.world.delaybeforepickup.name", AspectReadBuilders.VALIDATOR_INTEGER_POSITIVE);
        public static final IAspectPropertyTypeInstance<ValueTypeDouble, ValueTypeDouble.ValueDouble> PROP_VELOCITY = new AspectPropertyTypeInstance((IValueType)ValueTypes.DOUBLE, "aspect.aspecttypes.integratedtunnels.double.world.velocity.name", input -> input.getRawValue() >= 0.0 && input.getRawValue() <= 25.0);
        public static final IAspectPropertyTypeInstance<ValueTypeDouble, ValueTypeDouble.ValueDouble> PROP_YAW = new AspectPropertyTypeInstance((IValueType)ValueTypes.DOUBLE, "aspect.aspecttypes.integratedtunnels.double.world.yaw.name", VALIDATOR_DOUBLE_ANGLE);
        public static final IAspectPropertyTypeInstance<ValueTypeDouble, ValueTypeDouble.ValueDouble> PROP_PITCH = new AspectPropertyTypeInstance((IValueType)ValueTypes.DOUBLE, "aspect.aspecttypes.integratedtunnels.double.world.pitch.name", VALIDATOR_DOUBLE_ANGLE);
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROPERTY_ENTITYINDEX = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.entityindex.name");

        public static final class Block {
            public static final IAspectProperties PROPERTIES_ITEM_PLACE_NOCHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLOCK_UPDATE, PROP_HAND_RIGHT, PROP_IGNORE_REPLACABLE));
            public static final IAspectProperties PROPERTIES_ITEMCRAFT_PLACE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_EMPTYISANY, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, PROP_BLOCK_UPDATE, PROP_HAND_RIGHT, PROP_IGNORE_REPLACABLE, PROP_CRAFT));
            public static final IAspectProperties PROPERTIES_ITEM_PLACE_NBT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_BLOCK_UPDATE, PROP_HAND_RIGHT, PROP_IGNORE_REPLACABLE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_SUBSET, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_SUPERSET, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_REQUIRE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_RECURSIVE));
            public static final IAspectProperties PROPERTIES_ITEM_PICK_UP_NOCHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLOCK_UPDATE, PROP_HAND_RIGHT, PROP_SILK_TOUCH, PROP_IGNORE_REPLACABLE, PROP_BREAK_ON_NO_DROPS));
            public static final IAspectProperties PROPERTIES_ITEM_PICK_UP = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_EMPTYISANY, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, PROP_BLOCK_UPDATE, PROP_HAND_RIGHT, PROP_SILK_TOUCH, PROP_IGNORE_REPLACABLE, PROP_BREAK_ON_NO_DROPS));
            public static final IAspectProperties PROPERTIES_ITEM_PICK_UP_NBT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_BLOCK_UPDATE, PROP_HAND_RIGHT, PROP_SILK_TOUCH, PROP_IGNORE_REPLACABLE, PROP_BREAK_ON_NO_DROPS, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_SUBSET, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_SUPERSET, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_REQUIRE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_RECURSIVE, (Object[])new IAspectPropertyTypeInstance[0]));
            public static final IAspectProperties PROPERTIES_BLOCK_PLACE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLOCK_UPDATE, PROP_HAND_RIGHT, PROP_IGNORE_REPLACABLE));
            public static final IAspectProperties PROPERTIES_BLOCK_PICK_UP = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLOCK_UPDATE, PROP_HAND_RIGHT, PROP_SILK_TOUCH, PROP_IGNORE_REPLACABLE, PROP_BREAK_ON_NO_DROPS));
            public static final IAspectProperties PROPERTIES_ITEM_PLACELIST;
            public static final IAspectProperties PROPERTIES_ITEM_PICK_UPLIST;
            public static final IAspectProperties PROPERTIES_BLOCK_PLACELIST;
            public static final IAspectProperties PROPERTIES_BLOCK_PICK_UPLIST;
            public static final IAspectProperties PROPERTIES_BLOCKCRAFT_PLACEBLOCK;
            public static final IAspectProperties PROPERTIES_BLOCK_PICK_UPBLOCK;
            public static final IAspectValuePropagator<IItemTarget, Void> PROP_ITEMBLOCK_EXPORT;
            public static final IAspectValuePropagator<IItemTarget, Void> PROP_ITEMBLOCK_IMPORT;

            static {
                PROPERTIES_ITEM_PLACE_NOCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ITEM_PLACE_NOCHECKS.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PLACE_NOCHECKS.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PLACE_NOCHECKS.setValue(PROP_HAND_RIGHT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PLACE_NOCHECKS.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEMCRAFT_PLACE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ITEMCRAFT_PLACE.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEMCRAFT_PLACE.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEMCRAFT_PLACE.setValue(PROP_EMPTYISANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEMCRAFT_PLACE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEMCRAFT_PLACE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEMCRAFT_PLACE.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEMCRAFT_PLACE.setValue(PROP_HAND_RIGHT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEMCRAFT_PLACE.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEMCRAFT_PLACE.setValue(PROP_CRAFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PLACE_NBT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ITEM_PLACE_NBT.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PLACE_NBT.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PLACE_NBT.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PLACE_NBT.setValue(PROP_HAND_RIGHT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PLACE_NBT.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PLACE_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_SUBSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PLACE_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_SUPERSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PLACE_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_REQUIRE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PLACE_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_RECURSIVE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP_NOCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ITEM_PICK_UP_NOCHECKS.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP_NOCHECKS.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP_NOCHECKS.setValue(PROP_HAND_RIGHT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP_NOCHECKS.setValue(PROP_SILK_TOUCH, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP_NOCHECKS.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP_NOCHECKS.setValue(PROP_BREAK_ON_NO_DROPS, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_EMPTYISANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_HAND_RIGHT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_SILK_TOUCH, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP.setValue(PROP_BREAK_ON_NO_DROPS, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP_NBT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ITEM_PICK_UP_NBT.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP_NBT.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP_NBT.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP_NBT.setValue(PROP_HAND_RIGHT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP_NBT.setValue(PROP_SILK_TOUCH, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP_NBT.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UP_NBT.setValue(PROP_BREAK_ON_NO_DROPS, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_SUBSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_SUPERSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_REQUIRE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PICK_UP_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_RECURSIVE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_BLOCK_PLACE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_BLOCK_PLACE.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PLACE.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PLACE.setValue(PROP_HAND_RIGHT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_BLOCK_PLACE.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PICK_UP.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_BLOCK_PICK_UP.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PICK_UP.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PICK_UP.setValue(PROP_HAND_RIGHT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_BLOCK_PICK_UP.setValue(PROP_SILK_TOUCH, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PICK_UP.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PICK_UP.setValue(PROP_BREAK_ON_NO_DROPS, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ITEM_PLACELIST = PROPERTIES_ITEMCRAFT_PLACE.clone();
                PROPERTIES_ITEM_PICK_UPLIST = PROPERTIES_ITEM_PICK_UP.clone();
                PROPERTIES_BLOCK_PLACELIST = PROPERTIES_BLOCK_PLACE.clone();
                PROPERTIES_BLOCK_PICK_UPLIST = PROPERTIES_BLOCK_PICK_UP.clone();
                PROPERTIES_BLOCKCRAFT_PLACEBLOCK = PROPERTIES_BLOCK_PLACE.clone();
                PROPERTIES_BLOCK_PICK_UPBLOCK = PROPERTIES_BLOCK_PICK_UP.clone();
                PROPERTIES_ITEM_PLACELIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ITEM_PICK_UPLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PLACELIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PICK_UPLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCKCRAFT_PLACEBLOCK.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCKCRAFT_PLACEBLOCK.setValue(PROP_EMPTYISANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_BLOCKCRAFT_PLACEBLOCK.setValue(PROP_CRAFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PICK_UPBLOCK.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_BLOCK_PICK_UPBLOCK.setValue(PROP_EMPTYISANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROP_ITEMBLOCK_EXPORT = input -> {
                    PartPos target = input.getPartTarget().getTarget();
                    IItemNetwork itemNetwork = (IItemNetwork)input.getChanneledNetwork();
                    if (target.getPos().isLoaded() && itemNetwork != null) {
                        EnumHand hand = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_HAND_RIGHT)).getRawValue() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
                        boolean blockUpdate = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_BLOCK_UPDATE)).getRawValue();
                        boolean ignoreReplacable = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_IGNORE_REPLACABLE)).getRawValue();
                        TunnelItemHelpers.placeItems(input.getNetwork(), (IPositionedAddonsNetworkIngredients<ItemStack, Integer>)((IPositionedAddonsNetworkIngredients)input.getChanneledNetwork()), input.getChannel(), input.getConnection(), input.getItemChannel(), target.getPos().getWorld(), target.getPos().getBlockPos(), target.getSide(), input.getItemStackMatcher(), hand, blockUpdate, ignoreReplacable, input.isCraftIfFailed());
                    }
                    return null;
                };
                PROP_ITEMBLOCK_IMPORT = input -> {
                    PartPos target = input.getPartTarget().getTarget();
                    IItemNetwork itemNetwork = (IItemNetwork)input.getChanneledNetwork();
                    if (target.getPos().isLoaded() && itemNetwork != null) {
                        EnumHand hand = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_HAND_RIGHT)).getRawValue() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
                        boolean blockUpdate = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_BLOCK_UPDATE)).getRawValue();
                        boolean ignoreReplacable = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_IGNORE_REPLACABLE)).getRawValue();
                        int fortune = 0;
                        boolean silkTouch = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_SILK_TOUCH)).getRawValue();
                        boolean breakOnNoDrops = ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_BREAK_ON_NO_DROPS)).getRawValue();
                        TunnelItemHelpers.pickUpItems(input.getNetwork(), (IPositionedAddonsNetworkIngredients<ItemStack, Integer>)((IPositionedAddonsNetworkIngredients)input.getChanneledNetwork()), input.getChannel(), input.getConnection(), target.getPos().getWorld(), target.getPos().getBlockPos(), target.getSide(), input.getItemChannel(), input.getItemStackMatcher(), hand, blockUpdate, ignoreReplacable, fortune, silkTouch, breakOnNoDrops);
                    }
                    return null;
                };
            }
        }

        public static final class Fluid {
            public static final IAspectProperties PROPERTIES_UPDATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLOCK_UPDATE, PROP_IGNORE_REPLACABLE));
            public static final IAspectProperties PROPERTIES_FLUIDCRAFT_UPDATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_EMPTYISANY, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT, PROP_BLOCK_UPDATE, PROP_IGNORE_REPLACABLE, PROP_CRAFT));
            public static final IAspectProperties PROPERTIES_FLUIDLIST_UPDATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT, PROP_BLOCK_UPDATE, PROP_IGNORE_REPLACABLE));
            public static final IAspectProperties PROPERTIES_FLUID = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_EMPTYISANY, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT));
            public static final IAspectProperties PROPERTIES_FLUIDLIST = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT));
            public static final IAspectProperties PROPERTIES_NBT_UPDATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_BLOCK_UPDATE, PROP_IGNORE_REPLACABLE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_SUBSET, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_SUPERSET, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_REQUIRE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_RECURSIVE));
            public static final IAspectProperties PROPERTIES_NBT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_SUBSET, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_SUPERSET, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_REQUIRE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_RECURSIVE));
            public static final IAspectProperties PROPERTIES_RATE = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROPERTIES_RATE.clone();
            public static final IAspectProperties PROPERTIES_RATECHECKS = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROPERTIES_RATECHECKS.clone();
            public static final IAspectProperties PROPERTIES_RATECHECKSCRAFT = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROPERTIES_RATECHECKSCRAFT.clone();
            public static final IAspectProperties PROPERTIES_RATECHECKSLIST = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROPERTIES_RATECHECKSLIST.clone();
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, IFluidTarget> PROP_BOOLEAN_FLUIDTARGET;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, FluidStack>, IFluidTarget> PROP_FLUIDSTACK_FLUIDTARGET;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, IFluidTarget> PROP_FLUIDSTACKLIST_FLUIDTARGET;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>, IFluidTarget> PROP_FLUIDSTACKPREDICATE_FLUIDTARGET;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, NBTTagCompound>, IFluidTarget> PROP_NBT_FLUIDTARGET;
            public static final IAspectValuePropagator<IFluidTarget, Void> PROP_FLUIDSTACK_EXPORT;
            public static final IAspectValuePropagator<IFluidTarget, Void> PROP_FLUIDSTACK_IMPORT;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<FluidStack, Integer>>, IFluidTarget> PROP_ENTITY_FLUIDTARGET;

            static {
                PROPERTIES_UPDATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_UPDATE.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_UPDATE.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_UPDATE.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDCRAFT_UPDATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_FLUIDCRAFT_UPDATE.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDCRAFT_UPDATE.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDCRAFT_UPDATE.setValue(PROP_EMPTYISANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_FLUIDCRAFT_UPDATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_FLUIDCRAFT_UPDATE.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDCRAFT_UPDATE.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDCRAFT_UPDATE.setValue(PROP_CRAFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDLIST_UPDATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_FLUIDLIST_UPDATE.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDLIST_UPDATE.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDLIST_UPDATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_FLUIDLIST_UPDATE.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDLIST_UPDATE.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUID.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_FLUID.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUID.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUID.setValue(PROP_EMPTYISANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_FLUID.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_FLUIDLIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_FLUIDLIST.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_FLUIDLIST.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_RATE.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATECHECKS.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATECHECKS.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_RATECHECKSCRAFT.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATECHECKSCRAFT.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_RATECHECKSLIST.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_NBT_UPDATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_NBT_UPDATE.setValue(PROP_BLOCK_UPDATE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_NBT_UPDATE.setValue(PROP_IGNORE_REPLACABLE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_NBT_UPDATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_SUBSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_NBT_UPDATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_SUPERSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_NBT_UPDATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_REQUIRE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_NBT_UPDATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_RECURSIVE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_NBT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_SUBSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_SUPERSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_REQUIRE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_RECURSIVE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROP_BOOLEAN_FLUIDTARGET = input -> {
                    IngredientPredicate<FluidStack, Integer> fluidStackPredicate = (Boolean)input.getRight() != false ? TunnelFluidHelpers.matchAll(1000, false) : TunnelFluidHelpers.MATCH_NONE;
                    return IFluidTarget.ofCapabilityProvider(fluidStackPredicate, (PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), fluidStackPredicate);
                };
                PROP_FLUIDSTACK_FLUIDTARGET = input -> {
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT)).getRawValue();
                    boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                    int amount = 1000;
                    FluidStack prototype = TunnelFluidHelpers.prototypeWithCount((FluidStack)input.getRight(), amount);
                    boolean checkFluid = true;
                    if (input.getRight() == null) {
                        IngredientPredicate.EmptyBehaviour emptyBehaviour = IngredientPredicate.EmptyBehaviour.fromBoolean(((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EMPTYISANY)).getRawValue());
                        if (emptyBehaviour == IngredientPredicate.EmptyBehaviour.ANY) {
                            checkNbt = false;
                            checkFluid = false;
                        } else {
                            prototype = null;
                        }
                    }
                    IngredientPredicate<FluidStack, Integer> fluidStackPredicate = TunnelFluidHelpers.matchFluidStack(prototype, checkFluid, false, checkNbt, blacklist, true);
                    return IFluidTarget.ofBlock(fluidStackPredicate, (PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), fluidStackPredicate);
                };
                PROP_FLUIDSTACKLIST_FLUIDTARGET = input -> {
                    ValueTypeList.ValueList list = (ValueTypeList.ValueList)input.getRight();
                    if (list.getRawValue().getValueType() != ValueTypes.OBJECT_FLUIDSTACK) {
                        throw new EvaluationException(new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{ValueTypes.OBJECT_FLUIDSTACK, list.getRawValue().getValueType()}).localize());
                    }
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_CHECK_NBT)).getRawValue();
                    boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                    IngredientPredicate<FluidStack, Integer> fluidStackPredicate = TunnelFluidHelpers.matchFluidStacks((IValueTypeListProxy<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack>)list.getRawValue(), false, false, checkNbt, blacklist, 1000, true);
                    return IFluidTarget.ofBlock(fluidStackPredicate, (PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), fluidStackPredicate);
                };
                PROP_FLUIDSTACKPREDICATE_FLUIDTARGET = input -> {
                    IOperator predicate = ((ValueTypeOperator.ValueOperator)input.getRight()).getRawValue();
                    if (predicate.getInputTypes().length == 1 && ValueHelpers.correspondsTo((IValueType)predicate.getInputTypes()[0], (IValueType)ValueTypes.OBJECT_FLUIDSTACK) && ValueHelpers.correspondsTo((IValueType)predicate.getOutputType(), (IValueType)ValueTypes.BOOLEAN)) {
                        IngredientPredicate<FluidStack, Integer> fluidStackPredicate = TunnelFluidHelpers.matchPredicate((PartTarget)input.getLeft(), predicate, 1000, true);
                        return IFluidTarget.ofBlock(fluidStackPredicate, (PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), fluidStackPredicate);
                    }
                    String current = ValueTypeOperator.getSignature((IOperator)predicate);
                    String expected = ValueTypeOperator.getSignature((IValueType[])new IValueType[]{ValueTypes.OBJECT_FLUIDSTACK}, (IValueType)ValueTypes.BOOLEAN);
                    throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalid_type", new Object[]{expected, current}).localize());
                };
                PROP_NBT_FLUIDTARGET = input -> {
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    NBTTagCompound tag = (NBTTagCompound)input.getRight();
                    boolean subset = ((ValueTypeBoolean.ValueBoolean)properties.getValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_SUBSET)).getRawValue();
                    boolean superset = ((ValueTypeBoolean.ValueBoolean)properties.getValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_SUPERSET)).getRawValue();
                    boolean requireNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_REQUIRE)).getRawValue();
                    boolean recursive = ((ValueTypeBoolean.ValueBoolean)properties.getValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Fluid.PROP_NBT_RECURSIVE)).getRawValue();
                    boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                    IngredientPredicate<FluidStack, Integer> fluidStackMatcher = TunnelFluidHelpers.matchNbt(tag, subset, superset, requireNbt, recursive, blacklist, 1000, true);
                    return IFluidTarget.ofBlock(fluidStackMatcher, (PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), fluidStackMatcher);
                };
                PROP_FLUIDSTACK_EXPORT = input -> {
                    PartPos target = input.getPartTarget().getTarget();
                    DimPos pos = target.getPos();
                    if (pos.isLoaded() && input.getChanneledNetwork() != null) {
                        IIngredientComponentStorage<FluidStack, Integer> fluidChannel = input.getFluidChannel();
                        input.preTransfer();
                        TunnelFluidHelpers.placeFluids(input.getNetwork(), (IPositionedAddonsNetworkIngredients<FluidStack, Integer>)((IPositionedAddonsNetworkIngredients)input.getChanneledNetwork()), input.getChannel(), input.getConnection(), fluidChannel, pos.getWorld(), pos.getBlockPos(), input.getFluidStackMatcher(), ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_BLOCK_UPDATE)).getRawValue(), ((ValueTypeBoolean.ValueBoolean)input.getProperties().getValue(PROP_IGNORE_REPLACABLE)).getRawValue(), input.isCraftIfFailed());
                        input.postTransfer();
                    }
                    return null;
                };
                PROP_FLUIDSTACK_IMPORT = input -> {
                    PartPos target = input.getPartTarget().getTarget();
                    DimPos pos = target.getPos();
                    if (pos.isLoaded() && input.getChanneledNetwork() != null) {
                        IIngredientComponentStorage<FluidStack, Integer> fluidChannel = input.getFluidChannel();
                        input.preTransfer();
                        TunnelFluidHelpers.pickUpFluids(input.getNetwork(), (IPositionedAddonsNetworkIngredients<FluidStack, Integer>)((IPositionedAddonsNetworkIngredients)input.getChanneledNetwork()), input.getChannel(), input.getConnection(), target.getPos().getWorld(), target.getPos().getBlockPos(), target.getSide(), fluidChannel, input.getFluidStackMatcher());
                        input.postTransfer();
                    }
                    return null;
                };
                PROP_ENTITY_FLUIDTARGET = input -> {
                    PartTarget partTarget = (PartTarget)input.getLeft();
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    IngredientPredicate<FluidStack, Integer> fluidStackPredicate = ((ChanneledTargetInformation)input.getRight()).getIngredientPredicate();
                    int entityIndex = ((ValueTypeInteger.ValueInteger)properties.getValue(PROPERTY_ENTITYINDEX)).getRawValue();
                    Entity entity = TunnelAspectWriteBuilders.getEntity(partTarget.getTarget(), entityIndex);
                    return IFluidTarget.ofEntity(fluidStackPredicate, partTarget, entity, properties, fluidStackPredicate);
                };
            }
        }

        public static final class Item {
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PICK_UP_NORATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_EXACTAMOUNT, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_STACKSIZE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, PROP_IGNORE_PICK_UP_DELAY));
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_EXACTAMOUNT, PROP_DISPENSE, PROP_OFFSET_X, PROP_OFFSET_Y, PROP_OFFSET_Z, PROP_LIFESPAN, PROP_DELAY_BEFORE_PICKUP, PROP_VELOCITY, PROP_YAW, PROP_PITCH, (Object[])new IAspectPropertyTypeInstance[0]));
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PICK_UP;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PLACE_NORATE;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PLACE_NOCHECKS;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PLACE_NBT;
            public static final IAspectProperties PROPERTIES_ENTITYITEMCRAFT_PLACE;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PICK_UP_NOCHECKS;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PICK_UP_NORATE_NOCHECKS;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PICK_UP_NBT;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PICK_UPLIST;
            public static final IAspectProperties PROPERTIES_ENTITYITEM_PLACELIST;
            public static final IAspectProperties PROPERTIES_RATESLOT;
            public static final IAspectProperties PROPERTIES_SLOT;
            public static final IAspectProperties PROPERTIES_RATESLOTCHECKS;
            public static final IAspectProperties PROPERTIES_RATESLOTCHECKSCRAFT;
            public static final IAspectProperties PROPERTIES_NBT;
            public static final IAspectProperties PROPERTIES_RATESLOTCHECKSLIST;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, IItemTarget> PROP_BOOLEAN_ITEMTARGET;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>, IItemTarget> PROP_ENTITYITEM_ITEMTARGET_IMPORT;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>, IItemTarget> PROP_ENTITYITEM_ITEMTARGET_EXPORT;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>, IItemTarget> PROP_ENTITY_ITEMTARGET;

            public static <T> IAspectValuePropagator<Triple<PartTarget, IAspectProperties, T>, Triple<PartTarget, IAspectProperties, T>> ignoreStackSize() {
                return input -> {
                    IAspectProperties aspectProperties = ((IAspectProperties)input.getMiddle()).clone();
                    aspectProperties.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                    aspectProperties.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1));
                    return Triple.of((Object)input.getLeft(), (Object)aspectProperties, (Object)input.getRight());
                };
            }

            public static IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>, IItemTarget> newPropEntityItemItemTarget(boolean doImport) {
                return input -> {
                    ITunnelTransfer transfer;
                    Object itemStorage;
                    PartTarget partTarget = (PartTarget)input.getLeft();
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    IngredientPredicate<ItemStack, Integer> itemStackMatcher = ((ChanneledTargetInformation)input.getRight()).getIngredientPredicate();
                    PartPos center = partTarget.getCenter();
                    PartPos target = partTarget.getTarget();
                    INetwork network = IChanneledTarget.getNetworkChecked(center);
                    if (doImport) {
                        boolean ignorePickupDelay = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_IGNORE_PICK_UP_DELAY)).getRawValue();
                        itemStorage = new ItemHandlerWorldEntityImportWrapper((WorldServer)target.getPos().getWorld(), target.getPos().getBlockPos(), target.getSide(), ignorePickupDelay);
                        transfer = new TunnelTransferComposite(((ChanneledTargetInformation)input.getRight()).getTransfer(), new TunnelTransferEntities(itemStorage.getEntities()));
                    } else {
                        double offsetX = ((ValueTypeDouble.ValueDouble)properties.getValue(PROP_OFFSET_X)).getRawValue();
                        double offsetY = ((ValueTypeDouble.ValueDouble)properties.getValue(PROP_OFFSET_Y)).getRawValue();
                        double offsetZ = ((ValueTypeDouble.ValueDouble)properties.getValue(PROP_OFFSET_Z)).getRawValue();
                        int lifespan = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_LIFESPAN)).getRawValue();
                        int delayBeforePickup = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_DELAY_BEFORE_PICKUP)).getRawValue();
                        EnumFacing facing = center.getSide();
                        double velocity = ((ValueTypeDouble.ValueDouble)properties.getValue(PROP_VELOCITY)).getRawValue();
                        double yaw = ((ValueTypeDouble.ValueDouble)properties.getValue(PROP_YAW)).getRawValue();
                        double pitch = ((ValueTypeDouble.ValueDouble)properties.getValue(PROP_PITCH)).getRawValue();
                        boolean dispense = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_DISPENSE)).getRawValue();
                        int channel = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_CHANNEL)).getRawValue();
                        itemStorage = new ItemHandlerWorldEntityExportWrapper((WorldServer)target.getPos().getWorld(), target.getPos().getBlockPos(), offsetX, offsetY, offsetZ, lifespan, delayBeforePickup, facing, velocity, yaw, pitch, dispense, (IIngredientComponentStorage<ItemStack, Integer>)((IItemNetwork)network.getCapability(ItemNetworkConfig.CAPABILITY)).getChannel(channel));
                        transfer = ((ChanneledTargetInformation)input.getRight()).getTransfer();
                    }
                    return IItemTarget.ofStorage(transfer, network, partTarget, properties, itemStackMatcher, itemStorage, -1);
                };
            }

            static {
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE.setValue(PROP_IGNORE_PICK_UP_DELAY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_DISPENSE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_OFFSET_X, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_OFFSET_Y, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_OFFSET_Z, (IValue)ValueTypeDouble.ValueDouble.of((double)0.5));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_LIFESPAN, (IValue)ValueTypeInteger.ValueInteger.of((int)6000));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_DELAY_BEFORE_PICKUP, (IValue)ValueTypeInteger.ValueInteger.of((int)10));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_VELOCITY, (IValue)ValueTypeDouble.ValueDouble.of((double)0.1));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_YAW, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0));
                PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.setValue(PROP_PITCH, (IValue)ValueTypeDouble.ValueDouble.of((double)0.0));
                PROPERTIES_ENTITYITEM_PICK_UP = PROPERTIES_ENTITYITEM_PICK_UP_NORATE.clone();
                PROPERTIES_ENTITYITEM_PLACE_NORATE = PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.clone();
                PROPERTIES_ENTITYITEM_PLACE_NOCHECKS = PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.clone();
                PROPERTIES_ENTITYITEM_PLACE_NBT = PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.clone();
                PROPERTIES_ENTITYITEMCRAFT_PLACE = PROPERTIES_ENTITYITEM_PLACE_NORATE_NOCHECKS.clone();
                PROPERTIES_ENTITYITEM_PICK_UP_NOCHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_EXACTAMOUNT, PROP_IGNORE_PICK_UP_DELAY, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE_NOCHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_EXACTAMOUNT, PROP_IGNORE_PICK_UP_DELAY));
                PROPERTIES_ENTITYITEM_PICK_UP_NBT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_IGNORE_PICK_UP_DELAY, org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE));
                PROPERTIES_ENTITYITEM_PICK_UP.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
                PROPERTIES_ENTITYITEM_PICK_UP.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PICK_UP.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PICK_UP.setValue(PROP_EMPTYISANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP_NOCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PICK_UP_NOCHECKS.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PICK_UP_NOCHECKS.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PICK_UP_NOCHECKS.setValue(PROP_IGNORE_PICK_UP_DELAY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP_NOCHECKS.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE_NOCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE_NOCHECKS.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE_NOCHECKS.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PICK_UP_NORATE_NOCHECKS.setValue(PROP_IGNORE_PICK_UP_DELAY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP_NBT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEM_PICK_UP_NBT.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PICK_UP_NBT.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PICK_UP_NBT.setValue(PROP_IGNORE_PICK_UP_DELAY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
                PROPERTIES_ENTITYITEM_PICK_UP_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_SUBSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_SUPERSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_REQUIRE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UP_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_RECURSIVE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEMCRAFT_PLACE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYITEMCRAFT_PLACE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
                PROPERTIES_ENTITYITEMCRAFT_PLACE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEMCRAFT_PLACE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEMCRAFT_PLACE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEMCRAFT_PLACE.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEMCRAFT_PLACE.setValue(PROP_EMPTYISANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEMCRAFT_PLACE.setValue(PROP_CRAFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PLACE_NORATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PLACE_NORATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PLACE_NORATE.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PLACE_NOCHECKS.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
                PROPERTIES_ENTITYITEM_PLACE_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
                PROPERTIES_ENTITYITEM_PLACE_NBT.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PLACE_NBT.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PLACE_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_SUBSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PLACE_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_SUPERSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PLACE_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_REQUIRE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PLACE_NBT.setValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_NBT_RECURSIVE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_ENTITYITEM_PICK_UPLIST = PROPERTIES_ENTITYITEM_PICK_UP.clone();
                PROPERTIES_ENTITYITEM_PLACELIST = PROPERTIES_ENTITYITEMCRAFT_PLACE.clone();
                PROPERTIES_ENTITYITEM_PICK_UPLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYITEM_PLACELIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_RATESLOT = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROPERTIES_RATESLOT.clone();
                PROPERTIES_SLOT = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROPERTIES_SLOT.clone();
                PROPERTIES_RATESLOTCHECKS = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROPERTIES_RATESLOTCHECKS.clone();
                PROPERTIES_RATESLOTCHECKSCRAFT = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROPERTIES_RATESLOTCHECKSCRAFT.clone();
                PROPERTIES_NBT = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROPERTIES_NBT.clone();
                PROPERTIES_RATESLOT.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_SLOT.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATESLOTCHECKS.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATESLOTCHECKS.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_RATESLOTCHECKS.setValue(PROP_EMPTYISANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
                PROPERTIES_RATESLOTCHECKSCRAFT.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATESLOTCHECKSCRAFT.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_NBT.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_RATESLOTCHECKSLIST = PROPERTIES_RATESLOTCHECKS.clone();
                PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROP_BOOLEAN_ITEMTARGET = input -> {
                    IngredientPredicate<ItemStack, Integer> itemMatcher = (Boolean)input.getRight() != false ? TunnelItemHelpers.matchAll(64, false) : TunnelItemHelpers.MATCH_NONE;
                    return IItemTarget.ofBlock(itemMatcher, (PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), itemMatcher, ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Item.PROP_SLOT)).getRawValue());
                };
                PROP_ENTITYITEM_ITEMTARGET_IMPORT = Item.newPropEntityItemItemTarget(true);
                PROP_ENTITYITEM_ITEMTARGET_EXPORT = Item.newPropEntityItemItemTarget(false);
                PROP_ENTITY_ITEMTARGET = input -> {
                    PartTarget partTarget = (PartTarget)input.getLeft();
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    IngredientPredicate<ItemStack, Integer> itemStackMatcher = ((ChanneledTargetInformation)input.getRight()).getIngredientPredicate();
                    int entityIndex = ((ValueTypeInteger.ValueInteger)properties.getValue(PROPERTY_ENTITYINDEX)).getRawValue();
                    Entity entity = TunnelAspectWriteBuilders.getEntity(partTarget.getTarget(), entityIndex);
                    TunnelTransferComposite transfer = new TunnelTransferComposite(((ChanneledTargetInformation)input.getRight()).getTransfer(), new TunnelTransferEntity(entity));
                    return IItemTarget.ofEntity(transfer, partTarget, entity, properties, itemStackMatcher, -1);
                };
            }
        }

        public static final class Energy {
            public static final IAspectProperties PROPERTIES = org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders$Energy.PROPERTIES_RATE.clone();
            public static final IAspectProperties PROPERTIES_ENTITY;
            public static final IAspectProperties PROPERTIES_ENTITYCRAFT;
            public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, IEnergyTarget> PROP_ENTITY_ENERGYTARGET;

            static {
                PROPERTIES.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITY = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_EXACTAMOUNT, PROPERTY_ENTITYINDEX));
                PROPERTIES_ENTITYCRAFT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_EXACTAMOUNT, PROPERTY_ENTITYINDEX, PROP_CRAFT));
                PROPERTIES_ENTITY.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITY.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITY.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYCRAFT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYCRAFT.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROPERTIES_ENTITYCRAFT.setValue(PROPERTY_ENTITYINDEX, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
                PROPERTIES_ENTITYCRAFT.setValue(PROP_CRAFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
                PROP_ENTITY_ENERGYTARGET = input -> {
                    PartTarget partTarget = (PartTarget)input.getLeft();
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    int amount = (Integer)input.getRight();
                    int entityIndex = ((ValueTypeInteger.ValueInteger)properties.getValue(PROPERTY_ENTITYINDEX)).getRawValue();
                    Entity entity = TunnelAspectWriteBuilders.getEntity(partTarget.getTarget(), entityIndex);
                    return IEnergyTarget.ofEntity(partTarget, entity, properties, amount);
                };
            }
        }
    }

    public static final class Fluid {
        public static final IAspectWriteActivator ACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonActivator(() -> FluidNetworkConfig.CAPABILITY, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        public static final IAspectWriteDeactivator DEACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonDeactivator(() -> FluidNetworkConfig.CAPABILITY, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Triple<PartTarget, IAspectProperties, Boolean>> BUILDER_BOOLEAN = AspectWriteBuilders.BUILDER_BOOLEAN.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").handle(AspectWriteBuilders.PROP_GET_BOOLEAN).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").handle(AspectWriteBuilders.PROP_GET_INTEGER).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeFluidStack.ValueFluidStack, ValueObjectTypeFluidStack, Triple<PartTarget, IAspectProperties, FluidStack>> BUILDER_FLUIDSTACK = AspectWriteBuilders.BUILDER_FLUIDSTACK.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").handle(AspectWriteBuilders.PROP_GET_FLUIDSTACK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>> BUILDER_LIST = AspectWriteBuilders.BUILDER_LIST.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeOperator.ValueOperator, ValueTypeOperator, Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>> BUILDER_OPERATOR = AspectWriteBuilders.BUILDER_OPERATOR.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeNbt.ValueNbt, ValueTypeNbt, Triple<PartTarget, IAspectProperties, NBTTagCompound>> BUILDER_NBT = AspectWriteBuilders.BUILDER_NBT.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("fluid").handle(AspectWriteBuilders.PROP_GET_NBT).withProperties(PROPERTIES_CHANNEL);
        public static final Predicate<ValueTypeInteger.ValueInteger> VALIDATOR_INTEGER_MAXRATE = input -> input.getRawValue() <= GeneralConfig.fluidRateLimit;
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_RATE = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.fluid.rate.name", AspectReadBuilders.VALIDATOR_INTEGER_POSITIVE.and(VALIDATOR_INTEGER_MAXRATE));
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_AMOUNT = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.fluid.checkamount.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_NBT = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.fluid.checknbt.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_NBT_SUBSET = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.fluid.nbtsubset.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_NBT_SUPERSET = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.fluid.nbtsuperset.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_NBT_REQUIRE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.fluid.nbtrequire.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_NBT_RECURSIVE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.fluid.nbtrecursive.name");
        public static final IAspectProperties PROPERTIES = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_EXACTAMOUNT));
        public static final IAspectProperties PROPERTIES_RATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_RATE, PROP_EXACTAMOUNT));
        public static final IAspectProperties PROPERTIES_RATECHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_EMPTYISANY, PROP_RATE, PROP_EXACTAMOUNT, PROP_CHECK_AMOUNT, PROP_CHECK_NBT));
        public static final IAspectProperties PROPERTIES_RATECHECKSCRAFT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_EMPTYISANY, PROP_RATE, PROP_EXACTAMOUNT, PROP_CHECK_AMOUNT, PROP_CHECK_NBT, PROP_CRAFT));
        public static final IAspectProperties PROPERTIES_RATECHECKSLIST = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_RATE, PROP_EXACTAMOUNT, PROP_CHECK_AMOUNT, PROP_CHECK_NBT));
        public static final IAspectProperties PROPERTIES_NBT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_RATE, PROP_NBT_SUBSET, PROP_NBT_SUPERSET, PROP_NBT_REQUIRE, PROP_NBT_RECURSIVE));
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Triple<PartTarget, IAspectProperties, Integer>> PROP_BOOLEAN_GETRATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<FluidStack, Integer>>> PROP_INTEGER_FLUIDPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, FluidStack>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<FluidStack, Integer>>> PROP_FLUIDSTACK_FLUIDPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<FluidStack, Integer>>> PROP_FLUIDSTACKLIST_FLUIDPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<FluidStack, Integer>>> PROP_FLUIDSTACKPREDICATE_FLUIDPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, NBTTagCompound>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<FluidStack, Integer>>> PROP_NBT_FLUIDPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<FluidStack, Integer>>, IFluidTarget> PROP_FLUIDTARGET;
        public static final IAspectValuePropagator<IFluidTarget, Void> PROP_EXPORT;
        public static final IAspectValuePropagator<IFluidTarget, Void> PROP_IMPORT;

        static {
            PROPERTIES.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATE.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATE.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROPERTIES_RATE.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATECHECKS.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKS.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKS.setValue(PROP_EMPTYISANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATECHECKS.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROPERTIES_RATECHECKS.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKS.setValue(PROP_CHECK_AMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKS.setValue(PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATECHECKSCRAFT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATECHECKSCRAFT.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKSCRAFT.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKSCRAFT.setValue(PROP_EMPTYISANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATECHECKSCRAFT.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROPERTIES_RATECHECKSCRAFT.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKSCRAFT.setValue(PROP_CHECK_AMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKSCRAFT.setValue(PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATECHECKSCRAFT.setValue(PROP_CRAFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKSLIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATECHECKSLIST.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKSLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKSLIST.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROPERTIES_RATECHECKSLIST.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECHECKSLIST.setValue(PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATECHECKSLIST.setValue(PROP_CHECK_AMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_NBT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_NBT.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROPERTIES_NBT.setValue(PROP_NBT_SUBSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_NBT.setValue(PROP_NBT_SUPERSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_NBT.setValue(PROP_NBT_REQUIRE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_NBT.setValue(PROP_NBT_RECURSIVE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROP_BOOLEAN_GETRATE = input -> Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)((Boolean)input.getRight() != false ? ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(PROP_RATE)).getRawValue() : 0));
            PROP_INTEGER_FLUIDPREDICATE = input -> {
                IngredientPredicate<FluidStack, Integer> fluidStackMatcher = TunnelFluidHelpers.matchAll((Integer)input.getRight(), ((ValueTypeBoolean.ValueBoolean)((IAspectProperties)input.getMiddle()).getValue(PROP_EXACTAMOUNT)).getRawValue());
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(fluidStackMatcher, fluidStackMatcher, -1));
            };
            PROP_FLUIDSTACK_FLUIDPREDICATE = input -> {
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                int rate = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                boolean exactAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EXACTAMOUNT)).getRawValue();
                boolean checkAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_AMOUNT)).getRawValue();
                boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_NBT)).getRawValue();
                boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                boolean checkFluid = true;
                FluidStack prototype = TunnelFluidHelpers.prototypeWithCount((FluidStack)input.getRight(), rate);
                if (input.getRight() == null) {
                    IngredientPredicate.EmptyBehaviour emptyBehaviour = IngredientPredicate.EmptyBehaviour.fromBoolean(((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EMPTYISANY)).getRawValue());
                    if (emptyBehaviour == IngredientPredicate.EmptyBehaviour.ANY) {
                        checkAmount = false;
                        checkNbt = false;
                        checkFluid = false;
                    } else {
                        prototype = null;
                    }
                }
                IngredientPredicate<FluidStack, Integer> ingredientPredicate = TunnelFluidHelpers.matchFluidStack(prototype, checkFluid, checkAmount, checkNbt, blacklist, exactAmount);
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(ingredientPredicate, ingredientPredicate, -1));
            };
            PROP_FLUIDSTACKLIST_FLUIDPREDICATE = input -> {
                ValueTypeList.ValueList list = (ValueTypeList.ValueList)input.getRight();
                if (list.getRawValue().getValueType() != ValueTypes.OBJECT_FLUIDSTACK) {
                    throw new EvaluationException(new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{ValueTypes.OBJECT_FLUIDSTACK, list.getRawValue().getValueType()}).localize());
                }
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                int rate = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                boolean exactAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EXACTAMOUNT)).getRawValue();
                boolean checkAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_AMOUNT)).getRawValue();
                boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_NBT)).getRawValue();
                boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                IngredientPredicate<FluidStack, Integer> fluidStackMatcher = TunnelFluidHelpers.matchFluidStacks((IValueTypeListProxy<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack>)list.getRawValue(), true, checkAmount, checkNbt, blacklist, rate, exactAmount);
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(fluidStackMatcher, fluidStackMatcher, -1));
            };
            PROP_FLUIDSTACKPREDICATE_FLUIDPREDICATE = input -> {
                IOperator predicate = ((ValueTypeOperator.ValueOperator)input.getRight()).getRawValue();
                if (predicate.getInputTypes().length == 1 && ValueHelpers.correspondsTo((IValueType)predicate.getInputTypes()[0], (IValueType)ValueTypes.OBJECT_FLUIDSTACK) && ValueHelpers.correspondsTo((IValueType)predicate.getOutputType(), (IValueType)ValueTypes.BOOLEAN)) {
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    int rate = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                    boolean exactAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EXACTAMOUNT)).getRawValue();
                    IngredientPredicate<FluidStack, Integer> fluidStackMatcher = TunnelFluidHelpers.matchPredicate((PartTarget)input.getLeft(), predicate, rate, exactAmount);
                    return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(fluidStackMatcher, fluidStackMatcher, -1));
                }
                String current = ValueTypeOperator.getSignature((IOperator)predicate);
                String expected = ValueTypeOperator.getSignature((IValueType[])new IValueType[]{ValueTypes.OBJECT_FLUIDSTACK}, (IValueType)ValueTypes.BOOLEAN);
                throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalid_type", new Object[]{expected, current}).localize());
            };
            PROP_NBT_FLUIDPREDICATE = input -> {
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                NBTTagCompound tag = (NBTTagCompound)input.getRight();
                int rate = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                boolean exactAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EXACTAMOUNT)).getRawValue();
                boolean subset = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_NBT_SUBSET)).getRawValue();
                boolean superset = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_NBT_SUPERSET)).getRawValue();
                boolean requireNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_NBT_REQUIRE)).getRawValue();
                boolean recursive = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_NBT_RECURSIVE)).getRawValue();
                boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                IngredientPredicate<FluidStack, Integer> fluidStackMatcher = TunnelFluidHelpers.matchNbt(tag, subset, superset, requireNbt, recursive, blacklist, rate, exactAmount);
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(fluidStackMatcher, fluidStackMatcher, -1));
            };
            PROP_FLUIDTARGET = input -> IFluidTarget.ofCapabilityProvider(((ChanneledTargetInformation)input.getRight()).getTransfer(), (PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), ((ChanneledTargetInformation)input.getRight()).getIngredientPredicate());
            PROP_EXPORT = input -> {
                if (input.hasValidTarget()) {
                    input.preTransfer();
                    TunnelHelpers.moveSingleStateOptimized(input.getNetwork(), (IPositionedAddonsNetworkIngredients)input.getChanneledNetwork(), input.getChannel(), input.getConnection(), input.getFluidChannel(), -1, input.getStorage(), -1, input.getFluidStackMatcher(), input.isCraftIfFailed());
                    input.postTransfer();
                }
                return null;
            };
            PROP_IMPORT = input -> {
                if (input.hasValidTarget()) {
                    input.preTransfer();
                    TunnelHelpers.moveSingleStateOptimized(input.getNetwork(), (IPositionedAddonsNetworkIngredients)input.getChanneledNetwork(), input.getChannel(), input.getConnection(), input.getStorage(), -1, input.getFluidChannel(), -1, input.getFluidStackMatcher(), false);
                    input.postTransfer();
                }
                return null;
            };
        }
    }

    public static final class Item {
        public static final IAspectWriteActivator ACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonActivator(() -> ItemNetworkConfig.CAPABILITY, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        public static final IAspectWriteDeactivator DEACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonDeactivator(() -> ItemNetworkConfig.CAPABILITY, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Triple<PartTarget, IAspectProperties, Boolean>> BUILDER_BOOLEAN = AspectWriteBuilders.BUILDER_BOOLEAN.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").handle(AspectWriteBuilders.PROP_GET_BOOLEAN).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").handle(AspectWriteBuilders.PROP_GET_INTEGER).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueObjectTypeItemStack.ValueItemStack, ValueObjectTypeItemStack, Triple<PartTarget, IAspectProperties, ItemStack>> BUILDER_ITEMSTACK = AspectWriteBuilders.BUILDER_ITEMSTACK.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").handle(AspectWriteBuilders.PROP_GET_ITEMSTACK).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeList.ValueList, ValueTypeList, Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>> BUILDER_LIST = AspectWriteBuilders.BUILDER_LIST.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeOperator.ValueOperator, ValueTypeOperator, Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>> BUILDER_OPERATOR = AspectWriteBuilders.BUILDER_OPERATOR.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeNbt.ValueNbt, ValueTypeNbt, Triple<PartTarget, IAspectProperties, NBTTagCompound>> BUILDER_NBT = AspectWriteBuilders.BUILDER_NBT.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("item").handle(AspectWriteBuilders.PROP_GET_NBT).withProperties(PROPERTIES_CHANNEL);
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_RATE = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.item.rate.name", AspectReadBuilders.VALIDATOR_INTEGER_POSITIVE);
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_SLOT = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.item.slot.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_STACKSIZE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.item.checkstacksize.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_DAMAGE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.item.checkdamage.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_CHECK_NBT = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.item.checknbt.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_NBT_SUBSET = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.item.nbtsubset.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_NBT_SUPERSET = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.item.nbtsuperset.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_NBT_REQUIRE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.item.nbtrequire.name");
        public static final IAspectPropertyTypeInstance<ValueTypeBoolean, ValueTypeBoolean.ValueBoolean> PROP_NBT_RECURSIVE = new AspectPropertyTypeInstance((IValueType)ValueTypes.BOOLEAN, "aspect.aspecttypes.integratedtunnels.boolean.item.nbtrecursive.name");
        public static final IAspectProperties PROPERTIES_RATESLOT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_RATE, PROP_EXACTAMOUNT, PROP_SLOT));
        public static final IAspectProperties PROPERTIES_SLOT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_EXACTAMOUNT, PROP_SLOT));
        public static final IAspectProperties PROPERTIES_RATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_RATE, PROP_EXACTAMOUNT));
        public static final IAspectProperties PROPERTIES_RATESLOTCHECKS = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_RATE, PROP_EXACTAMOUNT, PROP_SLOT, PROP_CHECK_STACKSIZE, PROP_CHECK_DAMAGE, PROP_CHECK_NBT, PROP_EMPTYISANY));
        public static final IAspectProperties PROPERTIES_RATESLOTCHECKSCRAFT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_RATE, PROP_EXACTAMOUNT, PROP_SLOT, PROP_CHECK_STACKSIZE, PROP_CHECK_DAMAGE, PROP_CHECK_NBT, PROP_CRAFT));
        public static final IAspectProperties PROPERTIES_RATESLOTCHECKSLIST = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_RATE, PROP_EXACTAMOUNT, PROP_SLOT, PROP_CHECK_STACKSIZE, PROP_CHECK_DAMAGE, PROP_CHECK_NBT));
        public static final IAspectProperties PROPERTIES_NBT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_BLACKLIST, PROP_RATE, PROP_EXACTAMOUNT, PROP_SLOT, PROP_NBT_SUBSET, PROP_NBT_SUPERSET, PROP_NBT_REQUIRE, PROP_NBT_RECURSIVE));
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>> PROP_BOOLEAN_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>> PROP_INTEGER_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>> PROP_INTEGER_SLOT_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ItemStack>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>> PROP_ITEMSTACK_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>> PROP_ITEMSTACKLIST_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>> PROP_ITEMSTACKPREDICATE_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, NBTTagCompound>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>> PROP_NBT_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, IBlockState>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>> PROP_BLOCK_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeList.ValueList>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>> PROP_BLOCKLIST_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ValueTypeOperator.ValueOperator>, Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>> PROP_BLOCKPREDICATE_ITEMPREDICATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, ChanneledTargetInformation<ItemStack, Integer>>, IItemTarget> PROP_ITEMTARGET;
        public static final IAspectValuePropagator<IItemTarget, Void> PROP_EXPORT;
        public static final IAspectValuePropagator<IItemTarget, Void> PROP_IMPORT;

        static {
            PROPERTIES_RATESLOT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATESLOT.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOT.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
            PROPERTIES_RATESLOT.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOT.setValue(PROP_SLOT, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_SLOT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_SLOT.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_SLOT.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_SLOT.setValue(PROP_SLOT, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_RATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATE.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATE.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
            PROPERTIES_RATE.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_SLOT, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATESLOTCHECKS.setValue(PROP_EMPTYISANY, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATESLOTCHECKSCRAFT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATESLOTCHECKSCRAFT.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKSCRAFT.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKSCRAFT.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
            PROPERTIES_RATESLOTCHECKSCRAFT.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKSCRAFT.setValue(PROP_SLOT, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_RATESLOTCHECKSCRAFT.setValue(PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKSCRAFT.setValue(PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATESLOTCHECKSCRAFT.setValue(PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATESLOTCHECKSCRAFT.setValue(PROP_CRAFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_SLOT, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_CHECK_STACKSIZE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_CHECK_DAMAGE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_RATESLOTCHECKSLIST.setValue(PROP_CHECK_NBT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_NBT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_NBT.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_NBT.setValue(PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_NBT.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)64));
            PROPERTIES_NBT.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_NBT.setValue(PROP_SLOT, (IValue)ValueTypeInteger.ValueInteger.of((int)-1));
            PROPERTIES_NBT.setValue(PROP_NBT_SUBSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_NBT.setValue(PROP_NBT_SUPERSET, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_NBT.setValue(PROP_NBT_REQUIRE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROPERTIES_NBT.setValue(PROP_NBT_RECURSIVE, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
            PROP_BOOLEAN_ITEMPREDICATE = input -> {
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                int amount = (Boolean)input.getRight() != false ? ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(PROP_RATE)).getRawValue() : 0;
                boolean exactAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EXACTAMOUNT)).getRawValue();
                IngredientPredicate<ItemStack, Integer> itemStackMatcher = (Boolean)input.getRight() != false ? TunnelItemHelpers.matchAll(amount, exactAmount) : TunnelItemHelpers.MATCH_NONE;
                int slot = ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(PROP_SLOT)).getRawValue();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(itemStackMatcher, itemStackMatcher, slot));
            };
            PROP_INTEGER_ITEMPREDICATE = input -> {
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                int amount = (Integer)input.getRight();
                boolean exactAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EXACTAMOUNT)).getRawValue();
                IngredientPredicate<ItemStack, Integer> itemStackMatcher = TunnelItemHelpers.matchAll(amount, exactAmount);
                int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(itemStackMatcher, itemStackMatcher, slot));
            };
            PROP_INTEGER_SLOT_ITEMPREDICATE = input -> {
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                int amount = (Integer)input.getRight() >= -1 ? ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue() : 0;
                boolean exactAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EXACTAMOUNT)).getRawValue();
                IngredientPredicate<ItemStack, Integer> itemStackMatcher = TunnelItemHelpers.matchAll(amount, exactAmount);
                int slot = (Integer)input.getRight();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(itemStackMatcher, itemStackMatcher, slot));
            };
            PROP_ITEMSTACK_ITEMPREDICATE = input -> {
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                boolean checkStackSize = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_STACKSIZE)).getRawValue();
                boolean checkDamage = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_DAMAGE)).getRawValue();
                boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_NBT)).getRawValue();
                boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                boolean exactAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EXACTAMOUNT)).getRawValue();
                int amount = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                ItemStack prototype = TunnelItemHelpers.prototypeWithCount((ItemStack)input.getRight(), amount);
                boolean checkItem = true;
                if (((ItemStack)input.getRight()).func_190926_b()) {
                    IngredientPredicate.EmptyBehaviour emptyBehaviour = IngredientPredicate.EmptyBehaviour.fromBoolean(((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EMPTYISANY)).getRawValue());
                    if (emptyBehaviour == IngredientPredicate.EmptyBehaviour.ANY) {
                        checkStackSize = false;
                        checkDamage = false;
                        checkNbt = false;
                        checkItem = false;
                    } else {
                        prototype = ItemStack.field_190927_a;
                    }
                }
                IngredientPredicate<ItemStack, Integer> itemStackMatcher = TunnelItemHelpers.matchItemStack(prototype, checkItem, checkStackSize, checkDamage, checkNbt, blacklist, exactAmount);
                int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(itemStackMatcher, itemStackMatcher, slot));
            };
            PROP_ITEMSTACKLIST_ITEMPREDICATE = input -> {
                ValueTypeList.ValueList list = (ValueTypeList.ValueList)input.getRight();
                if (list.getRawValue().getValueType() != ValueTypes.OBJECT_ITEMSTACK) {
                    throw new EvaluationException(new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{ValueTypes.OBJECT_ITEMSTACK, list.getRawValue().getValueType()}).localize());
                }
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                boolean checkStackSize = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_STACKSIZE)).getRawValue();
                boolean checkDamage = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_DAMAGE)).getRawValue();
                boolean checkNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_CHECK_NBT)).getRawValue();
                boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                boolean exactAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EXACTAMOUNT)).getRawValue();
                int amount = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                IngredientPredicate<ItemStack, Integer> itemStackMatcher = TunnelItemHelpers.matchItemStacks((IValueTypeListProxy<ValueObjectTypeItemStack, ValueObjectTypeItemStack.ValueItemStack>)list.getRawValue(), true, checkStackSize, checkDamage, checkNbt, blacklist, amount, exactAmount);
                int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(itemStackMatcher, itemStackMatcher, slot));
            };
            PROP_ITEMSTACKPREDICATE_ITEMPREDICATE = input -> {
                IOperator predicate = ((ValueTypeOperator.ValueOperator)input.getRight()).getRawValue();
                if (predicate.getInputTypes().length == 1 && ValueHelpers.correspondsTo((IValueType)predicate.getInputTypes()[0], (IValueType)ValueTypes.OBJECT_ITEMSTACK) && ValueHelpers.correspondsTo((IValueType)predicate.getOutputType(), (IValueType)ValueTypes.BOOLEAN)) {
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    int amount = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                    boolean exactAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EXACTAMOUNT)).getRawValue();
                    IngredientPredicate<ItemStack, Integer> itemStackMatcher = TunnelItemHelpers.matchPredicateItem((PartTarget)input.getLeft(), predicate, amount, exactAmount);
                    int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                    return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(itemStackMatcher, itemStackMatcher, slot));
                }
                String current = ValueTypeOperator.getSignature((IOperator)predicate);
                String expected = ValueTypeOperator.getSignature((IValueType[])new IValueType[]{ValueTypes.OBJECT_ITEMSTACK}, (IValueType)ValueTypes.BOOLEAN);
                throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalid_type", new Object[]{expected, current}).localize());
            };
            PROP_NBT_ITEMPREDICATE = input -> {
                NBTTagCompound tag = (NBTTagCompound)input.getRight();
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                int amount = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_RATE)).getRawValue();
                boolean exactAmount = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EXACTAMOUNT)).getRawValue();
                int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                boolean subset = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_NBT_SUBSET)).getRawValue();
                boolean superset = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_NBT_SUPERSET)).getRawValue();
                boolean requireNbt = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_NBT_REQUIRE)).getRawValue();
                boolean recursive = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_NBT_RECURSIVE)).getRawValue();
                boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                IngredientPredicate<ItemStack, Integer> itemStackMatcher = TunnelItemHelpers.matchNbt(tag, subset, superset, requireNbt, recursive, blacklist, amount, exactAmount);
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(itemStackMatcher, itemStackMatcher, slot));
            };
            PROP_BLOCK_ITEMPREDICATE = input -> {
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                int amount = 1;
                boolean exactAmount = false;
                ItemStack itemBlock = input.getRight() == null ? ItemStack.field_190927_a : BlockHelpers.getItemStackFromBlockState((IBlockState)((IBlockState)input.getRight()));
                ItemStack prototype = TunnelItemHelpers.prototypeWithCount(itemBlock, amount);
                boolean checkItem = true;
                boolean checkDamage = true;
                if (itemBlock.func_190926_b()) {
                    IngredientPredicate.EmptyBehaviour emptyBehaviour = IngredientPredicate.EmptyBehaviour.fromBoolean(((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_EMPTYISANY)).getRawValue());
                    if (emptyBehaviour == IngredientPredicate.EmptyBehaviour.ANY) {
                        checkDamage = false;
                        checkItem = false;
                    } else {
                        prototype = ItemStack.field_190927_a;
                    }
                }
                IngredientPredicate<ItemStack, Integer> itemStackMatcher = TunnelItemHelpers.matchItemStack(prototype, checkItem, false, checkDamage, false, blacklist, exactAmount);
                int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(itemStackMatcher, itemStackMatcher, slot));
            };
            PROP_BLOCKLIST_ITEMPREDICATE = input -> {
                ValueTypeList.ValueList list = (ValueTypeList.ValueList)input.getRight();
                if (list.getRawValue().getValueType() != ValueTypes.OBJECT_BLOCK) {
                    throw new EvaluationException(new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{ValueTypes.OBJECT_BLOCK, list.getRawValue().getValueType()}).localize());
                }
                IAspectProperties properties = (IAspectProperties)input.getMiddle();
                boolean blacklist = ((ValueTypeBoolean.ValueBoolean)properties.getValue(PROP_BLACKLIST)).getRawValue();
                int amount = 1;
                boolean exactAmount = false;
                IngredientPredicate<ItemStack, Integer> itemStackMatcher = TunnelItemHelpers.matchBlocks((IValueTypeListProxy<ValueObjectTypeBlock, ValueObjectTypeBlock.ValueBlock>)list.getRawValue(), true, false, true, false, blacklist, amount, exactAmount);
                int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(itemStackMatcher, itemStackMatcher, slot));
            };
            PROP_BLOCKPREDICATE_ITEMPREDICATE = input -> {
                IOperator predicate = ((ValueTypeOperator.ValueOperator)input.getRight()).getRawValue();
                if (predicate.getInputTypes().length == 1 && ValueHelpers.correspondsTo((IValueType)predicate.getInputTypes()[0], (IValueType)ValueTypes.OBJECT_BLOCK) && ValueHelpers.correspondsTo((IValueType)predicate.getOutputType(), (IValueType)ValueTypes.BOOLEAN)) {
                    IAspectProperties properties = (IAspectProperties)input.getMiddle();
                    int amount = 1;
                    boolean exactAmount = false;
                    IngredientPredicate<ItemStack, Integer> itemStackMatcher = TunnelItemHelpers.matchPredicateBlock((PartTarget)input.getLeft(), predicate, amount, exactAmount);
                    int slot = ((ValueTypeInteger.ValueInteger)properties.getValue(PROP_SLOT)).getRawValue();
                    return Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), ChanneledTargetInformation.of(itemStackMatcher, itemStackMatcher, slot));
                }
                String current = ValueTypeOperator.getSignature((IOperator)predicate);
                String expected = ValueTypeOperator.getSignature((IValueType[])new IValueType[]{ValueTypes.OBJECT_BLOCK}, (IValueType)ValueTypes.BOOLEAN);
                throw new EvaluationException(new L10NHelpers.UnlocalizedString("aspect.integrateddynamics.error.invalid_type", new Object[]{expected, current}).localize());
            };
            PROP_ITEMTARGET = input -> IItemTarget.ofCapabilityProvider(((ChanneledTargetInformation)input.getRight()).getIngredientPredicate(), (PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), ((ChanneledTargetInformation)input.getRight()).getIngredientPredicate(), ((ChanneledTargetInformation)input.getRight()).getSlot());
            PROP_EXPORT = input -> {
                if (input.hasValidTarget()) {
                    input.preTransfer();
                    TunnelHelpers.moveSingleStateOptimized(input.getNetwork(), (IPositionedAddonsNetworkIngredients)input.getChanneledNetwork(), input.getChannel(), input.getConnection(), input.getItemChannel(), -1, input.getStorage(), input.getSlot(), input.getItemStackMatcher(), input.isCraftIfFailed());
                    input.postTransfer();
                }
                return null;
            };
            PROP_IMPORT = input -> {
                if (input.hasValidTarget()) {
                    input.preTransfer();
                    TunnelHelpers.moveSingleStateOptimized(input.getNetwork(), (IPositionedAddonsNetworkIngredients)input.getChanneledNetwork(), input.getChannel(), input.getConnection(), input.getStorage(), input.getSlot(), input.getItemChannel(), -1, input.getItemStackMatcher(), false);
                    input.postTransfer();
                }
                return null;
            };
        }
    }

    public static final class Energy {
        public static final IAspectWriteActivator ACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonActivator(() -> Capabilities.NETWORK_ENERGY, CapabilityEnergy.ENERGY);
        public static final IAspectWriteDeactivator DEACTIVATOR = TunnelAspectWriteBuilders.createPositionedNetworkAddonDeactivator(() -> Capabilities.NETWORK_ENERGY, CapabilityEnergy.ENERGY);
        public static final AspectBuilder<ValueTypeBoolean.ValueBoolean, ValueTypeBoolean, Triple<PartTarget, IAspectProperties, Boolean>> BUILDER_BOOLEAN = AspectWriteBuilders.BUILDER_BOOLEAN.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("energy").handle(AspectWriteBuilders.PROP_GET_BOOLEAN).withProperties(PROPERTIES_CHANNEL);
        public static final AspectBuilder<ValueTypeInteger.ValueInteger, ValueTypeInteger, Triple<PartTarget, IAspectProperties, Integer>> BUILDER_INTEGER = AspectWriteBuilders.BUILDER_INTEGER.byMod((ModBase)IntegratedTunnels._instance).appendActivator(ACTIVATOR).appendDeactivator(DEACTIVATOR).appendKind("energy").handle(AspectWriteBuilders.PROP_GET_INTEGER).withProperties(PROPERTIES_CHANNEL);
        public static final Predicate<ValueTypeInteger.ValueInteger> VALIDATOR_INTEGER_MAXRATE = input -> input.getRawValue() <= org.cyclops.integrateddynamics.GeneralConfig.energyRateLimit;
        public static final IAspectPropertyTypeInstance<ValueTypeInteger, ValueTypeInteger.ValueInteger> PROP_RATE = new AspectPropertyTypeInstance((IValueType)ValueTypes.INTEGER, "aspect.aspecttypes.integratedtunnels.integer.energy.rate.name", AspectReadBuilders.VALIDATOR_INTEGER_POSITIVE.and(VALIDATOR_INTEGER_MAXRATE));
        public static final IAspectProperties PROPERTIES_RATE = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_RATE, PROP_EXACTAMOUNT));
        public static final IAspectProperties PROPERTIES_RATECRAFT = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_RATE, PROP_EXACTAMOUNT, PROP_CRAFT));
        public static final IAspectProperties PROPERTIES = new AspectProperties((Collection)ImmutableList.of(PROP_CHANNEL, PROP_ROUNDROBIN, PROP_EXACTAMOUNT));
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Boolean>, Triple<PartTarget, IAspectProperties, Integer>> PROP_GETRATE;
        public static final IAspectValuePropagator<Triple<PartTarget, IAspectProperties, Integer>, IEnergyTarget> PROP_ENERGYTARGET;
        public static final IAspectValuePropagator<IEnergyTarget, Void> PROP_EXPORT;
        public static final IAspectValuePropagator<IEnergyTarget, Void> PROP_IMPORT;

        static {
            PROPERTIES_RATE.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATE.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATE.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROPERTIES_RATE.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECRAFT.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES_RATECRAFT.setValue(PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1000));
            PROPERTIES_RATECRAFT.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES_RATECRAFT.setValue(PROP_CRAFT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES.setValue(PROP_CHANNEL, (IValue)ValueTypeInteger.ValueInteger.of((int)0));
            PROPERTIES.setValue(PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROPERTIES.setValue(PROP_EXACTAMOUNT, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)false));
            PROP_GETRATE = input -> Triple.of((Object)input.getLeft(), (Object)input.getMiddle(), (Object)((Boolean)input.getRight() != false ? ((ValueTypeInteger.ValueInteger)((IAspectProperties)input.getMiddle()).getValue(PROP_RATE)).getRawValue() : 0));
            PROP_ENERGYTARGET = input -> IEnergyTarget.ofTile((PartTarget)input.getLeft(), (IAspectProperties)input.getMiddle(), (Integer)input.getRight());
            PROP_EXPORT = input -> {
                if (input.hasValidTarget() && input.getAmount() != 0) {
                    input.preTransfer();
                    TunnelEnergyHelpers.moveEnergy(input.getNetwork(), (IPositionedAddonsNetworkIngredients<Integer, Boolean>)((IPositionedAddonsNetworkIngredients)input.getChanneledNetwork()), input.getChannel(), input.getEnergyChannel(), input.getStorage(), input.getAmount(), input.isExactAmount(), input.isCraftIfFailed());
                    input.postTransfer();
                }
                return null;
            };
            PROP_IMPORT = input -> {
                if (input.hasValidTarget() && input.getAmount() != 0) {
                    input.preTransfer();
                    TunnelEnergyHelpers.moveEnergy(input.getNetwork(), (IPositionedAddonsNetworkIngredients<Integer, Boolean>)((IPositionedAddonsNetworkIngredients)input.getChanneledNetwork()), input.getChannel(), input.getStorage(), input.getEnergyChannel(), input.getAmount(), input.isExactAmount(), false);
                    input.postTransfer();
                }
                return null;
            };
        }
    }
}

